/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.text.Collator;
import java.util.Comparator;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Util;

public class FieldComparator
implements Comparator<BibtexEntry> {
    private static Collator collator = Collator.getInstance();
    private String[] field;
    private String fieldName;
    boolean isNameField;
    boolean isTypeHeader;
    boolean isYearField;
    boolean isMonthField;
    boolean isNumeric;
    int multiplier;

    public FieldComparator(String field) {
        this(field, false);
    }

    public FieldComparator(String field, boolean reversed) {
        this.fieldName = field;
        this.field = field.split("/");
        this.multiplier = reversed ? -1 : 1;
        this.isTypeHeader = this.field[0].equals(GUIGlobals.TYPE_HEADER);
        this.isNameField = this.field[0].equals("author") || this.field[0].equals("editor");
        this.isYearField = this.field[0].equals("year");
        this.isMonthField = this.field[0].equals("month");
        this.isNumeric = BibtexFields.isNumeric(this.field[0]);
    }

    @Override
    public int compare(BibtexEntry e1, BibtexEntry e2) {
        Object f2;
        Object f1;
        if (this.isTypeHeader) {
            f1 = e1.getType().getName();
            f2 = e2.getType().getName();
        } else {
            f1 = this.getField(e1);
            f2 = this.getField(e2);
        }
        int localMultiplier = this.multiplier;
        if (this.isMonthField) {
            localMultiplier = -localMultiplier;
        }
        if (f1 == null) {
            return f2 == null ? 0 : localMultiplier;
        }
        if (f2 == null) {
            return -localMultiplier;
        }
        if (this.isNameField) {
            f1 = AuthorList.fixAuthorForAlphabetization((String)f1);
            f2 = AuthorList.fixAuthorForAlphabetization((String)f2);
        } else if (this.isYearField) {
            f1 = Util.toFourDigitYear((String)f1);
            f2 = Util.toFourDigitYear((String)f2);
        } else if (this.isMonthField) {
            f1 = new Integer(Util.getMonthNumber((String)f1));
            f2 = new Integer(Util.getMonthNumber((String)f2));
        }
        if (this.isNumeric) {
            Integer i1 = null;
            Integer i2 = null;
            try {
                i1 = Integer.parseInt((String)f1);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            try {
                i2 = Integer.parseInt((String)f2);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            if (i2 != null && i1 != null) {
                f1 = i1;
                f2 = i2;
            } else if (i1 != null) {
                f1 = i1;
                f2 = new Integer(i1 + 1);
            } else if (i2 != null) {
                f2 = i2;
                f1 = new Integer(i2 + 1);
            }
        }
        int result = 0;
        if (f1 instanceof Integer && f2 instanceof Integer) {
            result = ((Integer)f1).compareTo((Integer)f2);
        } else if (f2 instanceof Integer) {
            Integer f1AsInteger = new Integer(f1.toString());
            result = -f1AsInteger.compareTo((Integer)f2);
        } else if (f1 instanceof Integer) {
            Integer f2AsInteger = new Integer(f2.toString());
            result = -((Integer)f1).compareTo(f2AsInteger);
        } else {
            String ours = ((String)f1).toLowerCase();
            String theirs = ((String)f2).toLowerCase();
            result = collator.compare(ours, theirs);
        }
        return result * localMultiplier;
    }

    private Object getField(BibtexEntry entry) {
        for (int i = 0; i < this.field.length; ++i) {
            String o = entry.getField(this.field[i]);
            if (o == null) continue;
            return o;
        }
        return null;
    }

    public String getFieldName() {
        return this.fieldName;
    }
}

