/*
 * Decompiled with CFR 0.152.
 */
package org.pf.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import org.pf.file.LineProcessor;
import org.pf.text.StringUtil;

public class FileUtil {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected static final int DEFAULT_BUFFER_SIZE = 1024;
    private static FileUtil current = new FileUtil();

    private FileUtil() {
    }

    public static FileUtil current() {
        return current;
    }

    public void copyStream(InputStream inStream, OutputStream outStream) throws IOException {
        this.copyStream(inStream, outStream, 1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyStream(InputStream inStream, OutputStream outStream, int bufSize) throws IOException {
        byte[] buffer = new byte[bufSize];
        try {
            int count = inStream.read(buffer);
            while (count > -1) {
                outStream.write(buffer, 0, count);
                count = inStream.read(buffer);
            }
            Object var7_6 = null;
            this.close(inStream);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.close(inStream);
            this.close(outStream);
            throw throwable;
        }
        this.close(outStream);
    }

    public String readTextFrom(InputStream inStream) throws IOException {
        StringWriter writer = new StringWriter(1024);
        this.copyText(inStream, writer);
        return writer.toString();
    }

    public String readTextFrom(String filename) throws IOException {
        FileInputStream inStream = new FileInputStream(filename);
        return this.readTextFrom(inStream);
    }

    public String readTextFrom(File file) throws IOException {
        FileInputStream inStream = new FileInputStream(file);
        return this.readTextFrom(inStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyText(Reader reader, final StringWriter writer) throws IOException {
        BufferedReader bufReader = new BufferedReader(reader);
        try {
            LineProcessor processor2 = new LineProcessor(){

                public boolean processLine(String line, int lineNo) {
                    if (lineNo > 1) {
                        writer.write(LINE_SEPARATOR);
                    }
                    writer.write(line);
                    return true;
                }
            };
            this.processTextLines(bufReader, processor2);
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            bufReader.close();
            throw throwable;
        }
        bufReader.close();
    }

    public void processTextLines(String filename, LineProcessor processor2) throws IOException {
        if (filename == null) {
            throw new IllegalArgumentException("filename must not be null");
        }
        FileInputStream inStream = new FileInputStream(filename);
        this.processTextLines(inStream, processor2);
    }

    public void processTextLines(InputStream inStream, LineProcessor processor2) throws IOException {
        if (inStream == null) {
            throw new IllegalArgumentException("inStream must not be null");
        }
        InputStreamReader reader = new InputStreamReader(inStream);
        this.processTextLines(reader, processor2);
    }

    public void processTextLines(Reader reader, LineProcessor processor2) throws IOException {
        String line;
        int counter = 0;
        boolean continue_reading = true;
        if (reader == null) {
            throw new IllegalArgumentException("reader must not be null");
        }
        if (processor2 == null) {
            throw new IllegalArgumentException("processor must not be null");
        }
        BufferedReader bufReader = new BufferedReader(reader);
        while (continue_reading && bufReader.ready() && (line = bufReader.readLine()) != null) {
            continue_reading = processor2.processLine(line, ++counter);
        }
    }

    public boolean close(InputStream stream) {
        if (stream == null) {
            return false;
        }
        try {
            stream.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean close(OutputStream stream) {
        if (stream == null) {
            return false;
        }
        try {
            stream.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public String standardize(String filename) {
        if (filename == null) {
            return null;
        }
        return this.standardizeFilename(filename);
    }

    public String javaFilename(String filename) {
        if (filename == null) {
            return null;
        }
        return filename.replace('\\', '/');
    }

    protected void copyText(InputStream inStream, StringWriter writer) throws IOException {
        this.copyText(new InputStreamReader(inStream), writer);
    }

    protected String standardizeFilename(String filename) {
        filename = this.javaFilename(filename);
        boolean startedFromRoot = filename.startsWith("/");
        String[] nameElements = this.str().parts(filename, "/");
        if (nameElements.length > 0) {
            boolean hasDriveLetter = nameElements[0].endsWith(":");
            if (hasDriveLetter) {
                nameElements[0] = nameElements[0].toUpperCase();
            } else if (startedFromRoot) {
                nameElements = this.str().append(new String[]{""}, nameElements);
            }
            boolean isAbsolute = hasDriveLetter || startedFromRoot;
            for (int i = 0; i < nameElements.length; ++i) {
                int index;
                if (".".equals(nameElements[i])) {
                    nameElements[i] = null;
                    continue;
                }
                if (!"..".equals(nameElements[i]) || (index = this.indexOfPreceedingNotNullElement(nameElements, i - 1)) < 0 || index <= 0 && isAbsolute) continue;
                nameElements[i] = null;
                nameElements[index] = null;
            }
            nameElements = this.str().removeNull(nameElements);
            return this.str().asString(nameElements, "/");
        }
        return "";
    }

    protected int indexOfPreceedingNotNullElement(String[] elements, int start) {
        for (int i = start; i >= 0; --i) {
            if (elements[i] == null) continue;
            if ("..".equals(elements[i])) {
                return -1;
            }
            return i;
        }
        return -1;
    }

    protected StringUtil str() {
        return StringUtil.current();
    }
}

