/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.win32;

import com.aelitis.azureus.core.drivedetector.DriveDetectedInfo;
import com.aelitis.azureus.core.drivedetector.DriveDetector;
import com.aelitis.azureus.core.drivedetector.DriveDetectorFactory;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.platform.win32.access.AEWin32Manager;
import org.gudy.azureus2.platform.win32.access.impl.AEWin32AccessInterface;

public class Win32UIEnhancer {
    public static final boolean DEBUG = false;
    public static final int SHGFI_ICON = 256;
    public static final int SHGFI_SMALLICON = 1;
    public static final int SHGFI_USEFILEATTRIBUTES = 16;
    public static final int SHGFI_LARGEICON = 2;
    public static final int WM_DEVICECHANGE = 537;
    public static final int DBT_DEVICEARRIVAL = 32768;
    public static final int DBT_DEVICEREMOVECOMPLETE = 32772;
    public static final int DBT_DEVTYP_VOLUME = 2;
    public static final int FILE_ATTRIBUTE_NORMAL = 128;
    private static int messageProcInt;
    private static long messageProcLong;
    private static Object messageCallback;
    private static DriveDetectedInfo loc;
    private static Class<?> claOS;
    private static boolean useLong;
    private static Class<?> claCallback;
    private static Constructor<?> constCallBack;
    private static Method mCallback_getAddress;
    private static Method mSetWindowLongPtr;
    private static int OS_GWLP_WNDPROC;
    private static Method mOS_memmove_byte;
    private static Method mOS_memmove_int;
    private static boolean isUnicode;
    private static Class<?> claSHFILEINFO;
    private static Class<?> claSHFILEINFOA;
    private static Class<?> claSHFILEINFOW;
    private static Class<?> claTCHAR;
    private static Method mSHGetFileInfo;
    private static Method mImage_win32_new;
    private static Constructor<?> constTCHAR3;
    private static int SHFILEINFO_sizeof;

    public static Image getFileIcon(File file, boolean big) {
        try {
            int flags = 256;
            flags |= big ? 2 : 1;
            if (!file.exists()) {
                flags |= 0x10;
            }
            Object shfi = isUnicode ? claSHFILEINFOW.newInstance() : claSHFILEINFOA.newInstance();
            Object pszPath = constTCHAR3.newInstance(0, file.getAbsolutePath(), true);
            mSHGetFileInfo.invoke(null, pszPath, file.isDirectory() ? 16 : 128, shfi, SHFILEINFO_sizeof, flags);
            Field fldHIcon = claSHFILEINFO.getField("hIcon");
            if (fldHIcon.getLong(shfi) == 0L) {
                return null;
            }
            Image image = null;
            image = useLong ? (Image)mImage_win32_new.invoke(null, null, 1, fldHIcon.getLong(shfi)) : (Image)mImage_win32_new.invoke(null, null, 1, fldHIcon.getInt(shfi));
            return image;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void initMainShell(Shell shell) {
        Shell subshell = new Shell(shell);
        try {
            messageCallback = constCallBack.newInstance(Win32UIEnhancer.class, "messageProc2", 4);
            Object oHandle = subshell.getClass().getField("handle").get(subshell);
            if (useLong) {
                Number n = (Number)mCallback_getAddress.invoke(messageCallback, new Object[0]);
                messageProcLong = n.longValue();
                if (messageProcLong != 0L) {
                    mSetWindowLongPtr.invoke(null, oHandle, OS_GWLP_WNDPROC, messageProcLong);
                }
            } else {
                Number n = (Number)mCallback_getAddress.invoke(messageCallback, new Object[0]);
                messageProcInt = n.intValue();
                if (messageProcInt != 0) {
                    mSetWindowLongPtr.invoke(null, oHandle, OS_GWLP_WNDPROC, messageProcInt);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        new AEThread2("Async:USB"){

            public void run() {
                String version;
                if (Constants.isWindows7OrHigher && Constants.compareVersions("1.21", version = AEWin32Manager.getAccessor(false).getVersion()) > 0) {
                    return;
                }
                Map<File, Map> drives = AEWin32Manager.getAccessor(false).getAllDrives();
                if (drives != null) {
                    for (File file : drives.keySet()) {
                        Map driveInfo = drives.get(file);
                        boolean isWritableUSB = AEWin32Manager.getAccessor(false).isUSBDrive(driveInfo);
                        driveInfo.put("isWritableUSB", isWritableUSB);
                        DriveDetectorFactory.getDeviceDetector().driveDetected(file, driveInfo);
                    }
                }
            }
        }.start();
    }

    static int messageProc2(int hwnd, int msg, int wParam, int lParam) {
        return (int)Win32UIEnhancer.messageProc2((long)hwnd, (long)msg, (long)wParam, (long)lParam);
    }

    static long messageProc2(long hwnd, long msg, long wParam, long lParam) {
        try {
            switch ((int)msg) {
                case 537: {
                    if (wParam == 32768L) {
                        int[] st = new int[3];
                        if (useLong) {
                            mOS_memmove_int.invoke(null, st, lParam, 12L);
                        } else {
                            mOS_memmove_int.invoke(null, st, (int)lParam, 12);
                        }
                        if (st[1] == 2) {
                            byte[] b = new byte[st[0]];
                            if (useLong) {
                                mOS_memmove_byte.invoke(null, b, lParam, st[0]);
                            } else {
                                mOS_memmove_byte.invoke(null, b, (int)lParam, st[0]);
                            }
                            long unitMask = (b[12] & 0xFF) + ((b[13] & 0xFF) << 8) + ((b[14] & 0xFF) << 16) + ((b[15] & 3) << 24);
                            char letter = '?';
                            for (int i = 0; i < 26; ++i) {
                                if (((long)(1 << i) & unitMask) <= 0L) continue;
                                letter = (char)(65 + i);
                                Map driveInfo = AEWin32AccessInterface.getDriveInfo(letter);
                                boolean isWritableUSB = AEWin32Manager.getAccessor(false).isUSBDrive(driveInfo);
                                driveInfo.put("isWritableUSB", isWritableUSB);
                                DriveDetector driveDetector = DriveDetectorFactory.getDeviceDetector();
                                driveDetector.driveDetected(new File(letter + ":\\"), driveInfo);
                            }
                        }
                    } else {
                        DriveDetectedInfo[] existingDrives;
                        if (wParam != 32772L) break;
                        int[] st = new int[3];
                        if (useLong) {
                            mOS_memmove_int.invoke(null, st, lParam, 12L);
                        } else {
                            mOS_memmove_int.invoke(null, st, (int)lParam, 12);
                        }
                        if (st[1] != 2) break;
                        byte[] b = new byte[st[0]];
                        if (useLong) {
                            mOS_memmove_byte.invoke(null, b, lParam, st[0]);
                        } else {
                            mOS_memmove_byte.invoke(null, b, (int)lParam, st[0]);
                        }
                        long unitMask = (b[12] & 0xFF) + ((b[13] & 0xFF) << 8) + ((b[14] & 0xFF) << 16) + ((b[15] & 3) << 24);
                        char letter = '?';
                        DriveDetector driveDetector = DriveDetectorFactory.getDeviceDetector();
                        for (int i = 0; i < 26; ++i) {
                            if (((long)(1 << i) & unitMask) <= 0L) continue;
                            letter = (char)(65 + i);
                            driveDetector.driveRemoved(new File(letter + ":\\"));
                        }
                        Map<File, Map> drives = AEWin32Manager.getAccessor(false).getAllDrives();
                        if (drives == null) break;
                        for (DriveDetectedInfo existingDrive : existingDrives = driveDetector.getDetectedDriveInfo()) {
                            File existingDriveFile = existingDrive.getLocation();
                            boolean found = drives.containsKey(existingDriveFile);
                            if (found) continue;
                            driveDetector.driveRemoved(existingDriveFile);
                        }
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0L;
    }

    static {
        try {
            claOS = Class.forName("org.eclipse.swt.internal.win32.OS");
            isUnicode = claOS.getDeclaredField("IsUnicode").getBoolean(null);
            claSHFILEINFO = Class.forName("org.eclipse.swt.internal.win32.SHFILEINFO");
            SHFILEINFO_sizeof = claSHFILEINFO.getField("sizeof").getInt(null);
            claSHFILEINFOA = Class.forName("org.eclipse.swt.internal.win32.SHFILEINFOA");
            claSHFILEINFOW = Class.forName("org.eclipse.swt.internal.win32.SHFILEINFOW");
            claTCHAR = Class.forName("org.eclipse.swt.internal.win32.TCHAR");
            constTCHAR3 = claTCHAR.getConstructor(Integer.TYPE, String.class, Boolean.TYPE);
            mSHGetFileInfo = claOS.getMethod("SHGetFileInfo", claTCHAR, Integer.TYPE, claSHFILEINFO, Integer.TYPE, Integer.TYPE);
            claCallback = Class.forName("org.eclipse.swt.internal.Callback");
            constCallBack = claCallback.getDeclaredConstructor(Object.class, String.class, Integer.TYPE);
            mCallback_getAddress = claCallback.getDeclaredMethod("getAddress", new Class[0]);
            try {
                mSetWindowLongPtr = claOS.getMethod("SetWindowLongPtr", Integer.TYPE, Integer.TYPE, Integer.TYPE);
                useLong = false;
                mOS_memmove_byte = claOS.getMethod("memmove", byte[].class, Integer.TYPE, Integer.TYPE);
                mOS_memmove_int = claOS.getMethod("memmove", int[].class, Integer.TYPE, Integer.TYPE);
                mImage_win32_new = Image.class.getMethod("win32_new", Device.class, Integer.TYPE, Integer.TYPE);
            }
            catch (Exception e) {
                mSetWindowLongPtr = claOS.getMethod("SetWindowLongPtr", Long.TYPE, Integer.TYPE, Long.TYPE);
                useLong = true;
                mOS_memmove_byte = claOS.getMethod("memmove", byte[].class, Long.TYPE, Long.TYPE);
                mOS_memmove_int = claOS.getMethod("memmove", int[].class, Long.TYPE, Long.TYPE);
                mImage_win32_new = Image.class.getMethod("win32_new", Device.class, Integer.TYPE, Long.TYPE);
            }
            OS_GWLP_WNDPROC = (Integer)claOS.getField("GWLP_WNDPROC").get(null);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

