/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.utils;

import org.eclipse.swt.graphics.Rectangle;

public class CoordinateTransform {
    final int extWidth;
    final int extHeight;
    int offsetX = 0;
    int offsetY = 0;
    double scaleX = 1.0;
    double scaleY = 1.0;

    public CoordinateTransform(Rectangle exteriorBounds) {
        this.extWidth = exteriorBounds.width;
        this.extHeight = exteriorBounds.height;
    }

    public int x(int x) {
        return (int)Math.round((double)this.offsetX + (double)x * this.scaleX);
    }

    public int y(int y) {
        return (int)Math.round((double)this.offsetY + (double)y * this.scaleY);
    }

    private int w(int w) {
        return (int)Math.round((double)w * this.scaleX);
    }

    private int h(int h) {
        return (int)Math.ceil((double)h * this.scaleY);
    }

    public void scale(double x, double y) {
        this.scaleX *= x;
        this.scaleY *= y;
    }

    public void shiftExternal(int x, int y) {
        this.offsetX += x;
        this.offsetY += y;
    }

    public void shiftInternal(int x, int y) {
        this.offsetX = (int)((double)this.offsetX + (double)x * this.scaleX);
        this.offsetY = (int)((double)this.offsetY + (double)y * this.scaleY);
    }

    private void calcFromDimensions(int internalWidth, int internalHeight, int marginLeft, int marginRight, int marginTop, int marginBottom, boolean leftToRight, boolean topDown) {
        this.shiftExternal(leftToRight ? 0 : this.extWidth, topDown ? 0 : this.extHeight);
        this.scale(leftToRight ? 1.0 : -1.0, topDown ? 1.0 : -1.0);
        this.shiftInternal(leftToRight ? marginLeft : marginRight, topDown ? marginTop : marginBottom);
        this.scale(Math.round((double)(this.extWidth - marginLeft - marginRight) / (1.0 * (double)internalWidth)), Math.round((double)(this.extHeight - marginTop - marginBottom) / (1.0 * (double)internalHeight)));
    }
}

