/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.peers;

import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class HostNameItem
extends CoreTableColumn
implements TableCellRefreshListener {
    public static final String COLUMN_ID = "host";

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"identification"});
    }

    public HostNameItem(String table_id) {
        super(COLUMN_ID, -1, 100, table_id);
        this.setRefreshInterval(-2);
        this.setObfustication(true);
    }

    public void refresh(TableCell cell) {
        String addr;
        PEPeer peer = (PEPeer)cell.getDataSource();
        String string = addr = peer == null ? "" : peer.getIPHostName();
        if (cell.setText(addr) && !addr.equals(peer.getIp())) {
            String[] l = addr.split("\\.");
            StringBuffer buf = new StringBuffer();
            for (int i = l.length - 1; i >= 0; --i) {
                buf.append(l[i]);
                buf.append('.');
            }
            cell.setSortValue((Comparable)((Object)buf.toString()));
        }
    }
}

