/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.files;

import java.io.File;
import java.io.IOException;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.FilesView;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class PathItem
extends CoreTableColumn
implements TableCellRefreshListener {
    public PathItem() {
        super("path", 1, -2, 200, "Files");
    }

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
        info.setProficiency((byte)0);
    }

    public void refresh(TableCell cell) {
        DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
        cell.setText(PathItem.determinePath(fileInfo2));
    }

    private static String determinePath(DiskManagerFileInfo fileInfo2) {
        String dl_save_path;
        if (fileInfo2 == null) {
            return "";
        }
        boolean has_link = fileInfo2.getLink() != null;
        boolean show_full_path = FilesView.show_full_path;
        DownloadManager dm = fileInfo2.getDownloadManager();
        File dl_save_path_file = dm.getAbsoluteSaveLocation();
        TOTorrent torrent = dm.getTorrent();
        if (torrent != null && torrent.isSimpleTorrent()) {
            dl_save_path_file = dl_save_path_file.getParentFile();
        }
        if (!(dl_save_path = dl_save_path_file.getPath()).endsWith(File.separator)) {
            dl_save_path = dl_save_path + File.separator;
        }
        File file = fileInfo2.getFile(true);
        if (has_link && !show_full_path) {
            show_full_path = !file.getAbsolutePath().startsWith(dl_save_path);
        }
        String path = "";
        if (show_full_path) {
            try {
                path = file.getParentFile().getCanonicalPath();
            }
            catch (IOException e) {
                path = file.getParentFile().getAbsolutePath();
            }
            if (!path.endsWith(File.separator)) {
                path = path + File.separator;
            }
        } else {
            path = file.getAbsolutePath().substring(dl_save_path.length());
            if (path.length() == 0) {
                path = File.separator;
            } else {
                int pos;
                if (path.charAt(0) == File.separatorChar) {
                    path = path.substring(1);
                }
                path = (pos = path.lastIndexOf(File.separator)) > 0 ? File.separator + path.substring(0, pos) : File.separator;
            }
        }
        return path;
    }
}

