/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import java.io.File;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.ChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.DirectoryParameter;
import org.gudy.azureus2.ui.swt.config.IntListParameter;
import org.gudy.azureus2.ui.swt.config.IntParameter;
import org.gudy.azureus2.ui.swt.config.Parameter;
import org.gudy.azureus2.ui.swt.config.StringListParameter;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;

public class ConfigSectionInterfaceDisplay
implements UISWTConfigSection {
    private static final String MSG_PREFIX = "ConfigView.section.style.";

    public String configSectionGetParentSection() {
        return "style";
    }

    public String configSectionGetName() {
        return "display";
    }

    public void configSectionSave() {
    }

    public void configSectionDelete() {
    }

    public int maxUserMode() {
        return 2;
    }

    public Composite configSectionCreate(Composite parent) {
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        boolean isAZ3 = COConfigurationManager.getStringParameter("ui").equals("az3");
        Composite cSection = new Composite(parent, 0);
        cSection.setLayoutData(new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        cSection.setLayout(layout);
        new BooleanParameter(cSection, "Show Download Basket", "ConfigView.section.style.showdownloadbasket");
        if (!isAZ3) {
            new BooleanParameter(cSection, "IconBar.enabled", "ConfigView.section.style.showiconbar");
        }
        Group cStatusBar = new Group(cSection, 0);
        Messages.setLanguageText(cStatusBar, "ConfigView.section.style.status");
        layout = new GridLayout();
        layout.numColumns = 1;
        cStatusBar.setLayout(layout);
        cStatusBar.setLayoutData(new GridData());
        new BooleanParameter((Composite)cStatusBar, "Status Area Show SR", "ConfigView.section.style.status.show_sr");
        new BooleanParameter((Composite)cStatusBar, "Status Area Show NAT", "ConfigView.section.style.status.show_nat");
        new BooleanParameter((Composite)cStatusBar, "Status Area Show DDB", "ConfigView.section.style.status.show_ddb");
        new BooleanParameter((Composite)cStatusBar, "Status Area Show IPF", "ConfigView.section.style.status.show_ipf");
        new BooleanParameter((Composite)cStatusBar, "status.rategraphs", "ConfigView.section.style.status.show_rategraphs");
        new BooleanParameter(cSection, "Add URL Silently", "ConfigView.section.style.addurlsilently");
        new BooleanParameter(cSection, "suppress_file_download_dialog", "ConfigView.section.interface.display.suppress.file.download.dialog");
        new BooleanParameter(cSection, "show_torrents_menu", "Menu.show.torrent.menu");
        if (Constants.isWindowsXP) {
            final Button enableXPStyle = new Button(cSection, 32);
            Messages.setLanguageText(enableXPStyle, "ConfigView.section.style.enableXPStyle");
            boolean enabled = false;
            boolean valid = false;
            try {
                File f = new File(System.getProperty("java.home") + "\\bin\\javaw.exe.manifest");
                if (f.exists()) {
                    enabled = true;
                }
                if ((f = FileUtil.getApplicationFile("javaw.exe.manifest")).exists()) {
                    valid = true;
                }
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
                valid = false;
            }
            enableXPStyle.setEnabled(valid);
            enableXPStyle.setSelection(enabled);
            enableXPStyle.addListener(13, new Listener(){

                public void handleEvent(Event arg0) {
                    if (enableXPStyle.getSelection()) {
                        try {
                            File fDest = new File(System.getProperty("java.home") + "\\bin\\javaw.exe.manifest");
                            File fOrigin = new File("javaw.exe.manifest");
                            if (!fDest.exists() && fOrigin.exists()) {
                                FileUtil.copyFile(fOrigin, fDest);
                            }
                        }
                        catch (Exception e) {
                            Debug.printStackTrace(e);
                        }
                    } else {
                        try {
                            File fDest = new File(System.getProperty("java.home") + "\\bin\\javaw.exe.manifest");
                            fDest.delete();
                        }
                        catch (Exception e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
            });
        }
        if (Constants.isOSX) {
            new BooleanParameter(cSection, "enable_small_osx_fonts", "ConfigView.section.style.osx_small_fonts");
        }
        if (userMode > 0) {
            Group cUnits = new Group(cSection, 0);
            Messages.setLanguageText(cUnits, "ConfigView.section.style.units");
            layout = new GridLayout();
            layout.numColumns = 1;
            cUnits.setLayout(layout);
            cUnits.setLayoutData(new GridData());
            new BooleanParameter((Composite)cUnits, "config.style.useSIUnits", "ConfigView.section.style.useSIUnits");
            new BooleanParameter((Composite)cUnits, "config.style.forceSIValues", "ConfigView.section.style.forceSIValues");
            new BooleanParameter((Composite)cUnits, "config.style.useUnitsRateBits", "ConfigView.section.style.useUnitsRateBits");
            new BooleanParameter((Composite)cUnits, "config.style.doNotUseGB", "ConfigView.section.style.doNotUseGB");
            new BooleanParameter((Composite)cUnits, "config.style.dataStatsOnly", "ConfigView.section.style.dataStatsOnly");
            new BooleanParameter((Composite)cUnits, "config.style.separateProtDataStats", "ConfigView.section.style.separateProtDataStats");
        }
        if (userMode > 1) {
            BooleanParameter fMoz = new BooleanParameter(cSection, "swt.forceMozilla", "ConfigView.section.style.forceMozilla");
            Composite pArea = new Composite(cSection, 0);
            pArea.setLayout(new GridLayout(3, false));
            pArea.setLayoutData(new GridData(768));
            Messages.setLanguageText(new Label(pArea, 0), "ConfigView.section.style.xulRunnerPath");
            DirectoryParameter xulDir = new DirectoryParameter(pArea, "swt.xulRunner.path", "");
            fMoz.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(((Parameter)xulDir).getControls(), false));
        }
        Composite cArea = new Composite(cSection, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        cArea.setLayout(layout);
        cArea.setLayoutData(new GridData());
        Label label = new Label(cArea, 0);
        Messages.setLanguageText(label, "ConfigView.section.style.guiUpdate");
        int[] values = new int[]{100, 250, 500, 1000, 2000, 5000, 10000, 15000};
        String[] labels = new String[]{"100 ms", "250 ms", "500 ms", "1 s", "2 s", "5 s", "10 s", "15 s"};
        new IntListParameter(cArea, "GUI Refresh", 1000, labels, values);
        label = new Label(cArea, 0);
        Messages.setLanguageText(label, "ConfigView.section.style.inactiveUpdate");
        GridData gridData = new GridData();
        IntParameter inactiveUpdate = new IntParameter(cArea, "Refresh When Inactive", 1, -1);
        inactiveUpdate.setLayoutData(gridData);
        label = new Label(cArea, 0);
        Messages.setLanguageText(label, "ConfigView.section.style.graphicsUpdate");
        gridData = new GridData();
        IntParameter graphicUpdate = new IntParameter(cArea, "Graphics Update", 1, -1);
        graphicUpdate.setLayoutData(gridData);
        if (PlatformManagerFactory.getPlatformManager().hasCapability(PlatformManagerCapabilities.ShowFileInBrowser)) {
            BooleanParameter bp = new BooleanParameter(cSection, "MyTorrentsView.menu.show_parent_folder_enabled", "ConfigView.section.style.use_show_parent_folder");
            Messages.setLanguageText((Widget)bp.getControl(), "ConfigView.section.style.use_show_parent_folder", new String[]{MessageText.getString("MyTorrentsView.menu.open_parent_folder"), MessageText.getString("MyTorrentsView.menu.explore")});
            if (Constants.isOSX) {
                new BooleanParameter(cSection, "FileBrowse.usePathFinder", "ConfigView.section.style.usePathFinder");
            }
        }
        if (Constants.isOSX_10_5_OrHigher) {
            Composite cSWT = new Composite(cSection, 0);
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 2;
            cSWT.setLayout(layout);
            cSWT.setLayoutData(new GridData());
            label = new Label(cSWT, 0);
            label.setText("SWT Library");
            String[] swtLibraries = new String[]{"carbon", "cocoa"};
            new StringListParameter(cSWT, "ConfigView.section.style.swt.library.selection", swtLibraries, swtLibraries);
        }
        return cSection;
    }
}

