/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.peer.PEPeerSource;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.LinkLabel;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.ChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.IntParameter;
import org.gudy.azureus2.ui.swt.config.Parameter;
import org.gudy.azureus2.ui.swt.config.ParameterChangeAdapter;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;

public class ConfigSectionConnection
implements UISWTConfigSection {
    private static final String CFG_PREFIX = "ConfigView.section.connection.";

    public String configSectionGetParentSection() {
        return "root";
    }

    public String configSectionGetName() {
        return "server";
    }

    public void configSectionSave() {
    }

    public void configSectionDelete() {
    }

    public int maxUserMode() {
        return 2;
    }

    public Composite configSectionCreate(Composite parent) {
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        Composite cSection = new Composite(parent, 0);
        GridData gridData = new GridData(272);
        cSection.setLayoutData(gridData);
        GridLayout layout = new GridLayout();
        cSection.setLayout(layout);
        Composite cMiniArea = new Composite(cSection, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        cMiniArea.setLayout(layout);
        gridData = new GridData(768);
        cMiniArea.setLayoutData(gridData);
        final boolean separate_ports = userMode > 1 || COConfigurationManager.getIntParameter("TCP.Listen.Port") != COConfigurationManager.getIntParameter("UDP.Listen.Port");
        Label label = new Label(cMiniArea, 0);
        Messages.setLanguageText(label, separate_ports ? "ConfigView.label.tcplistenport" : "ConfigView.label.serverport");
        gridData = new GridData();
        label.setLayoutData(gridData);
        final IntParameter tcplisten = new IntParameter(cMiniArea, "TCP.Listen.Port", 1, 65535);
        gridData = new GridData();
        tcplisten.setLayoutData(gridData);
        tcplisten.addChangeListener(new ParameterChangeAdapter(){

            public void intParameterChanging(Parameter p, int toValue) {
                if (toValue == 6880) {
                    toValue = 6881;
                    tcplisten.setValue(toValue);
                }
                if (!separate_ports) {
                    COConfigurationManager.setParameter("UDP.Listen.Port", toValue);
                    COConfigurationManager.setParameter("UDP.NonData.Listen.Port", toValue);
                }
            }
        });
        if (separate_ports) {
            label = new Label(cMiniArea, 0);
            Messages.setLanguageText(label, "ConfigView.label.udplistenport");
            gridData = new GridData(128);
            label.setLayoutData(gridData);
            final IntParameter udp_listen = new IntParameter(cMiniArea, "UDP.Listen.Port", 1, 65535);
            gridData = new GridData();
            udp_listen.setLayoutData(gridData);
            final boolean MULTI_UDP = false;
            udp_listen.addChangeListener(new ParameterChangeAdapter(){

                public void intParameterChanging(Parameter p, int toValue) {
                    if (toValue == 6880) {
                        toValue = 6881;
                        udp_listen.setValue(toValue);
                    }
                    if (!MULTI_UDP) {
                        COConfigurationManager.setParameter("UDP.NonData.Listen.Port", toValue);
                    }
                }
            });
            if (MULTI_UDP) {
                Composite cNonDataUDPArea = new Composite(cSection, 0);
                layout = new GridLayout();
                layout.numColumns = 2;
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                cNonDataUDPArea.setLayout(layout);
                gridData = new GridData(768);
                cNonDataUDPArea.setLayoutData(gridData);
                final BooleanParameter commonUDP = new BooleanParameter(cNonDataUDPArea, "UDP.NonData.Listen.Port.Same", "ConfigView.section.connection.nondata.udp.same");
                gridData = new GridData();
                gridData.horizontalIndent = 16;
                commonUDP.setLayoutData(gridData);
                final IntParameter non_data_udp_listen = new IntParameter(cNonDataUDPArea, "UDP.NonData.Listen.Port");
                non_data_udp_listen.addChangeListener(new ParameterChangeAdapter(){

                    public void intParameterChanging(Parameter p, int toValue) {
                        if (toValue == 6880) {
                            toValue = 6881;
                            non_data_udp_listen.setValue(toValue);
                        }
                    }
                });
                udp_listen.addChangeListener(new ParameterChangeAdapter(){

                    public void parameterChanged(Parameter p, boolean caused_internally) {
                        int udp_listen_port;
                        if (commonUDP.isSelected() && (udp_listen_port = udp_listen.getValue()) != 6880) {
                            COConfigurationManager.setParameter("UDP.NonData.Listen.Port", udp_listen_port);
                            non_data_udp_listen.setValue(udp_listen_port);
                        }
                    }
                });
                gridData = new GridData();
                non_data_udp_listen.setLayoutData(gridData);
                commonUDP.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(non_data_udp_listen.getControls(), true));
                commonUDP.addChangeListener(new ParameterChangeAdapter(){

                    public void parameterChanged(Parameter p, boolean caused_internally) {
                        if (commonUDP.isSelected()) {
                            int udp_listen_port = COConfigurationManager.getIntParameter("UDP.Listen.Port");
                            if (COConfigurationManager.getIntParameter("UDP.NonData.Listen.Port") != udp_listen_port) {
                                COConfigurationManager.setParameter("UDP.NonData.Listen.Port", udp_listen_port);
                                non_data_udp_listen.setValue(udp_listen_port);
                            }
                        }
                    }
                });
                BooleanParameter enable_tcp = new BooleanParameter(cNonDataUDPArea, "TCP.Listen.Port.Enable", "ConfigView.section.connection.tcp.enable");
                gridData = new GridData();
                enable_tcp.setLayoutData(gridData);
                label = new Label(cNonDataUDPArea, 0);
                BooleanParameter enable_udp = new BooleanParameter(cNonDataUDPArea, "UDP.Listen.Port.Enable", "ConfigView.section.connection.udp.enable");
                gridData = new GridData();
                enable_udp.setLayoutData(gridData);
                label = new Label(cNonDataUDPArea, 0);
                enable_tcp.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(tcplisten));
                enable_udp.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(udp_listen));
            }
        }
        if (userMode > 1) {
            BooleanParameter prefer_udp = new BooleanParameter(cMiniArea, "peercontrol.prefer.udp", "ConfigView.section.connection.prefer.udp");
            gridData = new GridData();
            prefer_udp.setLayoutData(gridData);
            label = new Label(cMiniArea, 0);
        }
        if (userMode < 2) {
            label = new Label(cSection, 0);
            gridData = new GridData();
            label.setLayoutData(gridData);
            label.setText(MessageText.getString("Utils.link.visit") + ":");
            Label linkLabel = new Label(cSection, 0);
            linkLabel.setText(MessageText.getString("ConfigView.section.connection.serverport.wiki"));
            linkLabel.setData("http://wiki.vuze.com/w/Why_ports_like_6881_are_no_good_choice");
            linkLabel.setCursor(linkLabel.getDisplay().getSystemCursor(21));
            linkLabel.setForeground(Colors.blue);
            gridData = new GridData();
            linkLabel.setLayoutData(gridData);
            linkLabel.addMouseListener(new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent arg0) {
                    Utils.launch((String)((Label)arg0.widget).getData());
                }

                public void mouseDown(MouseEvent arg0) {
                    Utils.launch((String)((Label)arg0.widget).getData());
                }
            });
        }
        if (userMode > 0) {
            Group http_group = new Group(cSection, 0);
            Messages.setLanguageText(http_group, "ConfigView.section.connection.group.http");
            GridLayout http_layout = new GridLayout();
            http_layout.numColumns = 2;
            http_group.setLayout(http_layout);
            gridData = new GridData(768);
            http_group.setLayoutData(gridData);
            label = new Label(http_group, 64);
            Messages.setLanguageText(label, "ConfigView.section.connection.group.http.info");
            new LinkLabel(http_group, "ConfigView.label.please.visit.here", "http://wiki.vuze.com/w/HTTP_Seeding");
            BooleanParameter enable_http = new BooleanParameter((Composite)http_group, "HTTP.Data.Listen.Port.Enable", "ConfigView.section.connection.http.enable");
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            enable_http.setLayoutData(gridData);
            label = new Label(http_group, 0);
            Messages.setLanguageText(label, "ConfigView.section.connection.http.port");
            IntParameter http_port = new IntParameter(http_group, "HTTP.Data.Listen.Port");
            gridData = new GridData();
            http_port.setLayoutData(gridData);
            label = new Label(http_group, 0);
            Messages.setLanguageText(label, "ConfigView.section.connection.http.portoverride");
            IntParameter http_port_override = new IntParameter(http_group, "HTTP.Data.Listen.Port.Override");
            gridData = new GridData();
            http_port_override.setLayoutData(gridData);
            enable_http.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(http_port));
            enable_http.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(http_port_override));
        }
        if (userMode > 0) {
            Group peer_sources_group = new Group(cSection, 0);
            Messages.setLanguageText(peer_sources_group, "ConfigView.section.connection.group.peersources");
            GridLayout peer_sources_layout = new GridLayout();
            peer_sources_group.setLayout(peer_sources_layout);
            gridData = new GridData(768);
            peer_sources_group.setLayoutData(gridData);
            label = new Label(peer_sources_group, 64);
            Messages.setLanguageText(label, "ConfigView.section.connection.group.peersources.info");
            gridData = new GridData();
            label.setLayoutData(gridData);
            for (int i = 0; i < PEPeerSource.PS_SOURCES.length; ++i) {
                String p = PEPeerSource.PS_SOURCES[i];
                String config_name = "Peer Source Selection Default." + p;
                String msg_text = "ConfigView.section.connection.peersource." + p;
                BooleanParameter peer_source = new BooleanParameter((Composite)peer_sources_group, config_name, msg_text);
                gridData = new GridData();
                peer_source.setLayoutData(gridData);
            }
            if (userMode > 1) {
                Group networks_group = new Group(cSection, 0);
                Messages.setLanguageText(networks_group, "ConfigView.section.connection.group.networks");
                GridLayout networks_layout = new GridLayout();
                networks_group.setLayout(networks_layout);
                gridData = new GridData(768);
                networks_group.setLayoutData(gridData);
                label = new Label(networks_group, 0);
                Messages.setLanguageText(label, "ConfigView.section.connection.group.networks.info");
                gridData = new GridData();
                label.setLayoutData(gridData);
                for (int i = 0; i < AENetworkClassifier.AT_NETWORKS.length; ++i) {
                    String nn = AENetworkClassifier.AT_NETWORKS[i];
                    String config_name = "Network Selection Default." + nn;
                    String msg_text = "ConfigView.section.connection.networks." + nn;
                    BooleanParameter network = new BooleanParameter((Composite)networks_group, config_name, msg_text);
                    gridData = new GridData();
                    network.setLayoutData(gridData);
                }
                label = new Label(networks_group, 0);
                gridData = new GridData();
                label.setLayoutData(gridData);
                BooleanParameter network_prompt = new BooleanParameter((Composite)networks_group, "Network Selection Prompt", "ConfigView.section.connection.networks.prompt");
                gridData = new GridData();
                network_prompt.setLayoutData(gridData);
            }
        }
        return cSection;
    }
}

