/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.ui.common.ToolBarEnabler;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.impl.TableColumnManager;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.ui.swt.DelayedListenerMultiCombiner;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.debug.ObfusticateImage;
import org.gudy.azureus2.ui.swt.views.AbstractIView;
import org.gudy.azureus2.ui.swt.views.IViewExtension;
import org.gudy.azureus2.ui.swt.views.MyTorrentsView;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyTorrentsSuperView
extends AbstractIView
implements ObfusticateImage,
IViewExtension,
ToolBarEnabler {
    private static int SASH_WIDTH = 5;
    private MyTorrentsView torrentview;
    private MyTorrentsView seedingview;
    private Composite form;
    private MyTorrentsView lastSelectedView;
    private Composite child1;
    private Composite child2;
    private final Text txtFilter;
    private final Composite cCats;
    private Object ds;

    public MyTorrentsSuperView(Text txtFilter, Composite cCats) {
        this.txtFilter = txtFilter;
        this.cCats = cCats;
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        TableColumnManager tcManager = TableColumnManager.getInstance();
                        tcManager.addColumns(MyTorrentsSuperView.this.getCompleteColumns());
                        tcManager.addColumns(MyTorrentsSuperView.this.getIncompleteColumns());
                    }
                });
            }
        });
    }

    @Override
    public Composite getComposite() {
        return this.form;
    }

    @Override
    public void delete() {
        if (this.torrentview != null) {
            this.torrentview.delete();
        }
        if (this.seedingview != null) {
            this.seedingview.delete();
        }
        super.delete();
    }

    @Override
    public void initialize(final Composite parent) {
        if (this.form != null) {
            return;
        }
        this.form = new Composite(parent, 0);
        FormLayout flayout = new FormLayout();
        flayout.marginHeight = 0;
        flayout.marginWidth = 0;
        this.form.setLayout(flayout);
        GridData gridData = new GridData(1808);
        this.form.setLayoutData(gridData);
        this.child1 = new Composite(this.form, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.child1.setLayout(layout);
        final Sash sash = new Sash(this.form, 256);
        Image image = new Image((Device)sash.getDisplay(), 9, SASH_WIDTH);
        ImageData imageData = image.getImageData();
        int[] row = new int[imageData.width];
        for (int i = 0; i < row.length; ++i) {
            int n = row[i] = i % 3 != 0 ? 0xE0E0E0 : 0x808080;
            if (imageData.depth != 32) continue;
            row[i] = (row[i] & 0xFF) + (row[i] << 8);
        }
        for (int y = 1; y < imageData.height - 1; ++y) {
            imageData.setPixels(0, y, row.length, row, 0);
        }
        Arrays.fill(row, -522133280);
        imageData.setPixels(0, 0, row.length, row, 0);
        imageData.setPixels(0, imageData.height - 1, row.length, row, 0);
        image.dispose();
        image = new Image((Device)sash.getDisplay(), imageData);
        sash.setBackgroundImage(image);
        sash.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                sash.getBackgroundImage().dispose();
            }
        });
        this.child2 = new Composite(this.form, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.child2.setLayout(layout);
        int weight = (int)COConfigurationManager.getFloatParameter("MyTorrents.SplitAt");
        if (weight > 10000) {
            weight = 10000;
        } else if (weight < 100) {
            weight *= 100;
        }
        if (weight < 500) {
            weight = 500;
        } else if (weight > 9000) {
            weight = 9000;
        }
        double pct = (float)weight / 10000.0f;
        sash.setData("PCT", new Double(pct));
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment((int)(pct * 100.0), 0);
        this.child1.setLayoutData(formData);
        final FormData child1Data = formData;
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(this.child1);
        formData.height = SASH_WIDTH;
        sash.setLayoutData(formData);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        formData.top = new FormAttachment(sash);
        this.child2.setLayoutData(formData);
        sash.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean FASTDRAG = true;
                if (e.detail == 1) {
                    return;
                }
                child1Data.height = e.y + e.height - SASH_WIDTH;
                MyTorrentsSuperView.this.form.layout();
                Double l = new Double((double)((MyTorrentsSuperView)MyTorrentsSuperView.this).child1.getBounds().height / (double)((MyTorrentsSuperView)MyTorrentsSuperView.this).form.getBounds().height);
                sash.setData("PCT", l);
                if (e.detail != 1) {
                    int i = (int)(l * 10000.0);
                    COConfigurationManager.setParameter("MyTorrents.SplitAt", i);
                }
            }
        });
        this.form.addListener(11, new DelayedListenerMultiCombiner(){

            public void handleDelayedEvent(Event e) {
                Double l = (Double)sash.getData("PCT");
                if (l == null) {
                    return;
                }
                int newHeight = (int)((double)((MyTorrentsSuperView)MyTorrentsSuperView.this).form.getBounds().height * l);
                if (child1Data.height != newHeight || child1Data.bottom != null) {
                    child1Data.bottom = null;
                    child1Data.height = newHeight;
                    MyTorrentsSuperView.this.form.layout();
                }
            }
        });
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(final AzureusCore core) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        MyTorrentsSuperView.this.initializeWithCore(core, parent);
                    }
                });
            }
        });
    }

    private void initializeWithCore(AzureusCore core, Composite parent) {
        this.torrentview = this.createTorrentView(core, "MyTorrents", false, this.getIncompleteColumns(), this.child1);
        this.seedingview = this.createTorrentView(core, "MySeeders", true, this.getCompleteColumns(), this.child2);
        this.initializeDone();
    }

    public void initializeDone() {
    }

    @Override
    public void refresh() {
        if (this.getComposite() == null || this.getComposite().isDisposed()) {
            return;
        }
        if (this.seedingview != null) {
            this.seedingview.refresh();
        }
        if (this.torrentview != null) {
            this.torrentview.refresh();
        }
    }

    @Override
    public void updateLanguage() {
        if (this.getComposite() == null || this.getComposite().isDisposed()) {
            return;
        }
        if (this.seedingview != null) {
            this.seedingview.updateLanguage();
        }
        if (this.torrentview != null) {
            this.torrentview.updateLanguage();
        }
    }

    @Override
    public String getFullTitle() {
        return MessageText.getString("MyTorrentsView.mytorrents");
    }

    private MyTorrentsView getCurrentView() {
        try {
            if (this.torrentview != null && this.torrentview.isTableFocus()) {
                this.lastSelectedView = this.torrentview;
            } else if (this.seedingview != null && this.seedingview.isTableFocus()) {
                this.lastSelectedView = this.seedingview;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.lastSelectedView;
    }

    @Override
    public void refreshToolBar(Map<String, Boolean> list) {
        MyTorrentsView currentView = this.getCurrentView();
        if (currentView instanceof ToolBarEnabler) {
            ((ToolBarEnabler)currentView).refreshToolBar(list);
        }
    }

    @Override
    public boolean toolBarItemActivated(String itemKey) {
        MyTorrentsView currentView = this.getCurrentView();
        return currentView instanceof ToolBarEnabler && ((ToolBarEnabler)currentView).toolBarItemActivated(itemKey);
    }

    public DownloadManager[] getSelectedDownloads() {
        MyTorrentsView currentView = this.getCurrentView();
        if (currentView == null) {
            return null;
        }
        return currentView.getSelectedDownloads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateDiagnostics(IndentWriter writer) {
        super.generateDiagnostics(writer);
        try {
            writer.indent();
            writer.println("Downloading");
            writer.indent();
            this.torrentview.generateDiagnostics(writer);
            Object var3_2 = null;
            writer.exdent();
            writer.exdent();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            writer.exdent();
            writer.exdent();
            throw throwable;
        }
        try {
            writer.indent();
            writer.println("Seeding");
            writer.indent();
            this.seedingview.generateDiagnostics(writer);
            Object var5_5 = null;
            writer.exdent();
            writer.exdent();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            writer.exdent();
            writer.exdent();
            throw throwable;
        }
    }

    @Override
    public Image obfusticatedImage(Image image) {
        if (this.torrentview != null) {
            this.torrentview.obfusticatedImage(image);
        }
        if (this.seedingview != null) {
            this.seedingview.obfusticatedImage(image);
        }
        return image;
    }

    @Override
    public Menu getPrivateMenu() {
        return null;
    }

    @Override
    public void viewActivated() {
        SelectedContentManager.clearCurrentlySelectedContent();
        MyTorrentsView currentView = this.getCurrentView();
        if (currentView instanceof IViewExtension) {
            ((IViewExtension)currentView).viewActivated();
        }
        if (currentView instanceof MyTorrentsView) {
            currentView.updateSelectedContent();
        }
    }

    @Override
    public void viewDeactivated() {
        MyTorrentsView currentView = this.getCurrentView();
        if (currentView == null) {
            return;
        }
        if (currentView instanceof IViewExtension) {
            ((IViewExtension)currentView).viewDeactivated();
        }
    }

    protected TableColumnCore[] getIncompleteColumns() {
        return TableColumnCreator.createIncompleteDM("MyTorrents");
    }

    protected TableColumnCore[] getCompleteColumns() {
        return TableColumnCreator.createCompleteDM("MySeeders");
    }

    protected MyTorrentsView createTorrentView(AzureusCore _azureus_core, String tableID, boolean isSeedingView, TableColumnCore[] columns, Composite c) {
        MyTorrentsView view = new MyTorrentsView(_azureus_core, tableID, isSeedingView, columns, this.txtFilter, this.cCats);
        view.dataSourceChanged(this.ds);
        view.initialize(c);
        c.addListener(26, new Listener(){

            public void handleEvent(Event event2) {
                MyTorrentsSuperView.this.viewActivated();
            }
        });
        c.addListener(27, new Listener(){

            public void handleEvent(Event event2) {
                MyTorrentsSuperView.this.viewDeactivated();
            }
        });
        c.layout();
        return view;
    }

    public MyTorrentsView getTorrentview() {
        return this.torrentview;
    }

    public MyTorrentsView getSeedingview() {
        return this.seedingview;
    }

    @Override
    public void dataSourceChanged(Object newDataSource) {
        this.ds = newDataSource;
        super.dataSourceChanged(newDataSource);
    }
}

