/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.progress;

import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.ui.swt.ITwistieListener;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.progress.IProgressReport;
import org.gudy.azureus2.ui.swt.progress.IProgressReportConstants;
import org.gudy.azureus2.ui.swt.progress.IProgressReporter;
import org.gudy.azureus2.ui.swt.progress.IProgressReporterListener;
import org.gudy.azureus2.ui.swt.progress.ProgressReporterPanel;
import org.gudy.azureus2.ui.swt.progress.ProgressReportingManager;

public class ProgressReporterWindow
implements IProgressReportConstants,
ITwistieListener,
DisposeListener {
    private Shell shell;
    private ScrolledComposite scrollable;
    private Composite scrollChild;
    private IProgressReporter[] pReporters;
    private static final ArrayList reportersRegistry = new ArrayList();
    private static boolean isShowingEmpty = false;
    private int defaultShellWidth = 500;
    private int initialMaxNumberOfPanels = 3;
    private int style;
    private boolean isAutoRemove = false;

    private ProgressReporterWindow(IProgressReporter pReporter, int style) {
        this.style = style;
        this.pReporters = null != pReporter ? new IProgressReporter[]{pReporter} : new IProgressReporter[0];
        this.createControls();
    }

    private ProgressReporterWindow(IProgressReporter[] pReporters, int style) {
        this.style = style;
        if (null != pReporters) {
            this.pReporters = pReporters;
        } else {
            pReporters = new IProgressReporter[]{};
        }
        this.createControls();
    }

    public static void open(IProgressReporter pReporter, int style) {
        new ProgressReporterWindow(pReporter, style).openWindow();
    }

    public static void open(IProgressReporter[] pReporters, int style) {
        new ProgressReporterWindow(pReporters, style).openWindow();
    }

    public static boolean isShowingEmpty() {
        return isShowingEmpty;
    }

    public static boolean isOpened(IProgressReporter pReporter) {
        return reportersRegistry.contains(pReporter);
    }

    private void createControls() {
        int shellStyle = 2160;
        if ((this.style & 4) != 0) {
            shellStyle |= 0x10000;
        }
        this.shell = ShellFactory.createMainShell(shellStyle);
        this.shell.setText(MessageText.getString("progress.window.title"));
        Utils.setShellIcon(this.shell);
        GridLayout gLayout = new GridLayout();
        gLayout.marginHeight = 0;
        gLayout.marginWidth = 0;
        this.shell.setLayout(gLayout);
        this.scrollable = new ScrolledComposite(this.shell, 512);
        this.scrollable.setLayoutData(new GridData(4, 4, true, true));
        this.scrollChild = new Composite(this.scrollable, 0);
        GridLayout gLayoutChild = new GridLayout();
        gLayoutChild.marginHeight = 0;
        gLayoutChild.marginWidth = 0;
        gLayoutChild.verticalSpacing = 0;
        this.scrollChild.setLayout(gLayoutChild);
        this.scrollable.setContent(this.scrollChild);
        this.scrollable.setExpandVertical(true);
        this.scrollable.setExpandHorizontal(true);
        this.scrollable.addControlListener(new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = ProgressReporterWindow.this.scrollable.getClientArea();
                ProgressReporterWindow.this.scrollable.setMinSize(ProgressReporterWindow.this.scrollChild.computeSize(r.width, -1));
            }
        });
        this.shell.addListener(21, new Listener(){

            public void handleEvent(Event event2) {
                int i;
                Control[] controls = ProgressReporterWindow.this.scrollChild.getChildren();
                for (i = 0; i < controls.length; ++i) {
                    if (!(controls[i] instanceof ProgressReporterPanel)) continue;
                    ((ProgressReporterPanel)controls[i]).removeDisposeListener(ProgressReporterWindow.this);
                }
                for (i = 0; i < ProgressReporterWindow.this.pReporters.length; ++i) {
                    reportersRegistry.remove(ProgressReporterWindow.this.pReporters[i]);
                }
                isShowingEmpty = false;
            }
        });
        if (this.pReporters.length == 0) {
            this.createEmptyPanel();
        } else {
            this.createPanels();
        }
        if ((this.style & 0x20) != 0) {
            this.createToolbar();
        }
        this.isAutoRemove = COConfigurationManager.getBooleanParameter("auto_remove_inactive_items");
    }

    private void createToolbar() {
        Composite toolbarPanel = new Composite(this.shell, 0);
        toolbarPanel.setLayoutData(new GridData(4, 4, false, false));
        GridLayout gLayout = new GridLayout(3, false);
        gLayout.marginWidth = 25;
        gLayout.marginTop = 0;
        gLayout.marginBottom = 0;
        toolbarPanel.setLayout(gLayout);
        final Button autoClearButton = new Button(toolbarPanel, 32);
        autoClearButton.setText(MessageText.getString("Progress.reporting.window.remove.auto"));
        autoClearButton.setToolTipText(MessageText.getString("Progress.reporting.window.remove.auto.tooltip"));
        autoClearButton.setLayoutData(new GridData(1, 0x1000000, false, false));
        autoClearButton.setSelection(COConfigurationManager.getBooleanParameter("auto_remove_inactive_items"));
        Label dummy = new Label(toolbarPanel, 0);
        dummy.setLayoutData(new GridData(4, 4, true, false));
        final Button clearInActiveButton = new Button(toolbarPanel, 0);
        clearInActiveButton.setText(MessageText.getString("Progress.reporting.window.remove.now"));
        clearInActiveButton.setToolTipText(MessageText.getString("Progress.reporting.window.remove.now.tooltip"));
        clearInActiveButton.setLayoutData(new GridData(0x1000008, 0x1000000, false, false));
        clearInActiveButton.setEnabled(!COConfigurationManager.getBooleanParameter("auto_remove_inactive_items"));
        autoClearButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                COConfigurationManager.setParameter("auto_remove_inactive_items", autoClearButton.getSelection());
                clearInActiveButton.setEnabled(!autoClearButton.getSelection());
                ProgressReporterWindow.this.isAutoRemove = autoClearButton.getSelection();
                if (ProgressReporterWindow.this.isAutoRemove) {
                    ProgressReporterWindow.this.removeInActivePanels();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        clearInActiveButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProgressReporterWindow.this.removeInActivePanels();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void removeInActivePanels() {
        Control[] controls = this.scrollChild.getChildren();
        for (int i = 0; i < controls.length; ++i) {
            IProgressReporter pReporter;
            if (null == controls[i] || controls[i].isDisposed() || !(controls[i] instanceof ProgressReporterPanel) || (pReporter = ((ProgressReporterPanel)controls[i]).getProgressReporter()).getProgressReport().isActive()) continue;
            ProgressReportingManager.getInstance().remove(pReporter);
            controls[i].dispose();
        }
    }

    private void createEmptyPanel() {
        Composite emptyPanel = new Composite(this.scrollChild, 2048);
        GridData gData = new GridData(4, 4, true, true);
        gData.heightHint = 100;
        emptyPanel.setLayoutData(gData);
        emptyPanel.setLayout(new GridLayout());
        Label nothingToDisplay = new Label(emptyPanel, 0);
        nothingToDisplay.setLayoutData(new GridData(4, 4, true, true));
        nothingToDisplay.setText(MessageText.getString("Progress.reporting.no.reports.to.display"));
        isShowingEmpty = true;
    }

    private void openWindow() {
        UIFunctionsSWT uiFunctions;
        Control[] controls = this.scrollChild.getChildren();
        for (int i = this.initialMaxNumberOfPanels; i < controls.length; ++i) {
            ((GridData)controls[i].getLayoutData()).exclude = true;
        }
        Point p = this.shell.computeSize(this.defaultShellWidth, -1);
        for (int i = 0; i < controls.length; ++i) {
            ((GridData)controls[i].getLayoutData()).exclude = false;
        }
        this.formatLastPanel(null);
        this.scrollChild.layout();
        if (!this.shell.getSize().equals(p)) {
            this.shell.setSize(p);
            this.shell.layout(false);
        }
        if (null == (uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT())) {
            Utils.centreWindow(this.shell);
        } else {
            Utils.centerWindowRelativeTo(this.shell, uiFunctions.getMainShell());
        }
        this.shell.open();
    }

    private void createPanels() {
        int size = this.pReporters.length;
        if (size < 2) {
            this.style |= 8;
        }
        for (int i = 0; i < size; ++i) {
            if (null == this.pReporters[i]) continue;
            reportersRegistry.add(this.pReporters[i]);
            ProgressReporterPanel panel = new ProgressReporterPanel(this.scrollChild, this.pReporters[i], this.style | 0x10);
            panel.setLayoutData(new GridData(4, 4, true, false));
            panel.addTwistieListener(this);
            panel.addDisposeListener(this);
            this.pReporters[i].addListener(new AutoRemoveListener(panel));
        }
        this.formatLastPanel(null);
    }

    private void formatLastPanel(ProgressReporterPanel panelToIgnore) {
        Control[] controls = this.scrollChild.getChildren();
        for (int i = controls.length - 1; i >= 0; --i) {
            if (controls[i].equals(panelToIgnore)) continue;
            ((GridData)controls[i].getLayoutData()).grabExcessVerticalSpace = true;
            break;
        }
    }

    private void removeReporter(IProgressReporter reporter) {
        reportersRegistry.remove(reporter);
        int IDX = Arrays.binarySearch(this.pReporters, reporter);
        if (IDX >= 0) {
            IProgressReporter[] rps = new IProgressReporter[this.pReporters.length - 1];
            for (int i = 0; i < rps.length; ++i) {
                rps[i] = this.pReporters[i >= IDX ? i + 1 : i];
            }
            this.pReporters = rps;
        }
    }

    public void isCollapsed(boolean value) {
        if (null != this.shell && !this.shell.isDisposed()) {
            this.scrollable.setRedraw(false);
            Rectangle r = this.scrollable.getClientArea();
            this.scrollable.setMinSize(this.scrollChild.computeSize(r.width, -1));
            if (this.pReporters.length == 1) {
                Point p = this.shell.computeSize(this.defaultShellWidth, -1);
                if (this.shell.getSize().y != p.y) {
                    p.x = this.shell.getSize().x;
                    this.shell.setSize(p);
                }
            }
            this.scrollable.layout();
            this.scrollable.setRedraw(true);
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        if (e.widget instanceof ProgressReporterPanel) {
            ProgressReporterPanel panel = (ProgressReporterPanel)e.widget;
            this.removeReporter(panel.pReporter);
            panel.removeTwistieListener(this);
            ((GridData)panel.getLayoutData()).exclude = true;
            panel.setVisible(false);
            if (this.pReporters.length == 0) {
                if ((this.style & 2) != 0) {
                    if (null != this.shell && !this.shell.isDisposed()) {
                        this.shell.close();
                    }
                } else {
                    this.createEmptyPanel();
                }
            } else {
                this.formatLastPanel(panel);
            }
            if (null != this.shell && !this.shell.isDisposed()) {
                this.shell.layout(true, true);
            }
        }
    }

    private class AutoRemoveListener
    implements IProgressReporterListener {
        private ProgressReporterPanel panel = null;

        private AutoRemoveListener(ProgressReporterPanel panel) {
            this.panel = panel;
        }

        public int report(IProgressReport progressReport) {
            if (ProgressReporterWindow.this.isAutoRemove && !progressReport.isActive()) {
                if (null != this.panel && !this.panel.isDisposed()) {
                    ProgressReportingManager.getInstance().remove(this.panel.getProgressReporter());
                    Utils.execSWTThread(new AERunnable(){

                        public void runSupport() {
                            AutoRemoveListener.this.panel.dispose();
                        }
                    });
                }
                return 1;
            }
            return 0;
        }
    }
}

