/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.mainwindow;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MultipleDocumentInterface;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import java.util.Iterator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.plugins.ui.tables.TableRowMouseListener;
import org.gudy.azureus2.plugins.update.Update;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateCheckInstanceListener;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl;
import org.gudy.azureus2.ui.common.util.MenuItemManager;
import org.gudy.azureus2.ui.swt.BlockedIpsWindow;
import org.gudy.azureus2.ui.swt.KeyBindings;
import org.gudy.azureus2.ui.swt.MenuBuildUtils;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.TorrentUtil;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.beta.BetaWizard;
import org.gudy.azureus2.ui.swt.components.shell.ShellManager;
import org.gudy.azureus2.ui.swt.config.wizard.ConfigureWizard;
import org.gudy.azureus2.ui.swt.debug.UIDebugGenerator;
import org.gudy.azureus2.ui.swt.donations.DonationWindow;
import org.gudy.azureus2.ui.swt.exporttorrent.wizard.ExportTorrentWizard;
import org.gudy.azureus2.ui.swt.help.AboutWindow;
import org.gudy.azureus2.ui.swt.help.HealthHelpWindow;
import org.gudy.azureus2.ui.swt.importtorrent.wizard.ImportTorrentWizard;
import org.gudy.azureus2.ui.swt.mainwindow.IMainWindow;
import org.gudy.azureus2.ui.swt.mainwindow.IMenuConstants;
import org.gudy.azureus2.ui.swt.mainwindow.ListenerNeedingCoreRunning;
import org.gudy.azureus2.ui.swt.mainwindow.PluginsMenuHelper;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.maketorrent.NewTorrentWizard;
import org.gudy.azureus2.ui.swt.minibar.AllTransfersBar;
import org.gudy.azureus2.ui.swt.minibar.MiniBarManager;
import org.gudy.azureus2.ui.swt.nat.NatTestWindow;
import org.gudy.azureus2.ui.swt.pluginsinstaller.InstallPluginWizard;
import org.gudy.azureus2.ui.swt.pluginsuninstaller.UnInstallPluginWizard;
import org.gudy.azureus2.ui.swt.sharing.ShareUtils;
import org.gudy.azureus2.ui.swt.shells.CoreWaiterSWT;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.speedtest.SpeedTestWizard;
import org.gudy.azureus2.ui.swt.update.UpdateMonitor;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.utils.TableContextMenuManager;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;
import org.gudy.azureus2.ui.swt.welcome.WelcomeWindow;

public class MenuFactory
implements IMenuConstants {
    private static boolean isAZ3 = "az3".equalsIgnoreCase(COConfigurationManager.getStringParameter("ui"));
    private static final boolean DEBUG_SET_FOREGROUND = System.getProperty("debug.setforeground") != null;

    public static MenuItem createFileMenuItem(Menu menuParent) {
        return MenuFactory.createTopLevelMenuItem(menuParent, "MainWindow.menu.file");
    }

    public static MenuItem createTransfersMenuItem(Menu menuParent) {
        MenuItem transferMenuItem = MenuFactory.createTopLevelMenuItem(menuParent, "MainWindow.menu.transfers");
        Menu transferMenu = transferMenuItem.getMenu();
        MenuFactory.addStartAllMenuItem(transferMenu);
        MenuFactory.addStopAllMenuItem(transferMenu);
        final MenuItem itemPause = MenuFactory.addPauseMenuItem(transferMenu);
        final MenuItem itemResume = MenuFactory.addResumeMenuItem(transferMenu);
        transferMenu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent menu) {
                if (!AzureusCoreFactory.isCoreRunning()) {
                    itemPause.setEnabled(false);
                    itemResume.setEnabled(false);
                } else {
                    AzureusCore core = AzureusCoreFactory.getSingleton();
                    itemPause.setEnabled(core.getGlobalManager().canPauseDownloads());
                    itemResume.setEnabled(core.getGlobalManager().canResumeDownloads());
                }
            }

            public void menuHidden(MenuEvent menu) {
            }
        });
        return transferMenuItem;
    }

    public static MenuItem createViewMenuItem(Menu menuParent) {
        return MenuFactory.createTopLevelMenuItem(menuParent, "MainWindow.menu.view");
    }

    public static MenuItem createAdvancedMenuItem(Menu menuParent) {
        return MenuFactory.createTopLevelMenuItem(menuParent, "v3.MainWindow.tab.advanced");
    }

    public static Menu createTorrentMenuItem(Menu menuParent) {
        Menu torrentMenu = MenuFactory.createTopLevelMenuItem(menuParent, "MainWindow.menu.torrent").getMenu();
        MenuBuildUtils.addMaintenanceListenerForMenu(torrentMenu, new MenuBuildUtils.MenuBuilder(){

            public void buildMenu(Menu menu, MenuEvent menuEvent) {
                MenuFactory.buildTorrentMenu(menu);
            }
        });
        return torrentMenu;
    }

    public static void buildTorrentMenu(Menu menu) {
        DownloadManager[] current_dls = (DownloadManager[])menu.getData("downloads");
        if (current_dls == null) {
            return;
        }
        if (AzureusCoreFactory.isCoreRunning()) {
            boolean is_detailed_view = (Boolean)menu.getData("is_detailed_view");
            TableViewSWT tv = (TableViewSWT)menu.getData("TableView");
            AzureusCore core = AzureusCoreFactory.getSingleton();
            TorrentUtil.fillTorrentMenu(menu, current_dls, core, menu.getShell(), !is_detailed_view, 0, tv);
        }
        org.gudy.azureus2.plugins.ui.menus.MenuItem[] menu_items = MenuItemManager.getInstance().getAllAsArray(new String[]{"torrentmenu", "download_context"});
        Object[] plugin_dls = DownloadManagerImpl.getDownloadStatic(current_dls);
        if (menu_items.length > 0) {
            MenuFactory.addSeparatorMenuItem(menu);
            MenuBuildUtils.addPluginMenuItems(menu.getShell(), menu_items, menu, true, true, new MenuBuildUtils.MenuItemPluginMenuControllerImpl(plugin_dls));
        }
        menu_items = null;
        String table_to_use = null;
        for (int i = 0; i < current_dls.length; ++i) {
            String table_name;
            String string = table_name = current_dls[i].isDownloadComplete(false) ? "MySeeders" : "MyTorrents";
            if (table_to_use != null && !table_to_use.equals(table_name)) {
                table_to_use = null;
                break;
            }
            table_to_use = table_name;
        }
        if (table_to_use != null) {
            menu_items = TableContextMenuManager.getInstance().getAllAsArray(table_to_use);
        }
        if (menu_items != null) {
            MenuFactory.addSeparatorMenuItem(menu);
            Object[] dls_as_rows = null;
            dls_as_rows = new TableRow[plugin_dls.length];
            for (int i = 0; i < plugin_dls.length; ++i) {
                dls_as_rows[i] = MenuFactory.wrapAsRow(plugin_dls[i], table_to_use);
            }
            MenuBuildUtils.addPluginMenuItems(menu.getShell(), menu_items, menu, true, true, new MenuBuildUtils.MenuItemPluginMenuControllerImpl(dls_as_rows));
        }
    }

    public static MenuItem createToolsMenuItem(Menu menuParent) {
        return MenuFactory.createTopLevelMenuItem(menuParent, "MainWindow.menu.tools");
    }

    public static MenuItem createPluginsMenuItem(final Menu menuParent, final boolean includeGetPluginsMenu) {
        MenuItem pluginsMenuItem = MenuFactory.createTopLevelMenuItem(menuParent, "MainWindow.menu.view.plugins");
        MenuBuildUtils.addMaintenanceListenerForMenu(pluginsMenuItem.getMenu(), new MenuBuildUtils.MenuBuilder(){

            public void buildMenu(Menu menu, MenuEvent menuEvent) {
                PluginsMenuHelper.getInstance().buildPluginMenu(menu, menuParent.getShell(), includeGetPluginsMenu);
            }
        });
        return pluginsMenuItem;
    }

    public static MenuItem createWindowMenuItem(Menu menuParent) {
        return MenuFactory.createTopLevelMenuItem(menuParent, "MainWindow.menu.window");
    }

    public static MenuItem createHelpMenuItem(Menu menuParent) {
        return MenuFactory.createTopLevelMenuItem(menuParent, "MainWindow.menu.help");
    }

    public static MenuItem addCreateMenuItem(Menu menuParent) {
        MenuItem file_create = MenuFactory.addMenuItem(menuParent, "MainWindow.menu.file.create", new Listener(){

            public void handleEvent(Event e) {
                new NewTorrentWizard(e.display);
            }
        });
        return file_create;
    }

    public static MenuItem createOpenMenuItem(Menu menuParent) {
        return MenuFactory.createTopLevelMenuItem(menuParent, "MainWindow.menu.file.open");
    }

    public static MenuItem addLogsViewMenuItem(Menu menuParent) {
        return MenuFactory.createTopLevelMenuItem(menuParent, "MainWindow.menu.view.plugins.logViews");
    }

    public static MenuItem addOpenTorrentMenuItem(Menu menuParent) {
        return MenuFactory.addMenuItem(menuParent, "MainWindow.menu.file.open.torrent", new Listener(){

            public void handleEvent(Event e) {
                TorrentOpener.openTorrentWindow();
            }
        });
    }

    public static MenuItem addOpenTorrentForTrackingMenuItem(Menu menuParent) {
        MenuItem file_new_torrent_for_tracking = MenuFactory.addMenuItem(menuParent, "MainWindow.menu.file.open.torrentfortracking", new Listener(){

            public void handleEvent(Event e) {
                TorrentOpener.openTorrentTrackingOnly();
            }
        });
        return file_new_torrent_for_tracking;
    }

    public static MenuItem addSearchMenuItem(Menu menuParent) {
        MenuItem item = MenuFactory.addMenuItem(menuParent, "Button.search", new Listener(){

            public void handleEvent(Event e) {
                UIFunctionsManagerSWT.getUIFunctionsSWT().promptForSearch();
            }
        });
        return item;
    }

    public static MenuItem addOpenVuzeFileMenuItem(final Menu menuParent) {
        return MenuFactory.addMenuItem(menuParent, "MainWindow.menu.file.open.vuze", new Listener(){

            public void handleEvent(Event e) {
                Display display = menuParent.getDisplay();
                display.asyncExec(new AERunnable(){

                    public void runSupport() {
                        VuzeFileHandler vfh;
                        FileDialog dialog = new FileDialog(menuParent.getShell(), 135168);
                        dialog.setFilterPath(TorrentOpener.getFilterPathData());
                        dialog.setText(MessageText.getString("MainWindow.dialog.select.vuze.file"));
                        dialog.setFilterExtensions(new String[]{"*.vuze", "*.vuz", Constants.FILE_WILDCARD});
                        dialog.setFilterNames(new String[]{"*.vuze", "*.vuz", Constants.FILE_WILDCARD});
                        String path = TorrentOpener.setFilterPathData(dialog.open());
                        if (path != null && (vfh = VuzeFileHandler.getSingleton()).loadAndHandleVuzeFile(path, 0) == null) {
                            TorrentOpener.openTorrent(path);
                        }
                    }
                });
            }
        });
    }

    public static MenuItem createShareMenuItem(Menu menuParent) {
        MenuItem file_share = MenuFactory.createTopLevelMenuItem(menuParent, "MainWindow.menu.file.share");
        return file_share;
    }

    public static MenuItem addShareFileMenuItem(final Menu menuParent) {
        MenuItem file_share_file = MenuFactory.addMenuItem(menuParent, "MainWindow.menu.file.share.file", new Listener(){

            public void handleEvent(Event e) {
                ShareUtils.shareFile(menuParent.getShell());
            }
        });
        return file_share_file;
    }

    public static MenuItem addShareFolderMenuItem(final Menu menuParent) {
        MenuItem file_share_dir = MenuFactory.addMenuItem(menuParent, "MainWindow.menu.file.share.dir", new Listener(){

            public void handleEvent(Event e) {
                ShareUtils.shareDir(menuParent.getShell());
            }
        });
        return file_share_dir;
    }

    public static MenuItem addShareFolderContentMenuItem(final Menu menuParent) {
        MenuItem file_share_dircontents = MenuFactory.addMenuItem(menuParent, "MainWindow.menu.file.share.dircontents", new Listener(){

            public void handleEvent(Event e) {
                ShareUtils.shareDirContents(menuParent.getShell(), false);
            }
        });
        return file_share_dircontents;
    }

    public static MenuItem addShareFolderContentRecursiveMenuItem(final Menu menuParent) {
        MenuItem file_share_dircontents_rec = MenuFactory.addMenuItem(menuParent, "MainWindow.menu.file.share.dircontentsrecursive", new Listener(){

            public void handleEvent(Event e) {
                ShareUtils.shareDirContents(menuParent.getShell(), true);
            }
        });
        return file_share_dircontents_rec;
    }

    public static MenuItem addImportMenuItem(Menu menuParent) {
        MenuItem file_import = MenuFactory.addMenuItem(menuParent, "MainWindow.menu.file.import", new Listener(){

            public void handleEvent(Event e) {
                new ImportTorrentWizard();
            }
        });
        return file_import;
    }

    public static MenuItem addExportMenuItem(Menu menuParent) {
        MenuItem file_export = MenuFactory.addMenuItem(menuParent, "MainWindow.menu.file.export", new Listener(){

            public void handleEvent(Event e) {
                new ExportTorrentWizard();
            }
        });
        return file_export;
    }

    public static MenuItem addCloseWindowMenuItem(final Menu menuParent) {
        MenuItem closeWindow = MenuFactory.addMenuItem(menuParent, "MainWindow.menu.file.closewindow", new Listener(){

            public void handleEvent(Event event2) {
                Shell shell = menuParent.getShell();
                if (shell != null && !shell.isDisposed()) {
                    menuParent.getShell().close();
                }
            }
        });
        return closeWindow;
    }

    public static MenuItem addCloseTabMenuItem(Menu menu) {
        final MenuItem menuItem = MenuFactory.addMenuItem(menu, "MainWindow.menu.file.closetab", new Listener(){

            public void handleEvent(Event event2) {
                MdiEntry currentEntry;
                MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                if (mdi != null && (currentEntry = mdi.getCurrentEntry()) != null && currentEntry.isCloseable()) {
                    mdi.closeEntry(currentEntry.getId());
                }
            }
        });
        menu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
                MdiEntry currentEntry;
                MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                if (mdi != null && (currentEntry = mdi.getCurrentEntry()) != null && currentEntry.isCloseable()) {
                    menuItem.setEnabled(true);
                    return;
                }
                menuItem.setEnabled(false);
            }

            public void menuHidden(MenuEvent e) {
            }
        });
        return menuItem;
    }

    public static MenuItem addCloseDetailsMenuItem(Menu menu) {
        final MenuItem item = MenuFactory.addMenuItem(menu, "MainWindow.menu.closealldetails", new Listener(){

            public void handleEvent(Event e) {
                UIFunctionsManagerSWT.getUIFunctionsSWT().closeAllDetails();
            }
        });
        Listener enableHandler = new Listener(){

            public void handleEvent(Event event2) {
                if (MenuFactory.isEnabledForCurrentMode(item) && !item.isDisposed() && !event2.widget.isDisposed()) {
                    boolean hasDetails = UIFunctionsManagerSWT.getUIFunctionsSWT().hasDetailViews();
                    item.setEnabled(hasDetails);
                }
            }
        };
        menu.addListener(22, enableHandler);
        return item;
    }

    public static MenuItem addCloseDownloadBarsToMenu(Menu menu) {
        final MenuItem item = MenuFactory.addMenuItem(menu, "MainWindow.menu.closealldownloadbars", new Listener(){

            public void handleEvent(Event e) {
                MiniBarManager.getManager().closeAll();
            }
        });
        Listener enableHandler = new Listener(){

            public void handleEvent(Event event2) {
                if (!item.isDisposed()) {
                    item.setEnabled(false == MiniBarManager.getManager().getShellManager().isEmpty());
                }
            }
        };
        menu.addListener(22, enableHandler);
        return item;
    }

    public static MenuItem addRestartMenuItem(Menu menuParent) {
        MenuItem file_restart = new MenuItem(menuParent, 0);
        Messages.setLanguageText(file_restart, "MainWindow.menu.file.restart");
        file_restart.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                UIFunctionsManagerSWT.getUIFunctionsSWT().dispose(true, false);
            }
        });
        return file_restart;
    }

    public static MenuItem addExitMenuItem(Menu menuParent) {
        final MenuItem file_exit = new MenuItem(menuParent, 0);
        if (!COConfigurationManager.getBooleanParameter("Enable System Tray") || !COConfigurationManager.getBooleanParameter("Close To Tray")) {
            KeyBindings.setAccelerator(file_exit, "MainWindow.menu.file.exit");
        }
        Messages.setLanguageText(file_exit, "MainWindow.menu.file.exit");
        file_exit.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                UIFunctionsManagerSWT.getUIFunctionsSWT().dispose(false, false);
            }
        });
        ParameterListener paramListener = new ParameterListener(){

            public void parameterChanged(String parameterName) {
                if (COConfigurationManager.getBooleanParameter("Enable System Tray") && COConfigurationManager.getBooleanParameter("Close To Tray")) {
                    KeyBindings.removeAccelerator(file_exit, "MainWindow.menu.file.exit");
                } else {
                    KeyBindings.setAccelerator(file_exit, "MainWindow.menu.file.exit");
                }
            }
        };
        COConfigurationManager.addParameterListener("Enable System Tray", paramListener);
        COConfigurationManager.addParameterListener("Close To Tray", paramListener);
        return file_exit;
    }

    public static MenuItem addStartAllMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.transfers.startalltransfers", new ListenerNeedingCoreRunning(){

            public void handleEvent(AzureusCore core, Event e) {
                core.getGlobalManager().startAllDownloads();
            }
        });
    }

    public static MenuItem addStopAllMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.transfers.stopalltransfers", new Listener(){

            public void handleEvent(Event event2) {
                ManagerUtils.asyncStopAll();
            }
        });
    }

    public static MenuItem addPauseMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.transfers.pausetransfers", new Listener(){

            public void handleEvent(Event event2) {
                ManagerUtils.asyncPause();
            }
        });
    }

    public static MenuItem addResumeMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.transfers.resumetransfers", new Listener(){

            public void handleEvent(Event event2) {
                ManagerUtils.asyncResume();
            }
        });
    }

    public static MenuItem addMyTorrentsMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.view.mytorrents", new Listener(){

            public void handleEvent(Event e) {
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    uiFunctions.openView(8, null);
                }
            }
        });
    }

    public static MenuItem addAllPeersMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.view.allpeers", new Listener(){

            public void handleEvent(Event e) {
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    uiFunctions.openView(10, null);
                }
            }
        });
    }

    public static MenuItem addClientStatsMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.view.clientstats", new Listener(){

            public void handleEvent(Event e) {
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    uiFunctions.openView(12, null);
                }
            }
        });
    }

    public static MenuItem addDeviceManagerMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.view.devicemanager", new Listener(){

            public void handleEvent(Event e) {
                MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                mdi.showEntryByID("Devices");
            }
        });
    }

    public static MenuItem addSubscriptionMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "subscriptions.view.title", new Listener(){

            public void handleEvent(Event e) {
                MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                mdi.showEntryByID("header.subscriptions");
            }
        });
    }

    public static MenuItem addMyTrackerMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.view.mytracker", new Listener(){

            public void handleEvent(Event e) {
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    uiFunctions.openView(9, null);
                }
            }
        });
    }

    public static MenuItem addMySharesMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.view.myshares", new Listener(){

            public void handleEvent(Event e) {
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    uiFunctions.openView(7, null);
                }
            }
        });
    }

    public static MenuItem addViewToolbarMenuItem(Menu menu) {
        final MenuItem item = MenuFactory.addMenuItem(menu, 32, "MainWindow.menu.view.iconbar", new Listener(){

            public void handleEvent(Event e) {
                UIFunctionsSWT uiFunctions = MenuFactory.getUIFunctionSWT();
                if (null != uiFunctions) {
                    IMainWindow mainWindow;
                    boolean isToolbarVisible = (mainWindow = uiFunctions.getMainWindow()).isVisible(2);
                    mainWindow.setVisible(2, !isToolbarVisible);
                }
            }
        });
        final ParameterListener listener = new ParameterListener(){

            public void parameterChanged(String parameterName) {
                item.setSelection(COConfigurationManager.getBooleanParameter(parameterName));
            }
        };
        COConfigurationManager.addAndFireParameterListener("IconBar.enabled", listener);
        item.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                COConfigurationManager.removeParameterListener("IconBar.enabled", listener);
            }
        });
        return item;
    }

    public static MenuItem addTransferBarToMenu(final Menu menu) {
        final MenuItem item = MenuFactory.addMenuItem(menu, 32, "MainWindow.menu.view.open_global_transfer_bar", new ListenerNeedingCoreRunning(){

            public void handleEvent(AzureusCore core, Event e) {
                if (AllTransfersBar.getManager().isOpen(core.getGlobalManager())) {
                    AllTransfersBar.close(core.getGlobalManager());
                } else {
                    AllTransfersBar.open(core.getGlobalManager(), menu.getShell());
                }
            }
        });
        item.setSelection(!MiniBarManager.getManager().getShellManager().isEmpty());
        menu.addListener(22, new Listener(){

            public void handleEvent(Event event2) {
                if (item.isDisposed()) {
                    menu.removeListener(22, this);
                } else {
                    item.setSelection(!MiniBarManager.getManager().getShellManager().isEmpty());
                }
            }
        });
        return item;
    }

    public static MenuItem addBlockedIPsMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.view.ipFilter", new ListenerNeedingCoreRunning(){

            public void handleEvent(AzureusCore core, Event e) {
                BlockedIpsWindow.showBlockedIps(core, MenuFactory.getUIFunctionSWT().getMainShell());
            }
        });
    }

    public static MenuItem addConsoleMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.view.console", new Listener(){

            public void handleEvent(Event e) {
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    uiFunctions.openView(0, null);
                }
            }
        });
    }

    public static MenuItem addStatisticsMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.view.stats", new Listener(){

            public void handleEvent(Event e) {
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    uiFunctions.openView(1, null);
                }
            }
        });
    }

    public static MenuItem addNatTestMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.tools.nattest", new Listener(){

            public void handleEvent(Event e) {
                new NatTestWindow();
            }
        });
    }

    public static MenuItem addSpeedTestMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.tools.speedtest", new Listener(){

            public void handleEvent(Event e) {
                CoreWaiterSWT.waitForCoreRunning(new AzureusCoreRunningListener(){

                    public void azureusCoreRunning(AzureusCore core) {
                        new SpeedTestWizard();
                    }
                });
            }
        });
    }

    public static MenuItem addConfigWizardMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.file.configure", new Listener(){

            public void handleEvent(Event e) {
                new ConfigureWizard(false, 0);
            }
        });
    }

    public static MenuItem addOptionsMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.view.configuration", new Listener(){

            public void handleEvent(Event e) {
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    uiFunctions.openView(4, null);
                }
            }
        });
    }

    public static MenuItem addMinimizeWindowMenuItem(Menu menu) {
        final Shell shell = menu.getShell();
        final MenuItem item = MenuFactory.addMenuItem(menu, "MainWindow.menu.window.minimize", new Listener(){

            public void handleEvent(Event event2) {
                if (null == shell || shell.isDisposed()) {
                    event2.doit = false;
                    return;
                }
                shell.setMinimized(true);
            }
        });
        Listener enableHandler = new Listener(){

            public void handleEvent(Event event2) {
                if (null == shell || shell.isDisposed() || item.isDisposed()) {
                    event2.doit = false;
                    return;
                }
                if ((shell.getStyle() & 0x80) != 0) {
                    item.setEnabled(false == shell.getMinimized());
                } else {
                    item.setEnabled(false);
                }
            }
        };
        menu.addListener(22, enableHandler);
        shell.addListener(15, enableHandler);
        shell.addListener(19, enableHandler);
        shell.addListener(20, enableHandler);
        return item;
    }

    public static MenuItem addBringAllToFrontMenuItem(Menu menu) {
        final MenuItem item = MenuFactory.addMenuItem(menu, "MainWindow.menu.window.alltofront", new Listener(){

            public void handleEvent(Event event2) {
                Iterator iter = ShellManager.sharedManager().getWindows();
                while (iter.hasNext()) {
                    Shell shell = (Shell)iter.next();
                    if (shell.isDisposed() || shell.getMinimized()) continue;
                    shell.open();
                }
            }
        });
        final Listener enableHandler = new Listener(){

            public void handleEvent(Event event2) {
                if (item.isDisposed()) {
                    return;
                }
                Iterator iter = ShellManager.sharedManager().getWindows();
                boolean hasNonMaximizedShell = false;
                while (iter.hasNext()) {
                    Shell shell = (Shell)iter.next();
                    if (shell.isDisposed() || shell.getMinimized()) continue;
                    hasNonMaximizedShell = true;
                    break;
                }
                item.setEnabled(hasNonMaximizedShell);
            }
        };
        menu.addListener(22, enableHandler);
        menu.getShell().addListener(15, enableHandler);
        ShellManager.sharedManager().addWindowAddedListener(enableHandler);
        ShellManager.sharedManager().addWindowRemovedListener(enableHandler);
        item.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event2) {
                ShellManager.sharedManager().removeWindowAddedListener(enableHandler);
                ShellManager.sharedManager().removeWindowRemovedListener(enableHandler);
            }
        });
        return item;
    }

    public static void appendWindowMenuItems(final Menu menuParent) {
        final Shell shell = menuParent.getShell();
        final int numTopItems = menuParent.getItemCount();
        Listener rebuild = new Listener(){

            public void handleEvent(Event event2) {
                try {
                    if (menuParent.isDisposed() || shell.isDisposed()) {
                        return;
                    }
                    int size = ShellManager.sharedManager().getSize();
                    if (size == menuParent.getItemCount() - numTopItems) {
                        for (int i = numTopItems; i < menuParent.getItemCount(); ++i) {
                            MenuItem item;
                            item.setSelection((item = menuParent.getItem(i)).getData() == shell);
                        }
                        return;
                    }
                    int i = numTopItems;
                    while (i < menuParent.getItemCount()) {
                        menuParent.getItem(i).dispose();
                    }
                    Iterator iter = ShellManager.sharedManager().getWindows();
                    for (int i2 = 0; i2 < size; ++i2) {
                        final Shell sh = (Shell)iter.next();
                        if (sh.isDisposed() || sh.getText().length() == 0) continue;
                        MenuItem item = new MenuItem(menuParent, 32);
                        item.setText(sh.getText());
                        item.setSelection(shell == sh);
                        item.setData(sh);
                        item.addSelectionListener(new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent event2) {
                                if (event2.widget.isDisposed() || sh.isDisposed()) {
                                    return;
                                }
                                if (sh.getMinimized()) {
                                    sh.setMinimized(false);
                                }
                                sh.open();
                            }
                        });
                    }
                }
                catch (Exception e) {
                    Logger.log(new LogEvent(LogIDs.GUI, "rebuild menu error", e));
                }
            }
        };
        ShellManager.sharedManager().addWindowAddedListener(rebuild);
        ShellManager.sharedManager().addWindowRemovedListener(rebuild);
        shell.addListener(15, rebuild);
        menuParent.addListener(22, rebuild);
    }

    public static MenuItem addZoomWindowMenuItem(Menu menuParent) {
        final Shell shell = menuParent.getShell();
        final MenuItem item = MenuFactory.addMenuItem(menuParent, "MainWindow.menu.window.zoom", new Listener(){

            public void handleEvent(Event event2) {
                if (shell.isDisposed()) {
                    event2.doit = false;
                    return;
                }
                shell.setMaximized(!shell.getMaximized());
            }
        });
        Listener enableHandler = new Listener(){

            public void handleEvent(Event event2) {
                if (!shell.isDisposed() && !item.isDisposed()) {
                    if (!Constants.isOSX) {
                        if (shell.getMaximized()) {
                            Messages.setLanguageText(item, MessageText.resolveLocalizationKey("MainWindow.menu.window.zoom.restore"));
                        } else {
                            Messages.setLanguageText(item, MessageText.resolveLocalizationKey("MainWindow.menu.window.zoom.maximize"));
                        }
                    }
                    if ((shell.getStyle() & 0x400) != 0) {
                        item.setEnabled(false == shell.getMinimized());
                    } else {
                        item.setEnabled(false);
                    }
                }
            }
        };
        menuParent.addListener(22, enableHandler);
        shell.addListener(15, enableHandler);
        shell.addListener(19, enableHandler);
        shell.addListener(20, enableHandler);
        return item;
    }

    public static MenuItem addAboutMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.help.about", new Listener(){

            public void handleEvent(Event e) {
                AboutWindow.show();
            }
        });
    }

    public static MenuItem addHealthMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MyTorrentsView.menu.health", new Listener(){

            public void handleEvent(Event e) {
                HealthHelpWindow.show(MenuFactory.getDisplay());
            }
        });
    }

    public static MenuItem addWhatsNewMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.help.whatsnew", new Listener(){

            public void handleEvent(Event e) {
                Utils.launch("http://plugins.vuze.com/changelog.php?version=4.6.0.4");
            }
        });
    }

    public static MenuItem addWikiMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.community.wiki", new Listener(){

            public void handleEvent(Event e) {
                Utils.launch("http://wiki.vuze.com/w/");
            }
        });
    }

    public static MenuItem addReleaseNotesMenuItem(final Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.help.releasenotes", new Listener(){

            public void handleEvent(Event e) {
                new WelcomeWindow(menu.getShell());
            }
        });
    }

    public static MenuItem addHelpSupportMenuItem(Menu menu, final String support_url) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.help.support", new Listener(){

            public void handleEvent(Event e) {
                Utils.launch(support_url);
            }
        });
    }

    public static MenuItem addDonationMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.help.donate", new Listener(){

            public void handleEvent(Event e) {
                DonationWindow.open(true, "menu");
            }
        });
    }

    public static MenuItem addGetPluginsMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.help.plugins", new Listener(){

            public void handleEvent(Event e) {
                Utils.launch("http://plugins.vuze.com/plugin_list.php");
            }
        });
    }

    public static MenuItem addDebugHelpMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.help.debug", new Listener(){

            public void handleEvent(Event e) {
                UIDebugGenerator.generate(Constants.APP_NAME + " " + "4.6.0.4", "Generated via Help Menu");
            }
        });
    }

    public static MenuItem addCheckUpdateMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.help.checkupdate", new ListenerNeedingCoreRunning(){

            public void handleEvent(AzureusCore core, Event e) {
                UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
                if (uiFunctions != null) {
                    uiFunctions.bringToFront();
                }
                UpdateMonitor.getSingleton(core).performCheck(true, false, false, new UpdateCheckInstanceListener(){

                    public void cancelled(UpdateCheckInstance instance) {
                    }

                    public void complete(UpdateCheckInstance instance) {
                        Update[] updates = instance.getUpdates();
                        boolean hasUpdates = false;
                        for (Update update : updates) {
                            if (update.getDownloaders().length <= 0) continue;
                            hasUpdates = true;
                            break;
                        }
                        if (!hasUpdates) {
                            MessageBoxShell mb = new MessageBoxShell(34, "window.update.noupdates", (String[])null);
                            mb.open(null);
                        }
                    }
                });
            }
        });
    }

    public static MenuItem addBetaMenuItem(Menu menuParent) {
        final MenuItem menuItem = MenuFactory.addMenuItem(menuParent, "MainWindow.menu.beta", new Listener(){

            public void handleEvent(Event e) {
                new BetaWizard();
            }
        });
        COConfigurationManager.addAndFireParameterListener("Beta Programme Enabled", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        if (menuItem.isDisposed()) {
                            return;
                        }
                        boolean enabled = COConfigurationManager.getBooleanParameter("Beta Programme Enabled");
                        Messages.setLanguageText(menuItem, MessageText.resolveLocalizationKey("MainWindow.menu.beta" + (enabled ? ".off" : ".on")));
                    }
                });
            }
        });
        return menuItem;
    }

    public static MenuItem addPluginInstallMenuItem(Menu menuParent) {
        return MenuFactory.addMenuItem(menuParent, "MainWindow.menu.plugins.installPlugins", new Listener(){

            public void handleEvent(Event e) {
                new InstallPluginWizard();
            }
        });
    }

    public static MenuItem addPluginUnInstallMenuItem(Menu menuParent) {
        return MenuFactory.addMenuItem(menuParent, "MainWindow.menu.plugins.uninstallPlugins", new Listener(){

            public void handleEvent(Event e) {
                new UnInstallPluginWizard(MenuFactory.getDisplay());
            }
        });
    }

    public static final MenuItem addLabelMenuItem(Menu menu, String localizationKey) {
        MenuItem item = new MenuItem(menu, 0);
        Messages.setLanguageText(item, localizationKey);
        item.setEnabled(false);
        return item;
    }

    public static MenuItem addSeparatorMenuItem(Menu menuParent) {
        return new MenuItem(menuParent, 2);
    }

    public static MenuItem createTopLevelMenuItem(Menu menuParent, String localizationKey) {
        Menu menu = new Menu(menuParent.getShell(), 4);
        MenuItem menuItem = new MenuItem(menuParent, 64);
        Messages.setLanguageText(menuItem, localizationKey);
        menuItem.setMenu(menu);
        menu.setData("key.menu.id", localizationKey);
        menuItem.setData("key.menu.id", localizationKey);
        return menuItem;
    }

    public static final MenuItem addMenuItem(Menu menu, String localizationKey, Listener selListener) {
        return MenuFactory.addMenuItem(menu, localizationKey, selListener, 0);
    }

    public static final MenuItem addMenuItem(Menu menu, String localizationKey, Listener selListener, int style) {
        MenuItem menuItem = new MenuItem(menu, style);
        Messages.setLanguageText(menuItem, MessageText.resolveLocalizationKey(localizationKey));
        KeyBindings.setAccelerator(menuItem, MessageText.resolveAcceleratorKey(localizationKey));
        if (null != selListener) {
            menuItem.addListener(13, selListener);
        }
        menuItem.setData("key.menu.id", localizationKey);
        return menuItem;
    }

    public static final MenuItem addMenuItem(Menu menu, int style, String localizationKey, Listener selListener) {
        return MenuFactory.addMenuItem(menu, style, -1, localizationKey, selListener);
    }

    public static final MenuItem addMenuItem(Menu menu, int style, int index, String localizationKey, Listener selListener) {
        if (index < 0 || index > menu.getItemCount()) {
            index = menu.getItemCount();
        }
        MenuItem menuItem = new MenuItem(menu, style, index);
        Messages.setLanguageText(menuItem, localizationKey);
        KeyBindings.setAccelerator(menuItem, localizationKey);
        menuItem.addListener(13, selListener);
        menuItem.setData("key.menu.id", localizationKey);
        return menuItem;
    }

    private static UIFunctionsSWT getUIFunctionSWT() {
        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (null != uiFunctions) {
            return uiFunctions;
        }
        throw new IllegalStateException("No instance of UIFunctionsSWT found; the UIFunctionsManager might not have been initialized properly");
    }

    private static Display getDisplay() {
        return SWTThread.getInstance().getDisplay();
    }

    public static void updateMenuText(Object menu) {
        if (menu == null) {
            return;
        }
        if (menu instanceof Menu) {
            MenuItem[] menus = ((Menu)menu).getItems();
            for (int i = 0; i < menus.length; ++i) {
                MenuFactory.updateMenuText(menus[i]);
            }
        } else if (menu instanceof MenuItem) {
            MenuItem item = (MenuItem)menu;
            if (item.getData("key.menu.id") instanceof String) {
                String localizationKey = (String)item.getData("key.menu.id");
                item.setText(MessageText.getString(localizationKey));
                KeyBindings.setAccelerator(item, MessageText.resolveAcceleratorKey(localizationKey));
                MenuFactory.updateMenuText(item.getMenu());
            } else {
                Messages.updateLanguageForControl(item);
            }
        }
    }

    public static void performOneTimeDisable(MenuItem item, boolean affectsChildMenuItems) {
        item.setEnabled(false);
        if (affectsChildMenuItems) {
            Menu childMenu = item.getMenu();
            if (childMenu == null) {
                return;
            }
            for (int i = 0; i < childMenu.getItemCount(); ++i) {
                childMenu.getItem(i).setEnabled(false);
            }
        }
    }

    public static Menu findMenu(Menu menuToStartWith, String idToMatch) {
        if (null == menuToStartWith || menuToStartWith.isDisposed() || null == idToMatch || idToMatch.length() < 1) {
            return null;
        }
        if (idToMatch.equals(MenuFactory.getID(menuToStartWith))) {
            return menuToStartWith;
        }
        MenuItem[] items = menuToStartWith.getItems();
        for (int i = 0; i < items.length; ++i) {
            MenuItem item = items[i];
            Menu menuToFind = MenuFactory.findMenu(item.getMenu(), idToMatch);
            if (null == menuToFind) continue;
            return menuToFind;
        }
        return null;
    }

    public static MenuItem findMenuItem(Menu menuToStartWith, String idToMatch) {
        return MenuFactory.findMenuItem(menuToStartWith, idToMatch, true);
    }

    public static MenuItem findMenuItem(Menu menuToStartWith, String idToMatch, boolean deep) {
        if (null == menuToStartWith || menuToStartWith.isDisposed() || null == idToMatch || idToMatch.length() < 1) {
            return null;
        }
        MenuItem[] items = menuToStartWith.getItems();
        for (int i = 0; i < items.length; ++i) {
            MenuItem menuItemToFind;
            MenuItem item = items[i];
            if (idToMatch.equals(MenuFactory.getID(item))) {
                return item;
            }
            if (!deep || null == (menuItemToFind = MenuFactory.findMenuItem(item.getMenu(), idToMatch))) continue;
            return menuItemToFind;
        }
        return null;
    }

    private static String getID(Widget widget) {
        Object id;
        if (null != widget && !widget.isDisposed() && null != (id = widget.getData("key.menu.id"))) {
            return id.toString();
        }
        return "";
    }

    public static void setEnablementKeys(Widget widget, int keys) {
        if (null != widget && !widget.isDisposed()) {
            widget.setData("key.enablement", new Integer(keys));
        }
    }

    public static int getEnablementKeys(Widget widget) {
        Object keys;
        if (null != widget && !widget.isDisposed() && (keys = widget.getData("key.enablement")) instanceof Integer) {
            return (Integer)keys;
        }
        return -1;
    }

    public static void updateEnabledStates(Menu menuToStartWith) {
        if (null == menuToStartWith || menuToStartWith.isDisposed()) {
            return;
        }
        if (!MenuFactory.setEnablement(menuToStartWith)) {
            return;
        }
        MenuItem[] items = menuToStartWith.getItems();
        for (int i = 0; i < items.length; ++i) {
            MenuItem item = items[i];
            if (!MenuFactory.setEnablement(item)) continue;
            MenuFactory.updateEnabledStates(item.getMenu());
        }
    }

    public static boolean setEnablement(Widget widget) {
        if (null != widget && !widget.isDisposed()) {
            boolean isEnabled = MenuFactory.isEnabledForCurrentMode(widget);
            if (widget instanceof MenuItem) {
                ((MenuItem)widget).setEnabled(isEnabled);
            } else if (widget instanceof Menu) {
                ((Menu)widget).setEnabled(isEnabled);
            }
            return isEnabled;
        }
        return false;
    }

    public static boolean isEnabledForCurrentMode(Widget widget) {
        int keys = MenuFactory.getEnablementKeys(widget);
        if (keys <= 0) {
            return true;
        }
        if (isAZ3) {
            return (keys & 2) != 0;
        }
        return (keys & 1) != 0;
    }

    private static TableRow wrapAsRow(final Object o, final String table_name) {
        return new TableRow(){

            public Object getDataSource() {
                return o;
            }

            public String getTableID() {
                return table_name;
            }

            private void notSupported() {
                throw new RuntimeException("method is not supported - table row is a \"virtual\" one, only getDataSource and getTableID are supported.");
            }

            private void setForegroundDebug() {
                if (DEBUG_SET_FOREGROUND) {
                    Debug.out("setForeground on fake TableRow");
                }
            }

            public void setForeground(int red, int green, int blue) {
                this.setForegroundDebug();
                this.notSupported();
            }

            public void setForeground(int[] rgb) {
                this.setForegroundDebug();
                this.notSupported();
            }

            public void setForegroundToErrorColor() {
                this.setForegroundDebug();
                this.notSupported();
            }

            public boolean isValid() {
                this.notSupported();
                return false;
            }

            public TableCell getTableCell(String sColumnName) {
                this.notSupported();
                return null;
            }

            public boolean isSelected() {
                this.notSupported();
                return false;
            }

            public void addMouseListener(TableRowMouseListener listener) {
                this.notSupported();
            }

            public void removeMouseListener(TableRowMouseListener listener) {
                this.notSupported();
            }

            public Object getData(String id) {
                return null;
            }

            public void setData(String id, Object data) {
            }
        };
    }
}

