/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.help;

import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import java.util.Properties;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThreadAlreadyInstanciatedException;
import org.gudy.azureus2.update.CorePatchLevel;

public class AboutWindow {
    private static final String IMG_SPLASH = "azureus_splash";
    static Image image;
    static AEMonitor class_mon;
    private static Shell instance;
    private static Image imgSrc;
    private static int paintColorTo;

    public static void show() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                AboutWindow._show();
            }
        });
    }

    private static void _show() {
        if (instance != null) {
            instance.open();
            return;
        }
        paintColorTo = 0;
        Properties properties = new Properties();
        try {
            properties.load(AboutWindow.class.getClassLoader().getResourceAsStream("org/gudy/azureus2/ui/swt/about.properties"));
        }
        catch (Exception e1) {
            Debug.printStackTrace(e1);
            return;
        }
        final Shell window = ShellFactory.createMainShell(Constants.isOSX ? 2144 : 67680);
        Utils.setShellIcon(window);
        final Display display = window.getDisplay();
        window.setText(MessageText.getString("MainWindow.about.title") + " " + "4.6.0.4");
        window.setLayout(new GridLayout(3, false));
        ImageLoader imageLoader = ImageLoader.getInstance();
        imgSrc = imageLoader.getImage(IMG_SPLASH);
        if (imgSrc != null) {
            int w;
            int ow = w = AboutWindow.imgSrc.getBounds().width;
            if (w > 350) {
                w = 350;
            }
            int h = AboutWindow.imgSrc.getBounds().height;
            Image imgGray = new Image((Device)display, imageLoader.getImage(IMG_SPLASH), 2);
            imageLoader.releaseImage(IMG_SPLASH);
            GC gc = new GC(imgGray);
            if (Constants.isOSX) {
                gc.drawImage(imgGray, (w - ow) / 2, 0);
            } else {
                gc.copyArea(0, 0, ow, h, (w - ow) / 2, 0);
            }
            gc.dispose();
            Image image2 = new Image((Device)display, w, h);
            gc = new GC(image2);
            gc.setBackground(window.getBackground());
            gc.fillRectangle(image2.getBounds());
            gc.dispose();
            image = Utils.renderTransparency(display, image2, imgGray, new Point(0, 0), 180);
            image2.dispose();
            imgGray.dispose();
        }
        Group gDevelopers = new Group(window, 0);
        gDevelopers.setLayout(new GridLayout());
        Messages.setLanguageText(gDevelopers, "MainWindow.about.section.developers");
        GridData gridData = new GridData(272);
        gDevelopers.setLayoutData(gridData);
        Label label = new Label(gDevelopers, 16384);
        label.setText(properties.getProperty("developers"));
        gridData = new GridData();
        label.setLayoutData(gridData);
        final Canvas labelImage = new Canvas(window, 0x20000000);
        gridData = new GridData(272);
        Rectangle imgBounds = image.getBounds();
        gridData.widthHint = 300;
        labelImage.setLayoutData(gridData);
        labelImage.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Rectangle boundsColor = imgSrc.getBounds();
                int ofs = (labelImage.getSize().x - boundsColor.width) / 2;
                if (paintColorTo > 0) {
                    e.gc.drawImage(imgSrc, 0, 0, paintColorTo, boundsColor.height, ofs, 20, paintColorTo, boundsColor.height);
                }
                Rectangle imgBounds = image.getBounds();
                if (imgBounds.width - paintColorTo - 1 > 0) {
                    e.gc.drawImage(image, paintColorTo + 1, 0, imgBounds.width - paintColorTo - 1, imgBounds.height, paintColorTo + 1 + ofs, 20, imgBounds.width - paintColorTo - 1, imgBounds.height);
                }
            }
        });
        Group gTranslators = new Group(window, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 2;
        gl.marginWidth = 0;
        gTranslators.setLayout(gl);
        Messages.setLanguageText(gTranslators, "MainWindow.about.section.translators");
        gridData = new GridData(272);
        gTranslators.setLayoutData(gridData);
        Text txtTrans = new Text(gTranslators, 524362);
        txtTrans.setText(properties.getProperty("translators"));
        gridData = new GridData(1808);
        gridData.heightHint = txtTrans.computeSize((int)-1, (int)-1).y + 10;
        txtTrans.setLayoutData(gridData);
        txtTrans.setBackground(display.getSystemColor(22));
        Group gInternet = new Group(window, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        gInternet.setLayout(gridLayout);
        Messages.setLanguageText(gInternet, "MainWindow.about.section.internet");
        gridData = new GridData(272);
        gridData.horizontalSpan = 2;
        gInternet.setLayoutData(gridData);
        Group gSys = new Group(window, 0);
        gSys.setLayout(new GridLayout());
        Messages.setLanguageText(gSys, "MainWindow.about.section.system");
        gridData = new GridData(272);
        gridData.verticalSpan = 1;
        gSys.setLayoutData(gridData);
        Text txtSysInfo = new Text(gSys, 74);
        txtSysInfo.setBackground(display.getSystemColor(22));
        txtSysInfo.setText("Java " + System.getProperty("java.version") + "\n " + System.getProperty("java.vendor") + "\n" + "SWT v" + SWT.getVersion() + ", " + SWT.getPlatform() + "\n" + System.getProperty("os.name") + " v" + System.getProperty("os.version") + ", " + System.getProperty("os.arch") + "\n" + Constants.APP_NAME.charAt(0) + "4.6.0.4" + ("".length() == 0 ? "" : "-") + "/" + CorePatchLevel.getCurrentPatchLevel() + " " + COConfigurationManager.getStringParameter("ui"));
        gridData = new GridData(1808);
        txtSysInfo.setLayoutData(gridData);
        if (window.getCaret() != null) {
            window.getCaret().setVisible(false);
        }
        String[][] link = new String[][]{{"homepage", "sourceforge", "sourceforgedownloads", "bugreports", "forumdiscussion", "wiki"}, {"http://www.vuze.com", "http://azureus.sourceforge.net", "http://sourceforge.net/project/showfiles.php?group_id=84122", "http://forum.vuze.com/category.jspa?categoryID=3", "http://forum.vuze.com", "http://wiki.vuze.com/w/"}};
        for (int i = 0; i < link[0].length; ++i) {
            CLabel linkLabel = new CLabel(gInternet, 0);
            linkLabel.setText(MessageText.getString("MainWindow.about.internet." + link[0][i]));
            linkLabel.setData(link[1][i]);
            linkLabel.setCursor(display.getSystemCursor(21));
            linkLabel.setForeground(Colors.blue);
            gridData = new GridData(768);
            gridData.horizontalSpan = 1;
            linkLabel.setLayoutData(gridData);
            linkLabel.addMouseListener(new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent arg0) {
                    Utils.launch((String)((CLabel)arg0.widget).getData());
                }

                public void mouseDown(MouseEvent arg0) {
                    Utils.launch((String)((CLabel)arg0.widget).getData());
                }
            });
        }
        Listener keyListener = new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\u001b') {
                    window.dispose();
                }
            }
        };
        window.addListener(2, keyListener);
        window.pack();
        txtSysInfo.setFocus();
        Utils.centreWindow(window);
        window.open();
        instance = window;
        window.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event2) {
                instance = null;
                AboutWindow.disposeImage();
            }
        });
        AEThread2 updater = new AEThread2("Splash Screen Updater", true){

            public void run() {
                if (image == null || image.isDisposed()) {
                    return;
                }
                int maxX = AboutWindow.image.getBounds().width;
                final int maxY = AboutWindow.image.getBounds().height;
                while (paintColorTo < maxX) {
                    if (image == null || image.isDisposed()) {
                        paintColorTo = maxX;
                        break;
                    }
                    if (display.isDisposed()) {
                        paintColorTo = maxX;
                        break;
                    }
                    Utils.execSWTThread(new AERunnable(){

                        public void runSupport() {
                            if (labelImage.isDisposed()) {
                                return;
                            }
                            paintColorTo++;
                            Rectangle boundsColor = imgSrc.getBounds();
                            int ofs = (labelImage.getSize().x - boundsColor.width) / 2;
                            labelImage.redraw(paintColorTo - 1 + ofs, 20, 2, maxY, true);
                        }
                    });
                    try {
                        Thread.sleep(30L);
                    }
                    catch (Exception e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        };
        updater.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disposeImage() {
        try {
            class_mon.enter();
            if (image != null && !image.isDisposed()) {
                image.dispose();
            }
            ImageLoader imageLoader = ImageLoader.getInstance();
            imageLoader.releaseImage(IMG_SPLASH);
            image = null;
            imgSrc = null;
            Object var2_1 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    public static void main(String[] args) {
        try {
            new Display();
            Colors.getInstance();
            SWTThread.createInstance(null);
            AboutWindow.show();
        }
        catch (SWTThreadAlreadyInstanciatedException e) {
            e.printStackTrace();
        }
    }

    static {
        class_mon = new AEMonitor("AboutWindow");
        paintColorTo = 0;
    }
}

