/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.BufferedWidget;
import org.gudy.azureus2.ui.swt.mainwindow.ClipboardCopy;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;

public class BufferedLabel
extends BufferedWidget {
    private Label label = (Label)this.getWidget();
    private String value = "";

    public BufferedLabel(Composite composite, int attrs) {
        super(new Label(composite, attrs));
        ClipboardCopy.addCopyToClipMenu(this.label, new ClipboardCopy.copyToClipProvider(){

            public String getText() {
                return BufferedLabel.this.label.getText();
            }
        });
    }

    public boolean isDisposed() {
        return this.label.isDisposed();
    }

    public void setLayoutData(GridData gd) {
        this.label.setLayoutData(gd);
    }

    public void setLayoutData(FormData gd) {
        this.label.setLayoutData(gd);
    }

    public void setLayoutData(Object ld) {
        this.label.setLayoutData(ld);
    }

    public Control getControl() {
        return this.label;
    }

    public void setText(String new_value) {
        if (this.label.isDisposed()) {
            return;
        }
        if (new_value == this.value) {
            return;
        }
        if (new_value != null && this.value != null && new_value.equals(this.value)) {
            return;
        }
        this.value = new_value;
        this.label.setText(this.value == null ? "" : this.value.replaceAll("&", "&&"));
    }

    public void setLink(String url) {
        Object[] existing = (Object[])this.label.getData();
        if (existing == null && url == null) {
            return;
        }
        if (existing != null && url != null && ((String[])existing)[0].equals(url)) {
            return;
        }
        if (url == null) {
            this.label.setData(null);
            this.label.setCursor(null);
            this.label.setForeground(null);
            this.label.setToolTipText(null);
        } else {
            final String[] data = new String[]{url};
            this.label.setData(data);
            this.label.setToolTipText(url);
            this.label.setCursor(this.label.getDisplay().getSystemCursor(21));
            this.label.setForeground(Colors.blue);
            this.label.addMouseListener(new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent arg0) {
                    this.showURL((Label)arg0.widget);
                }

                public void mouseUp(MouseEvent arg0) {
                    this.showURL((Label)arg0.widget);
                }

                protected void showURL(Label label) {
                    if (label.getData() == data) {
                        Utils.launch(data[0]);
                    } else {
                        label.removeMouseListener(this);
                    }
                }
            });
        }
    }

    public String getText() {
        return this.value == null ? "" : this.value;
    }

    public void addMouseListener(MouseListener listener) {
        this.label.addMouseListener(listener);
    }

    public void setForeground(Color color) {
        this.label.setForeground(color);
    }

    public void setCursor(Cursor cursor) {
        this.label.setCursor(cursor);
    }

    public void setToolTipText(String toolTipText) {
        this.label.setToolTipText(toolTipText);
    }
}

