/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.console.commands;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gudy.azureus2.ui.console.ConsoleInput;

public abstract class IConsoleCommand {
    private String main_name;
    private String short_name;
    private HashSet commands = new HashSet();

    public IConsoleCommand(String main_name) {
        this(main_name, null);
    }

    public IConsoleCommand(String main_name, String short_name) {
        this.main_name = main_name;
        this.short_name = short_name;
        if (main_name != null) {
            this.commands.add(main_name);
        }
        if (short_name != null) {
            this.commands.add(short_name);
        }
    }

    public abstract void execute(String var1, ConsoleInput var2, List var3);

    public abstract String getCommandDescriptions();

    public final void printHelp(PrintStream out, List args) {
        out.println(this.getCommandDescriptions());
        this.printHelpExtra(out, args);
    }

    public void printHelpExtra(PrintStream out, List args) {
    }

    protected final void printHelp(PrintStream out, String arg) {
        ArrayList<String> args;
        if (arg != null) {
            args = new ArrayList<String>();
            args.add(arg);
        } else {
            args = Collections.EMPTY_LIST;
        }
        this.printHelp(out, args);
    }

    public Set getCommandNames() {
        return Collections.unmodifiableSet(this.commands);
    }

    public final String getCommandName() {
        return this.main_name;
    }

    public final String getShortCommandName() {
        return this.short_name;
    }
}

