/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.console.commands;

import com.aelitis.azureus.core.AzureusCoreException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.gudy.azureus2.ui.console.ConsoleInput;
import org.gudy.azureus2.ui.console.commands.OptionsConsoleCommand;
import org.pf.file.FileFinder;
import org.pf.text.StringUtil;

public class AddFind
extends OptionsConsoleCommand {
    public AddFind() {
        super("add", "a");
        OptionBuilder.withArgName((String)"outputDir");
        OptionBuilder.withLongOpt((String)"output");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"override default download directory");
        OptionBuilder.withType(File.class);
        this.getOptions().addOption(OptionBuilder.create((char)'o'));
        this.getOptions().addOption("r", "recurse", false, "recurse sub-directories.");
        this.getOptions().addOption("f", "find", false, "only find files, don't add.");
        this.getOptions().addOption("h", "help", false, "display help about this command");
        this.getOptions().addOption("l", "list", false, "list previous find results");
    }

    public String getCommandDescriptions() {
        return "add [addoptions] [.torrent path|url]\t\ta\tAdd a download from the given .torrent file path or url. Example: 'add /path/to/the.torrent' or 'add http://www.url.com/to/the.torrent'";
    }

    public void execute(String commandName, ConsoleInput ci, CommandLine commands) {
        if (commands.hasOption('l')) {
            ci.out.println("> -----");
            this.showAdds(ci);
            ci.out.println("> -----");
            return;
        }
        if (commands.hasOption('h') || commands.getArgs().length == 0) {
            this.printHelp(ci.out, (String)null);
            return;
        }
        String outputDir = ".";
        outputDir = commands.hasOption('o') ? commands.getOptionValue('o') : ci.getDefaultSaveDirectory();
        File f = new File(outputDir);
        if (!f.isAbsolute()) {
            try {
                outputDir = new File(".", outputDir).getCanonicalPath();
            }
            catch (IOException e) {
                throw new AzureusCoreException("exception occurred while converting directory: ./" + outputDir + " to its canonical path");
            }
        }
        boolean scansubdir = commands.hasOption('r');
        boolean finding = commands.hasOption('f');
        String[] whatelse = commands.getArgs();
        for (int i = 0; i < whatelse.length; ++i) {
            String arg = whatelse[i];
            try {
                new URL(arg);
                this.addRemote(ci, arg, outputDir);
                continue;
            }
            catch (MalformedURLException e) {
                this.addLocal(ci, arg, outputDir, scansubdir, finding);
            }
        }
    }

    protected void addRemote(ConsoleInput ci, String arg, String outputDir) {
        ci.out.println("> Starting Download of " + arg + " ...");
        try {
            ci.downloadRemoteTorrent(arg, outputDir);
        }
        catch (Exception e) {
            ci.out.println("An error occurred while downloading torrent: " + e.getMessage());
            e.printStackTrace(ci.out);
        }
    }

    protected void addLocal(ConsoleInput ci, String arg, String outputDir, boolean scansubdir, boolean finding) {
        File test = new File(arg = this.transformLocalArgument(arg));
        if (test.exists()) {
            if (test.isDirectory()) {
                File[] toadd = FileFinder.findFiles(arg, "*.torrent;*.tor", scansubdir);
                if (toadd != null && toadd.length > 0) {
                    this.addFiles(ci, toadd, finding, outputDir);
                } else {
                    ci.adds = null;
                    ci.out.println("> Directory '" + arg + "' seems to contain no torrent files.");
                }
            } else {
                ci.downloadTorrent(arg, outputDir);
                ci.out.println("> '" + arg + "' added.");
                ci.torrents.clear();
            }
            return;
        }
        try {
            int id = Integer.parseInt(arg);
            if (ci.adds != null && ci.adds.length > id) {
                String torrentPath = ci.adds[id].getAbsolutePath();
                ci.downloadTorrent(torrentPath, outputDir);
                ci.out.println("> '" + torrentPath + "' added.");
                ci.torrents.clear();
            } else {
                ci.out.println("> No such file id '" + id + "'. Try \"add -l\" to list available files");
            }
            return;
        }
        catch (NumberFormatException e) {
            String filePattern;
            File[] files;
            String dirName = test.getParent();
            if (dirName == null) {
                dirName = ".";
            }
            if ((files = FileFinder.findFiles(dirName, filePattern = test.getName(), false)) != null && files.length > 0) {
                this.addFiles(ci, files, finding, outputDir);
            } else {
                ci.adds = null;
                ci.out.println("> No files found. Searched for '" + filePattern + "' in '" + dirName + "'");
            }
            return;
        }
    }

    protected String transformLocalArgument(String arg) {
        if (arg.startsWith("~/") || arg.equals("~")) {
            arg = StringUtil.current().replaceAll(arg, "~", System.getProperty("user.home"));
        }
        return arg;
    }

    protected void addFiles(ConsoleInput ci, File[] toadd, boolean finding, String outputDir) {
        ci.out.println("> -----");
        ci.out.println("> Found " + toadd.length + " files:");
        if (finding) {
            ci.adds = toadd;
            this.showAdds(ci);
        } else {
            for (int i = 0; i < toadd.length; ++i) {
                ci.downloadTorrent(toadd[i].getAbsolutePath(), outputDir);
                ci.out.println("> '" + toadd[i].getAbsolutePath() + "' added.");
                ci.torrents.clear();
            }
        }
        ci.out.println("> -----");
    }

    private void showAdds(ConsoleInput ci) {
        if (ci.adds == null || ci.adds.length == 0) {
            ci.out.println("> No files found. Try \"add -f <path>\" first");
            return;
        }
        for (int i = 0; i < ci.adds.length; ++i) {
            ci.out.print(">\t" + i + ":\t");
            try {
                ci.out.println(ci.adds[i].getCanonicalPath());
                continue;
            }
            catch (Exception e) {
                ci.out.println(ci.adds[i].getAbsolutePath());
            }
        }
        ci.out.println("> To add, simply type 'add <id>'");
    }
}

