/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderListener;

public class Test
implements ResourceDownloaderListener,
Plugin {
    public void initialize(PluginInterface pi) {
        try {
            ResourceDownloaderFactory rdf = pi.getUtilities().getResourceDownloaderFactory();
            ResourceDownloader rd_u = rdf.create(new URL("http://torrent.vuze.com:88/files/Azureus3009-B5.jar"));
            rd_u.addListener(new ResourceDownloaderAdapter(){

                public boolean completed(ResourceDownloader downloader, InputStream data) {
                    System.out.println("complete");
                    return true;
                }

                public void reportPercentComplete(ResourceDownloader downloader, int percentage) {
                    System.out.println("percentage = " + percentage);
                }

                public void reportAmountComplete(ResourceDownloader downloader, long amount) {
                    System.out.println("amount = " + amount);
                }

                public void reportActivity(ResourceDownloader downloader, String activity) {
                    System.out.println("activity = " + activity);
                }

                public void failed(ResourceDownloader downloader, ResourceDownloaderException e) {
                    System.out.println("failed");
                    e.printStackTrace();
                }
            });
            InputStream is = rd_u.download();
            FileUtil.copyFile(is, new File("C:\\temp\\file.jar"));
            is.close();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public void reportPercentComplete(ResourceDownloader downloader, int percentage) {
        System.out.println("percent = " + percentage);
    }

    public void reportAmountComplete(ResourceDownloader downloader, long amount) {
    }

    public void reportActivity(ResourceDownloader downloader, String activity) {
        System.out.println("activity = " + activity);
    }

    public boolean completed(ResourceDownloader downloader, InputStream data) {
        System.out.println("Completed");
        return true;
    }

    public void failed(ResourceDownloader downloader, ResourceDownloaderException e) {
        System.out.println("Failed");
        Debug.printStackTrace(e);
    }

    public static void main(String[] args) {
        try {
            PluginManager.registerPlugin(Test.class);
            PluginManager.startAzureus(0, new Properties());
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }
}

