/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.update;

import com.aelitis.azureus.core.AzureusCore;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.AEVerifier;
import org.gudy.azureus2.core3.util.AEVerifierException;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.update.UpdatableComponent;
import org.gudy.azureus2.plugins.update.Update;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateException;
import org.gudy.azureus2.plugins.update.UpdateInstaller;
import org.gudy.azureus2.plugins.update.UpdateManager;
import org.gudy.azureus2.plugins.update.UpdateManagerListener;
import org.gudy.azureus2.plugins.update.UpdateManagerVerificationListener;
import org.gudy.azureus2.pluginsimpl.local.update.UpdatableComponentImpl;
import org.gudy.azureus2.pluginsimpl.local.update.UpdateCheckInstanceImpl;
import org.gudy.azureus2.pluginsimpl.local.update.UpdateInstallerImpl;

public class UpdateManagerImpl
implements UpdateManager {
    private static UpdateManagerImpl singleton;
    private AzureusCore azureus_core;
    private List<UpdateCheckInstanceImpl> checkers = new ArrayList<UpdateCheckInstanceImpl>();
    private List<UpdatableComponentImpl> components = new ArrayList<UpdatableComponentImpl>();
    private List listeners = new ArrayList();
    private List verification_listeners = new ArrayList();
    private List<UpdateInstaller> installers = new ArrayList<UpdateInstaller>();
    protected AEMonitor this_mon = new AEMonitor("UpdateManager");

    public static UpdateManager getSingleton(AzureusCore core) {
        if (singleton == null) {
            singleton = new UpdateManagerImpl(core);
        }
        return singleton;
    }

    protected UpdateManagerImpl(AzureusCore _azureus_core) {
        this.azureus_core = _azureus_core;
        UpdateInstallerImpl.checkForFailedInstalls(this);
        try {
            PlatformManagerFactory.getPlatformManager();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected AzureusCore getCore() {
        return this.azureus_core;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerUpdatableComponent(UpdatableComponent component, boolean mandatory) {
        try {
            this.this_mon.enter();
            this.components.add(new UpdatableComponentImpl(component, mandatory));
            Object var4_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateCheckInstance[] getCheckInstances() {
        try {
            this.this_mon.enter();
            UpdateCheckInstance[] updateCheckInstanceArray = this.checkers.toArray(new UpdateCheckInstance[this.checkers.size()]);
            Object var3_2 = null;
            this.this_mon.exit();
            return updateCheckInstanceArray;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public UpdateCheckInstance createUpdateCheckInstance() {
        return this.createUpdateCheckInstance(2, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateCheckInstance createUpdateCheckInstance(int type, String name) {
        try {
            this.this_mon.enter();
            UpdatableComponentImpl[] comps = new UpdatableComponentImpl[this.components.size()];
            this.components.toArray(comps);
            UpdateCheckInstanceImpl res = new UpdateCheckInstanceImpl(this, type, name, comps);
            this.checkers.add(res);
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((UpdateManagerListener)this.listeners.get(i)).checkInstanceCreated(res);
            }
            UpdateCheckInstanceImpl updateCheckInstanceImpl = res;
            Object var7_7 = null;
            this.this_mon.exit();
            return updateCheckInstanceImpl;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public UpdateCheckInstanceImpl createEmptyUpdateCheckInstance(int type, String name) {
        return this.createEmptyUpdateCheckInstance(type, name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateCheckInstanceImpl createEmptyUpdateCheckInstance(int type, String name, boolean low_noise) {
        try {
            this.this_mon.enter();
            UpdatableComponentImpl[] comps = new UpdatableComponentImpl[]{};
            UpdateCheckInstanceImpl res = new UpdateCheckInstanceImpl(this, type, name, comps);
            res.setLowNoise(low_noise);
            this.checkers.add(res);
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((UpdateManagerListener)this.listeners.get(i)).checkInstanceCreated(res);
            }
            UpdateCheckInstanceImpl updateCheckInstanceImpl = res;
            Object var8_8 = null;
            this.this_mon.exit();
            return updateCheckInstanceImpl;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public UpdateInstaller createInstaller() throws UpdateException {
        UpdateInstallerImpl installer = new UpdateInstallerImpl(this);
        this.installers.add(installer);
        return installer;
    }

    public UpdateInstaller[] getInstallers() {
        UpdateInstaller[] res = new UpdateInstaller[this.installers.size()];
        this.installers.toArray(res);
        return res;
    }

    protected void removeInstaller(UpdateInstaller installer) {
        this.installers.remove(installer);
    }

    public String getInstallDir() {
        String str = SystemProperties.getApplicationPath();
        if (str.endsWith(File.separator)) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public String getUserDir() {
        String str = SystemProperties.getUserPath();
        if (str.endsWith(File.separator)) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public void restart() throws UpdateException {
        this.applyUpdates(true);
    }

    public void applyUpdates(boolean restart_after) throws UpdateException {
        try {
            if (restart_after) {
                this.azureus_core.requestRestart();
            } else {
                this.azureus_core.requestStop();
            }
        }
        catch (Throwable e) {
            throw new UpdateException("UpdateManager:applyUpdates fails", e);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream verifyData(Update update, InputStream is, boolean force) throws UpdateException {
        queried = false;
        ok = false;
        failure /* !! */  = null;
        try {
            try {
                temp = AETemporaryFileHandler.createTempFile();
                FileUtil.copyFile(is, temp);
                try {
                    AEVerifier.verifyData(temp);
                    ok = true;
                    var8_10 = new FileInputStream(temp);
                    ** GOTO lbl40
                }
                catch (AEVerifierException e) {
                    block28: {
                        block27: {
                            block25: {
                                if (force || e.getFailureType() != 1) break block27;
                                i = 0;
lbl16:
                                // 2 sources

                                while (i < this.verification_listeners.size()) {
                                    try {
                                        queried = true;
                                        if (!((UpdateManagerVerificationListener)this.verification_listeners.get(i)).acceptUnVerifiedUpdate(update)) break block25;
                                        ok = true;
                                        var10_23 = new FileInputStream(temp);
                                    }
                                    catch (Throwable f) {
                                        Debug.printStackTrace(f);
                                        break block25;
                                    }
                                    var12_13 = null;
                                    if (queried != false) return var10_23;
                                    if (!ok) {
                                        if (failure /* !! */  == null) {
                                            failure /* !! */  = new UpdateException("Verification failed");
                                        }
                                        for (i = 0; i < this.verification_listeners.size(); ++i) {
                                            try {
                                                ((UpdateManagerVerificationListener)this.verification_listeners.get(i)).verificationFailed(update, failure /* !! */ );
                                                continue;
                                            }
                                            catch (Throwable f) {
                                                Debug.printStackTrace(f);
                                            }
                                        }
                                    }
                                    return var10_23;
                                }
                                break block27;
lbl40:
                                // 1 sources

                                var12_12 = null;
                                if (queried != false) return var8_10;
                                if (!ok) {
                                    if (failure /* !! */  == null) {
                                        failure /* !! */  = new UpdateException("Verification failed");
                                    }
                                    break block28;
                                } else {
                                    return var8_10;
                                }
                            }
                            ++i;
                            ** GOTO lbl16
                        }
                        failure /* !! */  = e;
                        throw e;
                    }
                    i = 0;
                }
            }
            catch (UpdateException e) {
                failure /* !! */  = e;
                throw e;
            }
            catch (Throwable e) {
                failure /* !! */  = e;
                throw new UpdateException("Verification failed", e);
            }
        }
        catch (Throwable var11_24) {
            var12_14 = null;
            if (!queried && !ok) {
                if (failure /* !! */  == null) {
                    failure /* !! */  = new UpdateException("Verification failed");
                }
                for (i = 0; i < this.verification_listeners.size(); ++i) {
                    ** try [egrp 4[TRYBLOCK] [11 : 226->251)] { 
lbl71:
                    // 1 sources

                    ((UpdateManagerVerificationListener)this.verification_listeners.get(i)).verificationFailed(update, failure /* !! */ );
                    continue;
lbl73:
                    // 1 sources

                    catch (Throwable f) {
                        Debug.printStackTrace(f);
                    }
                }
            }
            throw var11_24;
        }
        while (true) {
            block29: {
                if (i >= this.verification_listeners.size()) ** continue;
                ** try [egrp 4[TRYBLOCK] [11 : 226->251)] { 
lbl81:
                // 1 sources

                ((UpdateManagerVerificationListener)this.verification_listeners.get(i)).verificationFailed(update, failure /* !! */ );
                break block29;
lbl83:
                // 1 sources

                catch (Throwable f) {
                    Debug.printStackTrace(f);
                }
            }
            ++i;
        }
    }

    public void addVerificationListener(UpdateManagerVerificationListener l) {
        this.verification_listeners.add(l);
    }

    public void removeVerificationListener(UpdateManagerVerificationListener l) {
        this.verification_listeners.add(l);
    }

    public void addListener(UpdateManagerListener l) {
        this.listeners.add(l);
    }

    public void removeListener(UpdateManagerListener l) {
        this.listeners.remove(l);
    }
}

