/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.update;

import com.aelitis.azureus.core.update.AzureusRestarter;
import com.aelitis.azureus.core.update.AzureusRestarterFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.update.UpdateException;
import org.gudy.azureus2.plugins.update.UpdateInstaller;
import org.gudy.azureus2.plugins.update.UpdateInstallerListener;
import org.gudy.azureus2.pluginsimpl.local.update.UpdateManagerImpl;

public class UpdateInstallerImpl
implements UpdateInstaller {
    protected static final String UPDATE_DIR = "updates";
    protected static final String ACTIONS_LEGACY = "install.act";
    protected static final String ACTIONS_UTF8 = "install.act.utf8";
    protected static AEMonitor class_mon = new AEMonitor("UpdateInstaller:class");
    private UpdateManagerImpl manager;
    private File install_dir;

    protected static void checkForFailedInstalls(UpdateManagerImpl manager) {
        try {
            File update_dir = new File(manager.getUserDir() + File.separator + UPDATE_DIR);
            File[] dirs = update_dir.listFiles();
            if (dirs != null) {
                boolean found_failure = false;
                String files = "";
                for (int i = 0; i < dirs.length; ++i) {
                    File dir = dirs[i];
                    if (!dir.isDirectory()) continue;
                    found_failure = true;
                    File[] x = dir.listFiles();
                    if (x != null) {
                        for (int j = 0; j < x.length; ++j) {
                            files = files + (files.length() == 0 ? "" : ",") + x[j].getName();
                        }
                    }
                    FileUtil.recursiveDelete(dir);
                }
                if (found_failure) {
                    Logger.log(new LogAlert(false, 3, MessageText.getString("Alert.failed.update", new String[]{files})));
                }
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UpdateInstallerImpl(UpdateManagerImpl _manager) throws UpdateException {
        this.manager = _manager;
        try {
            class_mon.enter();
            String update_dir = this.getUserDir() + File.separator + UPDATE_DIR;
            for (int i = 1; i < 1024; ++i) {
                File try_dir = new File(update_dir + File.separator + "inst_" + i);
                if (try_dir.exists()) continue;
                if (!FileUtil.mkdirs(try_dir)) {
                    throw new UpdateException("Failed to create a temporary installation dir");
                }
                this.install_dir = try_dir;
                break;
            }
            if (this.install_dir == null) {
                throw new UpdateException("Failed to find a temporary installation dir");
            }
            Object var6_5 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    public void addResource(String resource_name, InputStream is) throws UpdateException {
        this.addResource(resource_name, is, true);
    }

    public void addResource(String resource_name, InputStream is, boolean closeInputStream) throws UpdateException {
        try {
            File target_file = new File(this.install_dir, resource_name);
            FileUtil.copyFile(is, (OutputStream)new FileOutputStream(target_file), closeInputStream);
        }
        catch (Throwable e) {
            throw new UpdateException("UpdateInstaller: resource addition fails", e);
        }
    }

    public String getInstallDir() {
        return this.manager.getInstallDir();
    }

    public String getUserDir() {
        return this.manager.getUserDir();
    }

    public void addMoveAction(String from_file_or_resource, String to_file) throws UpdateException {
        if (from_file_or_resource.indexOf(File.separator) == -1) {
            from_file_or_resource = this.install_dir.toString() + File.separator + from_file_or_resource;
        }
        try {
            File to_f = new File(to_file);
            File parent = to_f.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
            boolean log_perm_set_fail = true;
            if (parent != null && !parent.canWrite()) {
                log_perm_set_fail = false;
                if (!Constants.isWindowsVistaOrHigher) {
                    Logger.log(new LogAlert(false, 1, "The location '" + parent.toString() + "' isn't writable, this update will probably fail." + " Check permissions and retry the update"));
                }
            }
            try {
                PlatformManager pm = PlatformManagerFactory.getPlatformManager();
                if (pm.hasCapability(PlatformManagerCapabilities.CopyFilePermissions)) {
                    String parent_str = parent.getAbsolutePath();
                    PlatformManagerFactory.getPlatformManager().copyFilePermissions(parent_str, from_file_or_resource);
                }
            }
            catch (Throwable e) {
                if (log_perm_set_fail && !Constants.isWindowsVistaOrHigher) {
                    Debug.out(e);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.appendAction("move," + from_file_or_resource + "," + to_file);
    }

    public void addChangeRightsAction(String rights, String to_file) throws UpdateException {
        this.appendAction("chmod," + rights + "," + to_file);
    }

    public void addRemoveAction(String file) throws UpdateException {
        this.appendAction("remove," + file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void appendAction(String data) throws UpdateException {
        block14: {
            PrintWriter pw_legacy = null;
            try {
                try {
                    pw_legacy = new PrintWriter(new FileWriter(this.install_dir.toString() + File.separator + ACTIONS_LEGACY, true));
                    pw_legacy.println(data);
                }
                catch (Throwable e) {
                    throw new UpdateException("Failed to write actions file", e);
                }
                Object var5_3 = null;
                if (pw_legacy == null) break block14;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                if (pw_legacy == null) throw throwable;
                try {
                    pw_legacy.close();
                    throw throwable;
                }
                catch (Throwable e) {
                    throw new UpdateException("Failed to write actions file", e);
                }
            }
            try {}
            catch (Throwable e) {
                throw new UpdateException("Failed to write actions file", e);
            }
            pw_legacy.close();
        }
        PrintWriter pw_utf8 = null;
        try {
            try {
                pw_utf8 = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.install_dir.toString() + File.separator + ACTIONS_UTF8, true), "UTF-8"));
                pw_utf8.println(data);
            }
            catch (Throwable e) {
                throw new UpdateException("Failed to write actions file", e);
            }
            Object var8_11 = null;
            if (pw_utf8 == null) return;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (pw_utf8 == null) throw throwable;
            try {
                pw_utf8.close();
                throw throwable;
            }
            catch (Throwable e) {
                throw new UpdateException("Failed to write actions file", e);
            }
        }
        try {}
        catch (Throwable e) {
            throw new UpdateException("Failed to write actions file", e);
        }
        pw_utf8.close();
    }

    public void installNow(final UpdateInstallerListener listener) throws UpdateException {
        try {
            UpdateInstaller[] installers = this.manager.getInstallers();
            if (installers.length != 1 || installers[0] != this) {
                throw new UpdateException("Other installers exist - aborting");
            }
            listener.reportProgress("Update starts");
            AzureusRestarter ar = AzureusRestarterFactory.create(this.manager.getCore());
            ar.updateNow();
            new AEThread2("installNow:waiter", true){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    try {
                        try {
                            block10: {
                                long start = SystemTime.getMonotonousTime();
                                UpdateException pending_error = null;
                                do {
                                    Thread.sleep(1000L);
                                    listener.reportProgress("Checking progress");
                                    if (!UpdateInstallerImpl.this.install_dir.exists()) break block10;
                                    File fail_file = new File(UpdateInstallerImpl.this.install_dir, "install.fail");
                                    if (!fail_file.exists()) continue;
                                    try {
                                        String error = FileUtil.readFileAsString(fail_file, 1024);
                                        throw new UpdateException(error);
                                    }
                                    catch (Throwable e) {
                                        if (e instanceof UpdateException) {
                                            throw e;
                                        }
                                        if (pending_error != null) {
                                            throw pending_error;
                                        }
                                        pending_error = new UpdateException("Install failed, reason unknown");
                                    }
                                } while (SystemTime.getMonotonousTime() - start < 300000L);
                                listener.reportProgress("Timeout");
                                throw new UpdateException("Timeout waiting for update to apply");
                            }
                            listener.reportProgress("Complete");
                            listener.complete();
                        }
                        catch (Throwable e) {
                            UpdateException fail = e instanceof UpdateException ? (UpdateException)e : new UpdateException("install failed", e);
                            listener.reportProgress(fail.getMessage());
                            listener.failed(fail);
                            Object var7_8 = null;
                            UpdateInstallerImpl.this.deleteInstaller();
                            return;
                        }
                        Object var7_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_9 = null;
                        UpdateInstallerImpl.this.deleteInstaller();
                        throw throwable;
                    }
                    UpdateInstallerImpl.this.deleteInstaller();
                }
            }.start();
        }
        catch (Throwable e) {
            this.deleteInstaller();
            UpdateException fail = e instanceof UpdateException ? (UpdateException)e : new UpdateException("install failed", e);
            listener.reportProgress(fail.getMessage());
            listener.failed(fail);
            throw fail;
        }
    }

    public void destroy() {
        this.deleteInstaller();
    }

    private void deleteInstaller() {
        this.manager.removeInstaller(this);
        if (this.install_dir.exists()) {
            FileUtil.recursiveDelete(this.install_dir);
        }
    }
}

