/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.test;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.security.CryptoManagerPasswordHandler;
import java.io.File;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.ddb.DistributedDatabase;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseEvent;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseKey;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseListener;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseValue;
import org.gudy.azureus2.plugins.disk.DiskManager;
import org.gudy.azureus2.plugins.disk.DiskManagerException;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.disk.DiskManagerReadRequest;
import org.gudy.azureus2.plugins.disk.DiskManagerReadRequestListener;
import org.gudy.azureus2.plugins.disk.DiskManagerWriteRequest;
import org.gudy.azureus2.plugins.disk.DiskManagerWriteRequestListener;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadPeerListener;
import org.gudy.azureus2.plugins.messaging.Message;
import org.gudy.azureus2.plugins.messaging.MessageException;
import org.gudy.azureus2.plugins.messaging.MessageManager;
import org.gudy.azureus2.plugins.messaging.MessageManagerListener;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageConnection;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageConnectionListener;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageEndpoint;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageHandler;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageRegistration;
import org.gudy.azureus2.plugins.network.IncomingMessageQueueListener;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.peers.PeerManagerEvent;
import org.gudy.azureus2.plugins.peers.PeerManagerListener2;
import org.gudy.azureus2.plugins.peers.Piece;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.torrent.TorrentAttributeEvent;
import org.gudy.azureus2.plugins.torrent.TorrentAttributeListener;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.plugins.utils.Utilities;
import org.gudy.azureus2.plugins.utils.search.Search;
import org.gudy.azureus2.plugins.utils.search.SearchInitiator;
import org.gudy.azureus2.plugins.utils.search.SearchProvider;
import org.gudy.azureus2.plugins.utils.search.SearchProviderResults;
import org.gudy.azureus2.plugins.utils.search.SearchResult;
import org.gudy.azureus2.plugins.utils.security.SEPublicKey;
import org.gudy.azureus2.plugins.utils.security.SEPublicKeyLocator;
import org.gudy.azureus2.plugins.utils.security.SESecurityManager;
import org.gudy.azureus2.plugins.utils.subscriptions.Subscription;
import org.gudy.azureus2.plugins.utils.subscriptions.SubscriptionManager;
import org.gudy.azureus2.plugins.utils.subscriptions.SubscriptionResult;
import org.gudy.azureus2.ui.swt.Main;

public class Test
implements Plugin {
    protected PluginInterface plugin_interface;

    public void initialize(PluginInterface _pi) {
        this.plugin_interface = _pi;
        this.plugin_interface.addListener(new PluginListener(){

            public void initializationComplete() {
                AEThread t = new AEThread("test"){

                    public void runSupport() {
                        Test.this.testBTMessageHandler();
                    }
                };
                t.setDaemon(true);
                t.start();
            }

            public void closedownInitiated() {
            }

            public void closedownComplete() {
            }
        });
    }

    private void testBTMessageHandler() {
        try {
            MessageManager man = this.plugin_interface.getMessageManager();
            man.registerMessageType(new BorkMessage(""));
            man.locateCompatiblePeers(this.plugin_interface, new TestMessage(""), new MessageManagerListener(){

                public void compatiblePeerFound(Download download, final Peer peer, Message message) {
                    System.out.println("Compatible peer found: " + peer.getIp());
                    peer.getConnection().getIncomingMessageQueue().registerPriorityListener(new IncomingMessageQueueListener(){

                        public boolean messageReceived(Message message) {
                            System.out.println(peer.getIp() + ": " + message.getDescription() + " (" + message + ")");
                            if (message instanceof BorkMessage) {
                                System.out.println("Got a borker: " + ((BorkMessage)message).getArg());
                                return true;
                            }
                            return false;
                        }

                        public void bytesReceived(int byte_count) {
                        }
                    });
                }

                public void peerRemoved(Download download, Peer peer) {
                }
            });
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void testPluginWrite() {
        this.plugin_interface.getDownloadManager().addListener(new DownloadManagerListener(){

            public void downloadAdded(Download download) {
                download.addPeerListener(new DownloadPeerListener(){

                    public void peerManagerAdded(final Download download, final PeerManager peer_manager) {
                        new AEThread2(""){

                            public void run() {
                                long chunk_size;
                                DiskManager dm = peer_manager.getDiskManager();
                                File f = new File("C:\\temp\\capture2.pcap");
                                long len = f.length();
                                int piece_size = (int)download.getTorrent().getPieceSize();
                                int max_blocks = piece_size / 16384;
                                ArrayList<long[]> chunks = new ArrayList<long[]>();
                                for (long i = 0L; i < len; i += chunk_size) {
                                    int blocks = (int)(Math.random() * (double)max_blocks) + 1;
                                    long rem_in_piece = i - i / (long)piece_size * (long)piece_size;
                                    if (rem_in_piece == 0L) {
                                        rem_in_piece = piece_size;
                                    }
                                    rem_in_piece = Math.min(len - i, rem_in_piece);
                                    chunk_size = Math.min(rem_in_piece, (long)(blocks * 16384));
                                    chunks.add(new long[]{i, chunk_size});
                                }
                                Utilities utils = Test.this.plugin_interface.getUtilities();
                                try {
                                    RandomAccessFile raf = new RandomAccessFile(f, "r");
                                    while (!chunks.isEmpty()) {
                                        long[] chunk = (long[])chunks.remove((int)(Math.random() * (double)chunks.size()));
                                        final long position = chunk[0];
                                        final int size = (int)chunk[1];
                                        raf.seek(position);
                                        byte[] buffer = new byte[size];
                                        raf.read(buffer);
                                        int piece_number = (int)(position / (long)piece_size);
                                        int piece_offset = (int)(position % (long)piece_size);
                                        dm.write(piece_number, piece_offset, utils.allocatePooledByteBuffer(buffer), new DiskManagerWriteRequestListener(){

                                            public void complete(DiskManagerWriteRequest request2) {
                                                System.out.println("write ok: offset=" + position + ",size=" + size);
                                            }

                                            public void failed(DiskManagerWriteRequest request2, DiskManagerException error) {
                                                System.out.println("write failed");
                                                error.printStackTrace();
                                            }
                                        });
                                        Thread.sleep(10L);
                                    }
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                }
                            }
                        }.start();
                    }

                    public void peerManagerRemoved(Download download, PeerManager peer_manager) {
                    }
                });
            }

            public void downloadRemoved(Download download) {
            }
        });
    }

    private void testPieceListener() {
        this.plugin_interface.getDownloadManager().addListener(new DownloadManagerListener(){

            public void downloadAdded(Download download) {
                download.addPeerListener(new DownloadPeerListener(){

                    public void peerManagerAdded(Download download, final PeerManager peer_manager) {
                        peer_manager.addListener(new PeerManagerListener2(){

                            public void eventOccurred(PeerManagerEvent event2) {
                                if (event2.getType() == 7) {
                                    Piece piece = (Piece)event2.getData();
                                    System.out.println("piece: " + piece.getIndex() + ", done=" + piece.isDone());
                                    try {
                                        peer_manager.getDiskManager().read(piece.getIndex(), 0, piece.getLength(), new DiskManagerReadRequestListener(){

                                            public void complete(DiskManagerReadRequest request2, PooledByteBuffer buffer) {
                                                System.out.println("    read ok");
                                                buffer.returnToPool();
                                            }

                                            public void failed(DiskManagerReadRequest request2, DiskManagerException error) {
                                                System.out.println("    read failed: " + Debug.getNestedExceptionMessage(error));
                                            }
                                        });
                                    }
                                    catch (Throwable e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                        });
                    }

                    public void peerManagerRemoved(Download download, PeerManager peer_manager) {
                    }
                });
            }

            public void downloadRemoved(Download download) {
            }
        });
    }

    private void testSubs() {
        try {
            Subscription[] subs;
            SubscriptionManager sm = this.plugin_interface.getUtilities().getSubscriptionManager();
            for (Subscription s : subs = sm.getSubscriptions()) {
                SubscriptionResult[] results;
                System.out.println("subs: " + s.getName());
                for (SubscriptionResult result : results = s.getResults()) {
                    System.out.println("    " + result.getProperty(1) + ", read=" + result.isRead());
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void testMessaging() {
        try {
            AzureusCoreFactory.getSingleton().getCryptoManager().addPasswordHandler(new CryptoManagerPasswordHandler(){

                public int getHandlerType() {
                    return 1;
                }

                public CryptoManagerPasswordHandler.passwordDetails getPassword(int handler_type, int action_type, boolean last_pw_incorrect, String reason) {
                    System.out.println("CryptoPassword (" + reason + ")");
                    return new CryptoManagerPasswordHandler.passwordDetails(){

                        public char[] getPassword() {
                            return "changeit".toCharArray();
                        }

                        public int getPersistForSeconds() {
                            return 0;
                        }
                    };
                }

                public void passwordOK(int handler_type, CryptoManagerPasswordHandler.passwordDetails details) {
                }
            });
            final SESecurityManager sec_man = this.plugin_interface.getUtilities().getSecurityManager();
            final SEPublicKey my_key = sec_man.getPublicKey(1, "test");
            int stream_crypto = 3;
            boolean use_sts = true;
            int block_crypto = 2;
            GenericMessageRegistration reg = this.plugin_interface.getMessageManager().registerGenericMessageType("GENTEST", "Gen test desc", 3, new GenericMessageHandler(){

                public boolean accept(GenericMessageConnection connection) throws MessageException {
                    System.out.println("accept");
                    try {
                        connection = sec_man.getSTSConnection(connection, my_key, new SEPublicKeyLocator(){

                            public boolean accept(Object context2, SEPublicKey other_key) {
                                System.out.println("acceptKey");
                                return true;
                            }
                        }, "test", 2);
                        connection.addListener(new GenericMessageConnectionListener(){

                            public void connected(GenericMessageConnection connection) {
                            }

                            public void receive(GenericMessageConnection connection, PooledByteBuffer message) throws MessageException {
                                System.out.println("receive: " + message.toByteArray().length);
                                PooledByteBuffer reply = Test.this.plugin_interface.getUtilities().allocatePooledByteBuffer(new byte[connection.getMaximumMessageSize()]);
                                connection.send(reply);
                            }

                            public void failed(GenericMessageConnection connection, Throwable error) throws MessageException {
                                System.out.println("Responder connection error:");
                                error.printStackTrace();
                            }
                        });
                    }
                    catch (Throwable e) {
                        connection.close();
                        e.printStackTrace();
                    }
                    return true;
                }
            });
            InetSocketAddress tcp_target = new InetSocketAddress("127.0.0.1", 6889);
            InetSocketAddress udp_target = new InetSocketAddress("212.159.18.92", 6881);
            GenericMessageEndpoint endpoint = reg.createEndpoint(tcp_target);
            endpoint.addTCP(tcp_target);
            endpoint.addUDP(udp_target);
            while (true) {
                try {
                    block7: while (true) {
                        int i = 0;
                        while (true) {
                            if (i >= 1000) continue block7;
                            System.out.println("Test: initiating connection");
                            final AESemaphore sem = new AESemaphore("wait!");
                            GenericMessageConnection con = reg.createConnection(endpoint);
                            con = sec_man.getSTSConnection(con, my_key, new SEPublicKeyLocator(){

                                public boolean accept(Object context2, SEPublicKey other_key) {
                                    System.out.println("acceptKey");
                                    return true;
                                }
                            }, "test", 2);
                            con.addListener(new GenericMessageConnectionListener(){

                                public void connected(GenericMessageConnection connection) {
                                    System.out.println("connected");
                                    PooledByteBuffer data = Test.this.plugin_interface.getUtilities().allocatePooledByteBuffer("1234".getBytes());
                                    try {
                                        connection.send(data);
                                    }
                                    catch (Throwable e) {
                                        e.printStackTrace();
                                    }
                                }

                                public void receive(GenericMessageConnection connection, PooledByteBuffer message) throws MessageException {
                                    System.out.println("receive: " + message.toByteArray().length);
                                    try {
                                        Thread.sleep(30000L);
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                    System.out.println("closing connection");
                                    connection.close();
                                    sem.release();
                                }

                                public void failed(GenericMessageConnection connection, Throwable error) throws MessageException {
                                    System.out.println("Initiator connection error:");
                                    error.printStackTrace();
                                    sem.release();
                                }
                            });
                            con.connect();
                            sem.reserve();
                            Thread.sleep(1000L);
                            ++i;
                        }
                        break;
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    try {
                        System.out.println("Sleeping before retrying");
                        Thread.sleep(30000L);
                    }
                    catch (Throwable f) {}
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            return;
        }
    }

    private void testSearch() {
        while (true) {
            try {
                SearchInitiator si;
                SearchProvider[] providers;
                do {
                    Thread.sleep(1000L);
                    si = this.plugin_interface.getUtilities().getSearchInitiator();
                    providers = si.getProviders();
                    System.out.println("search providers=" + providers.length);
                } while (providers.length <= 0);
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("search_term", "monkey");
                properties.put("mature", "true");
                Search s = si.createSearch(providers, properties, null);
                while (!s.isComplete()) {
                    Thread.sleep(1000L);
                    SearchProviderResults[] results = s.getResults();
                    if (results.length <= 0) continue;
                    System.out.println("Got results: " + results.length);
                    for (SearchProviderResults result : results) {
                        SearchResult[] srs;
                        System.out.println("    " + result.getProvider().getProperty(1) + ": comp=" + result.isComplete() + ", error=" + result.getError());
                        for (SearchResult sr : srs = result.getResults()) {
                            System.out.println("        " + sr.getProperty(1));
                        }
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void testLinks() {
        this.plugin_interface.getDownloadManager().addListener(new DownloadManagerListener(){

            public void downloadAdded(Download download) {
                DiskManagerFileInfo[] info = download.getDiskManagerFileInfo();
                for (int i = 0; i < info.length; ++i) {
                    info[i].setLink(new File("C:\\temp"));
                }
            }

            public void downloadRemoved(Download download) {
            }
        });
    }

    private void testDDB() {
        try {
            DistributedDatabase db = this.plugin_interface.getDistributedDatabase();
            DistributedDatabaseKey key = db.createKey(new byte[]{4, 7, 1, 2, 5, 8});
            boolean do_write = false;
            if (do_write) {
                DistributedDatabaseValue[] values = new DistributedDatabaseValue[500];
                for (int i = 0; i < values.length; ++i) {
                    byte[] val = new byte[20];
                    Arrays.fill(val, (byte)i);
                    values[i] = db.createValue(val);
                }
                db.write(new DistributedDatabaseListener(){

                    public void event(DistributedDatabaseEvent event2) {
                        System.out.println("Event:" + event2.getType());
                        if (event2.getType() == 1) {
                            try {
                                System.out.println("    write - key = " + ByteFormatter.encodeString((byte[])event2.getKey().getKey()) + ", val = " + ByteFormatter.encodeString((byte[])event2.getValue().getValue(byte[].class)));
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }, key, values);
            } else {
                db.read(new DistributedDatabaseListener(){

                    public void event(DistributedDatabaseEvent event2) {
                        System.out.println("Event:" + event2.getType());
                        if (event2.getType() == 2) {
                            try {
                                System.out.println("    read - key = " + ByteFormatter.encodeString((byte[])event2.getKey().getKey()) + ", val = " + ByteFormatter.encodeString((byte[])event2.getValue().getValue(byte[].class)));
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }, key, 60000L);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void taTest() {
        try {
            final TorrentAttribute ta = this.plugin_interface.getTorrentManager().getAttribute("Category");
            ta.addTorrentAttributeListener(new TorrentAttributeListener(){

                public void event(TorrentAttributeEvent ev) {
                    System.out.println("ev: " + ev.getType() + ", " + ev.getData());
                    if (ev.getType() == 1 && "plop".equals(ev.getData())) {
                        ta.removeDefinedValue("plop");
                    }
                }
            });
            ta.addDefinedValue("wibble");
            this.plugin_interface.getDownloadManager().addListener(new DownloadManagerListener(){

                public void downloadAdded(Download download) {
                    try {
                        download.setAttribute(ta, "wibble");
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }

                public void downloadRemoved(Download download) {
                }
            });
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        System.setProperty("azureus.dynamic.plugins", "org.gudy.azureus2.pluginsimpl.local.test.Test");
        Main.main(args);
    }

    private class BorkMessage
    implements Message {
        private ByteBuffer buffer;
        private String arg;

        private BorkMessage(String _arg) {
            this.arg = _arg;
            try {
                byte[] arg_bytes = this.arg.getBytes("UTF-8");
                this.buffer = ByteBuffer.allocate(4 + arg_bytes.length);
                this.buffer.putInt(arg_bytes.length);
                this.buffer.put(arg_bytes);
                this.buffer.flip();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        public String getID() {
            return "BORK_MESSAGE";
        }

        public int getType() {
            return 0;
        }

        public String getDescription() {
            return "borker message";
        }

        public ByteBuffer[] getPayload() {
            return new ByteBuffer[]{this.buffer};
        }

        public String getArg() {
            return this.arg;
        }

        public Message create(ByteBuffer data) throws MessageException {
            try {
                int size = data.getInt();
                byte[] bytes = new byte[size];
                data.get(bytes);
                return new BorkMessage(new String(bytes, "UTF-8"));
            }
            catch (Throwable e) {
                throw new MessageException("create failed", e);
            }
        }

        public void destroy() {
        }
    }

    private class TestMessage
    implements Message {
        private ByteBuffer buffer;
        private String arg;

        private TestMessage(String _arg) {
            this.arg = _arg;
            try {
                byte[] arg_bytes = this.arg.getBytes("UTF-8");
                this.buffer = ByteBuffer.allocate(4 + arg_bytes.length);
                this.buffer.putInt(arg_bytes.length);
                this.buffer.put(arg_bytes);
                this.buffer.flip();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        public String getID() {
            return "BT_REQUEST";
        }

        public int getType() {
            return 0;
        }

        public String getDescription() {
            return "borker message";
        }

        public ByteBuffer[] getPayload() {
            return new ByteBuffer[]{this.buffer};
        }

        public String getArg() {
            return this.arg;
        }

        public Message create(ByteBuffer data) throws MessageException {
            try {
                int size = data.getInt();
                byte[] bytes = new byte[size];
                data.get(bytes);
                return new BorkMessage(new String(bytes, "UTF-8"));
            }
            catch (Throwable e) {
                throw new MessageException("create failed", e);
            }
        }

        public void destroy() {
        }
    }
}

