/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.launch;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.launcher.Launcher;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.plugins.LaunchablePlugin;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;
import org.gudy.azureus2.pluginsimpl.PluginUtils;
import org.gudy.azureus2.pluginsimpl.local.launch.PluginSingleInstanceHandler;

public class PluginLauncherImpl {
    private static Map preloaded_plugins = new HashMap();

    private static void main(String[] args) {
        PluginLauncherImpl.launch(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void launch(String[] args) {
        if (Launcher.checkAndLaunch(PluginLauncherImpl.class, args)) {
            return;
        }
        COConfigurationManager.preInitialise();
        final LoggerChannelListener listener = new LoggerChannelListener(){

            public void messageLogged(int type, String content) {
                this.log(content, false);
            }

            public void messageLogged(String str, Throwable error) {
                this.log(str, true);
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                error.printStackTrace(pw);
                pw.flush();
                this.log(sw.toString(), true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected synchronized void log(String str, boolean stdout) {
                File log_file = PluginLauncherImpl.getApplicationFile("launch.log");
                PrintWriter pw = null;
                try {
                    block10: {
                        try {
                            pw = new PrintWriter(new FileWriter(log_file, true));
                            if (str.endsWith("\n")) {
                                if (stdout) {
                                    System.err.print("PluginLauncher: " + str);
                                }
                                pw.print(str);
                                break block10;
                            }
                            if (stdout) {
                                System.err.println("PluginLauncher: " + str);
                            }
                            pw.println(str);
                        }
                        catch (Throwable e) {
                            Object var7_6 = null;
                            if (pw != null) {
                                pw.close();
                            }
                        }
                    }
                    Object var7_5 = null;
                    if (pw != null) {
                        pw.close();
                    }
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (pw != null) {
                        pw.close();
                    }
                    throw throwable;
                }
            }
        };
        LaunchablePlugin[] launchables = PluginLauncherImpl.findLaunchablePlugins(listener);
        if (launchables.length == 0) {
            listener.messageLogged(3, "No launchable plugins found");
            return;
        }
        if (launchables.length > 1) {
            listener.messageLogged(3, "Multiple launchable plugins found, running first");
        }
        try {
            SystemProperties.setApplicationEntryPoint("org.gudy.azureus2.plugins.PluginLauncher");
            launchables[0].setDefaults(args);
            if (PluginSingleInstanceHandler.process(listener, args)) {
                return;
            }
            Thread core_thread = new Thread("PluginLauncher"){

                public void run() {
                    try {
                        Thread.sleep(500L);
                        AzureusCore azureus_core = AzureusCoreFactory.create();
                        azureus_core.start();
                    }
                    catch (Throwable e) {
                        listener.messageLogged("PluginLauncher: launch fails", e);
                    }
                }
            };
            core_thread.setDaemon(true);
            core_thread.start();
            boolean restart = false;
            boolean process_succeeded = false;
            try {
                restart = launchables[0].process();
                process_succeeded = true;
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                block17: {
                    Object var7_8 = null;
                    try {
                        if (restart) {
                            AzureusCoreFactory.getSingleton().restart();
                        } else {
                            AzureusCoreFactory.getSingleton().stop();
                        }
                    }
                    catch (Throwable e) {
                        if (!process_succeeded) break block17;
                        throw e;
                    }
                }
                throw throwable;
            }
            try {
                if (restart) {
                    AzureusCoreFactory.getSingleton().restart();
                } else {
                    AzureusCoreFactory.getSingleton().stop();
                }
            }
            catch (Throwable e) {
                if (process_succeeded) {
                    throw e;
                }
            }
        }
        catch (Throwable e) {
            listener.messageLogged("PluginLauncher: launch fails", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static LaunchablePlugin[] findLaunchablePlugins(LoggerChannelListener listener) {
        ArrayList<Plugin> res = new ArrayList<Plugin>();
        File app_dir = PluginLauncherImpl.getApplicationFile("plugins");
        if (!app_dir.exists() && app_dir.isDirectory()) {
            listener.messageLogged(3, "Application dir '" + app_dir + "' not found");
            return new LaunchablePlugin[0];
        }
        File[] plugins = app_dir.listFiles();
        if (plugins == null || plugins.length == 0) {
            listener.messageLogged(3, "Application dir '" + app_dir + "' empty");
            return new LaunchablePlugin[0];
        }
        int i = 0;
        while (true) {
            block15: {
                if (i >= plugins.length) {
                    LaunchablePlugin[] x = new LaunchablePlugin[res.size()];
                    res.toArray(x);
                    return x;
                }
                File plugin_dir = plugins[i];
                if (plugin_dir.isDirectory()) {
                    try {
                        Class<?> c;
                        Plugin plugin;
                        String plugin_class;
                        Properties props;
                        ClassLoader classLoader;
                        block16: {
                            URLClassLoader current;
                            URL url;
                            ClassLoader root_cl = classLoader = PluginLauncherImpl.class.getClassLoader();
                            File[] contents = plugin_dir.listFiles();
                            if (contents == null || contents.length == 0) break block15;
                            String[] plugin_version = new String[]{null};
                            String[] plugin_id = new String[]{null};
                            contents = PluginLauncherImpl.getHighestJarVersions(contents, plugin_version, plugin_id, true);
                            for (int j = 0; j < contents.length; ++j) {
                                classLoader = PluginLauncherImpl.addFileToClassPath(root_cl, classLoader, contents[j]);
                            }
                            props = new Properties();
                            File properties_file = new File(plugin_dir, "plugin.properties");
                            if (properties_file.exists()) {
                                Object var15_19;
                                FileInputStream fis = null;
                                try {
                                    fis = new FileInputStream(properties_file);
                                    props.load(fis);
                                    var15_19 = null;
                                    if (fis == null) break block16;
                                }
                                catch (Throwable throwable) {
                                    var15_19 = null;
                                    if (fis != null) {
                                        fis.close();
                                    }
                                    throw throwable;
                                }
                                fis.close();
                            } else if (classLoader instanceof URLClassLoader && (url = (current = (URLClassLoader)classLoader).findResource("plugin.properties")) != null) {
                                props.load(url.openStream());
                            }
                        }
                        if ((plugin_class = (String)props.get("plugin.class")) != null && plugin_class.indexOf(59) == -1 && (plugin = (Plugin)(c = classLoader.loadClass(plugin_class)).newInstance()) instanceof LaunchablePlugin) {
                            preloaded_plugins.put(plugin_class, plugin);
                            res.add(plugin);
                        }
                    }
                    catch (Throwable e) {
                        listener.messageLogged("Load of plugin in '" + plugin_dir + "' fails", e);
                    }
                }
            }
            ++i;
        }
    }

    public static Plugin getPreloadedPlugin(String cla) {
        return (Plugin)preloaded_plugins.get(cla);
    }

    private static File getApplicationFile(String filename) {
        String path = SystemProperties.getApplicationPath();
        if (Constants.isOSX) {
            path = path + "/" + SystemProperties.getApplicationName() + ".app/Contents/";
        }
        return new File(path, filename);
    }

    public static File[] getHighestJarVersions(File[] files, String[] version_out, String[] id_out, boolean discard_non_versioned_when_versioned_found) {
        ArrayList<File> res = new ArrayList<File>();
        HashMap<String, String> version_map = new HashMap<String, String>();
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            String name = f.getName().toLowerCase();
            if (!name.endsWith(".jar")) continue;
            int cvs_pos = name.lastIndexOf("_cvs");
            int sep_pos = cvs_pos <= 0 ? name.lastIndexOf("_") : name.lastIndexOf("_", cvs_pos - 1);
            if (sep_pos == -1 || sep_pos == name.length() - 1 || !Character.isDigit(name.charAt(sep_pos + 1))) {
                res.add(f);
                continue;
            }
            String prefix = name.substring(0, sep_pos);
            String version = name.substring(sep_pos + 1, cvs_pos <= 0 ? name.length() - 4 : cvs_pos);
            String prev_version = (String)version_map.get(prefix);
            if (prev_version == null) {
                version_map.put(prefix, version);
                continue;
            }
            if (PluginUtils.comparePluginVersions(prev_version, version) >= 0) continue;
            version_map.put(prefix, version);
        }
        if (version_map.size() > 0 && discard_non_versioned_when_versioned_found) {
            res.clear();
        }
        if (version_map.containsKey("azrating")) {
            version_map.remove("rating");
        }
        block1: for (String prefix : version_map.keySet()) {
            String version = (String)version_map.get(prefix);
            String target = prefix + "_" + version;
            version_out[0] = version;
            id_out[0] = prefix;
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                String lc_name = f.getName().toLowerCase();
                if (!lc_name.equals(target + ".jar") && !lc_name.equals(target + "_cvs.jar")) continue;
                res.add(f);
                continue block1;
            }
        }
        File[] res_array = new File[res.size()];
        res.toArray(res_array);
        return res_array;
    }

    public static ClassLoader addFileToClassPath(ClassLoader root, ClassLoader classLoader, File f) {
        if (f.exists() && !f.isDirectory() && f.getName().endsWith(".jar")) {
            try {
                classLoader = PluginLauncherImpl.extendClassLoader(root, classLoader, f.toURL());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return classLoader;
    }

    public static ClassLoader extendClassLoader(ClassLoader root, ClassLoader classLoader, URL url) {
        if (classLoader instanceof URLClassLoader) {
            URL[] old = ((URLClassLoader)classLoader).getURLs();
            URL[] new_urls = new URL[old.length + 1];
            System.arraycopy(old, 0, new_urls, 1, old.length);
            new_urls[0] = url;
            classLoader = new URLClassLoader(new_urls, classLoader == root ? classLoader : classLoader.getParent());
        } else {
            classLoader = new URLClassLoader(new URL[]{url}, classLoader);
        }
        return classLoader;
    }
}

