/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.disk;

import java.io.File;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.disk.DiskManagerChannel;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.pluginsimpl.local.disk.DiskManagerChannelImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl;

public class DiskManagerFileInfoImpl
implements DiskManagerFileInfo {
    protected DownloadImpl download;
    protected org.gudy.azureus2.core3.disk.DiskManagerFileInfo core;

    public DiskManagerFileInfoImpl(DownloadImpl _download, org.gudy.azureus2.core3.disk.DiskManagerFileInfo coreFileInfo) {
        this.core = coreFileInfo;
        this.download = _download;
    }

    public void setPriority(boolean b) {
        this.core.setPriority(b ? 1 : 0);
    }

    public void setSkipped(boolean b) {
        this.core.setSkipped(b);
    }

    public int getNumericPriorty() {
        return this.core.getPriority();
    }

    public void setNumericPriority(int priority) {
        this.core.setPriority(priority);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setDeleted(boolean b) {
        int target_st;
        int st = this.core.getStorageType();
        if (b) {
            if (st == 1) {
                target_st = 2;
            } else {
                if (st != 3) return;
                target_st = 4;
            }
        } else if (st == 2) {
            target_st = 1;
        } else {
            if (st != 4) return;
            target_st = 3;
        }
        this.core.setStorageType(target_st);
    }

    public boolean isDeleted() {
        int st = this.core.getStorageType();
        return st == 2 || st == 4;
    }

    public void setLink(File link_destination) {
        this.core.setLink(link_destination);
    }

    public File getLink() {
        return this.core.getLink();
    }

    public int getAccessMode() {
        return this.core.getAccessMode();
    }

    public long getDownloaded() {
        return this.core.getDownloaded();
    }

    public long getLength() {
        return this.core.getLength();
    }

    public File getFile() {
        return this.core.getFile(false);
    }

    public File getFile(boolean follow_link) {
        return this.core.getFile(follow_link);
    }

    public int getFirstPieceNumber() {
        return this.core.getFirstPieceNumber();
    }

    public long getPieceSize() {
        try {
            return this.getDownload().getTorrent().getPieceSize();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return 0L;
        }
    }

    public int getNumPieces() {
        return this.core.getNbPieces();
    }

    public boolean isPriority() {
        return this.core.getPriority() > 0;
    }

    public boolean isSkipped() {
        return this.core.isSkipped();
    }

    public int getIndex() {
        return this.core.getIndex();
    }

    public byte[] getDownloadHash() throws DownloadException {
        return this.getDownload().getTorrent().getHash();
    }

    public Download getDownload() throws DownloadException {
        if (this.download != null) {
            return this.download;
        }
        return DownloadManagerImpl.getDownloadStatic(this.core.getDownloadManager());
    }

    public DiskManagerChannel createChannel() throws DownloadException {
        return new DiskManagerChannelImpl(this.download, this);
    }

    public org.gudy.azureus2.core3.disk.DiskManagerFileInfo getCore() {
        return this.core;
    }
}

