/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util.test;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.SHA1;
import org.gudy.azureus2.core3.util.test.SHA1Old;

public class SHA1SpeedTest {
    private static final int BUFF_MAX_SIZE = 0x400000;
    private static final int[] LOOPS = new int[]{1000000, 30000, 15000, 4000, 3000, 2000, 1200, 800};
    private static final int[] TESTS = new int[]{1, 16, 64, 256, 512, 1024, 2048, 4096};
    private static final int TEST_SPEED_FACTOR = 1;

    public static void main(String[] args) {
        Random rnd = new Random();
        SHA1Old oldsha = new SHA1Old();
        SHA1 newsha = new SHA1();
        ByteBuffer dBuffer = ByteBuffer.allocateDirect(0x400000);
        ByteBuffer hBuffer = ByteBuffer.allocate(0x400000);
        for (int i = 0; i < 0x400000; ++i) {
            byte b = (byte)(rnd.nextInt() & 0xFF);
            dBuffer.put(b);
        }
        dBuffer.rewind();
        hBuffer.put(dBuffer);
        hBuffer.rewind();
        dBuffer.rewind();
        try {
            System.out.println("Setting high thread priority to decrease test jitter");
            Thread.currentThread().setPriority(10);
            Thread.sleep(2000L);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        for (int t = 0; t < TESTS.length; ++t) {
            int i;
            int buffsize = TESTS[t] * 1024;
            dBuffer.position(0);
            dBuffer.limit(buffsize);
            hBuffer.position(0);
            hBuffer.limit(buffsize);
            int loops = LOOPS[t] / 1;
            String info = " [" + buffsize / 1024 + "KB, " + loops + "x] = ";
            double totalMBytes = (double)buffsize / 1048576.0 * (double)loops;
            System.out.println("direct:");
            System.out.print("Old SHA1");
            long time = System.currentTimeMillis();
            for (i = 0; i < loops; ++i) {
                oldsha.reset();
                oldsha.digest(dBuffer);
            }
            time = System.currentTimeMillis() - time;
            double speed = totalMBytes / ((double)time / 1024.0);
            System.out.println(info + time + " ms @ " + speed + " MiB/s");
            System.out.print("New SHA1 ");
            time = System.currentTimeMillis();
            for (i = 0; i < loops; ++i) {
                newsha.reset();
                newsha.digest(dBuffer);
            }
            time = System.currentTimeMillis() - time;
            speed = totalMBytes / ((double)time / 1024.0);
            System.out.println(info + time + " ms @ " + speed + " MiB/s");
            System.out.println("heap:");
            System.out.print("Old SHA1");
            time = System.currentTimeMillis();
            for (i = 0; i < loops; ++i) {
                oldsha.reset();
                oldsha.digest(hBuffer);
            }
            time = System.currentTimeMillis() - time;
            speed = totalMBytes / ((double)time / 1024.0);
            System.out.println(info + time + " ms @ " + speed + " MiB/s");
            System.out.print("New SHA1 ");
            time = System.currentTimeMillis();
            for (i = 0; i < loops; ++i) {
                newsha.reset();
                newsha.digest(hBuffer);
            }
            time = System.currentTimeMillis() - time;
            speed = totalMBytes / ((double)time / 1024.0);
            System.out.println(info + time + " ms @ " + speed + " MiB/s");
            System.out.println();
        }
        System.out.println("performing randomized buffer windowing checks, this may take a while");
        for (int i = 0; i < LOOPS[1] / 1; ++i) {
            int size = rnd.nextInt(0x400000);
            int offset = rnd.nextInt(0x400000 - size - 1);
            hBuffer.limit(offset + size);
            hBuffer.position(offset);
            dBuffer.limit(offset + size);
            dBuffer.position(offset);
            oldsha.reset();
            newsha.reset();
            byte[] oldh = oldsha.digest(hBuffer);
            byte[] newh = newsha.digest(hBuffer);
            oldsha.reset();
            newsha.reset();
            byte[] oldd = oldsha.digest(dBuffer);
            byte[] newd = newsha.digest(dBuffer);
            if (!(Arrays.equals(oldh, newh) && Arrays.equals(oldd, newd) && Arrays.equals(oldd, oldh))) {
                System.out.println("hash mismatch at offset: " + offset + " size: " + size);
                System.out.println("\t\t" + ByteFormatter.nicePrint(oldh));
                System.out.println("\t\t" + ByteFormatter.nicePrint(newh));
                System.out.println("\t\t" + ByteFormatter.nicePrint(oldd));
                System.out.println("\t\t" + ByteFormatter.nicePrint(newd));
            }
            if (hBuffer.limit() != offset + size || dBuffer.limit() != offset + size || hBuffer.position() != offset || dBuffer.position() != offset) {
                System.out.println("buffer does not match its original state");
            }
            ByteBuffer dview = dBuffer.slice();
            ByteBuffer hview = hBuffer.slice();
            oldsha.reset();
            newsha.reset();
            oldh = oldsha.digest(hview);
            newh = newsha.digest(hview);
            oldsha.reset();
            newsha.reset();
            oldd = oldsha.digest(dview);
            newd = newsha.digest(dview);
            if (!(Arrays.equals(oldh, newh) && Arrays.equals(oldd, newd) && Arrays.equals(oldd, oldh))) {
                System.out.println("(view) hash mismatch at offset: " + offset + " size: " + size);
                System.out.println("\t\t" + ByteFormatter.nicePrint(oldh));
                System.out.println("\t\t" + ByteFormatter.nicePrint(newh));
                System.out.println("\t\t" + ByteFormatter.nicePrint(oldd));
                System.out.println("\t\t" + ByteFormatter.nicePrint(newd));
            }
            if (hview.limit() == hview.capacity() && dview.limit() == dview.capacity() && hview.position() == 0 && dview.position() == 0) continue;
            System.out.println("view buffer does not match its original state");
        }
        System.out.println("DONE");
    }
}

