/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.torrentdownloader;

import java.io.File;
import java.util.Map;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloader;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloaderCallBackInterface;
import org.gudy.azureus2.core3.torrentdownloader.impl.TorrentDownloaderImpl;
import org.gudy.azureus2.core3.torrentdownloader.impl.TorrentDownloaderManager;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.UrlUtils;

public class TorrentDownloaderFactory {
    private static TorrentDownloaderImpl getClass(boolean logged) {
        try {
            return (TorrentDownloaderImpl)Class.forName("org.gudy.azureus2.core3.torrentdownloader.impl.TorrentDownloader" + (logged ? "Logged" : "") + "Impl").newInstance();
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    public static TorrentDownloader create(TorrentDownloaderCallBackInterface callback, String url, String referrer, String fileordir, boolean logged) {
        return TorrentDownloaderFactory.create(callback, url, referrer, null, fileordir, logged);
    }

    public static TorrentDownloader create(TorrentDownloaderCallBackInterface callback, String url, String referrer, String fileordir) {
        return TorrentDownloaderFactory.create(callback, url, referrer, fileordir, false);
    }

    public static TorrentDownloader create(TorrentDownloaderCallBackInterface callback, String url, String referrer, Map request_properties, String fileordir) {
        return TorrentDownloaderFactory.create(callback, url, referrer, request_properties, fileordir, false);
    }

    private static TorrentDownloader create(TorrentDownloaderCallBackInterface callback, String url, String referrer, Map request_properties, String fileordir, boolean logged) {
        return new TorrentDownloadRetrier(callback, url, referrer, request_properties, fileordir, logged);
    }

    public static TorrentDownloader create(TorrentDownloaderCallBackInterface callback, String url, boolean logged) {
        return TorrentDownloaderFactory.create(callback, url, null, null, logged);
    }

    public static TorrentDownloader create(TorrentDownloaderCallBackInterface callback, String url) {
        return TorrentDownloaderFactory.create(callback, url, null, null, false);
    }

    public static TorrentDownloader create(String url, String fileordir, boolean logged) {
        return TorrentDownloaderFactory.create(null, url, null, fileordir, logged);
    }

    public static TorrentDownloader create(String url, String fileordir) {
        return TorrentDownloaderFactory.create(null, url, null, fileordir, false);
    }

    public static TorrentDownloader create(String url, boolean logged) {
        return TorrentDownloaderFactory.create(null, url, null, null, logged);
    }

    public static TorrentDownloader create(String url) {
        return TorrentDownloaderFactory.create(null, url, null, null, false);
    }

    public static void initManager(GlobalManager gm, boolean logged, boolean autostart, String downloaddir) {
        TorrentDownloaderManager.getInstance().init(gm, logged, autostart, downloaddir);
    }

    public static TorrentDownloader downloadManaged(String url, String fileordir, boolean logged) {
        return TorrentDownloaderManager.getInstance().download(url, fileordir, logged);
    }

    public static TorrentDownloader downloadManaged(String url, String fileordir) {
        return TorrentDownloaderManager.getInstance().download(url, fileordir);
    }

    public static TorrentDownloader downloadManaged(String url, boolean logged) {
        return TorrentDownloaderManager.getInstance().download(url, logged);
    }

    public static TorrentDownloader downloadManaged(String url) {
        return TorrentDownloaderManager.getInstance().download(url);
    }

    private static class TorrentDownloadRetrier
    implements TorrentDownloader {
        private final String url;
        private final String referrer;
        private final Map request_properties;
        private final String fileordir;
        private final boolean logged;
        private volatile TorrentDownloaderImpl delegate;
        private volatile boolean cancelled;
        private volatile boolean sdp_set;
        private volatile String sdp_path;
        private volatile String sdp_file;
        private volatile boolean dfoc_set;
        private volatile boolean dfoc;
        private volatile boolean irc_set;
        private volatile boolean irc;

        private TorrentDownloadRetrier(final TorrentDownloaderCallBackInterface _callback, String _url, String _referrer, Map _request_properties, String _fileordir, boolean _logged) {
            this.url = _url;
            this.referrer = _referrer;
            this.request_properties = _request_properties;
            this.fileordir = _fileordir;
            this.logged = _logged;
            TorrentDownloaderCallBackInterface callback = new TorrentDownloaderCallBackInterface(){
                private TorrentDownloaderCallBackInterface original_callback;
                private boolean no_retry;
                private boolean init_reported;
                private boolean start_reported;
                {
                    this.original_callback = _callback;
                    this.no_retry = this.original_callback == null;
                    this.init_reported = false;
                    this.start_reported = false;
                }

                public void TorrentDownloaderEvent(int state, TorrentDownloader _delegate) {
                    if (_delegate != TorrentDownloadRetrier.this.delegate) {
                        return;
                    }
                    if (state == 0) {
                        if (this.init_reported) {
                            return;
                        }
                        this.init_reported = true;
                    }
                    if (state == 1) {
                        if (this.start_reported) {
                            return;
                        }
                        this.start_reported = true;
                    }
                    if (TorrentDownloadRetrier.this.cancelled) {
                        this.no_retry = true;
                    }
                    if (this.no_retry) {
                        if (this.original_callback != null) {
                            this.original_callback.TorrentDownloaderEvent(state, TorrentDownloadRetrier.this);
                        }
                        return;
                    }
                    if (state == 3 || state == 5 || state == 6) {
                        if (this.original_callback != null) {
                            this.original_callback.TorrentDownloaderEvent(state, TorrentDownloadRetrier.this);
                        }
                        this.no_retry = true;
                        return;
                    }
                    if (state == 4) {
                        String lc_url = TorrentDownloadRetrier.this.url.toLowerCase().trim();
                        String retry_url = null;
                        if (lc_url.startsWith("http")) {
                            retry_url = UrlUtils.parseTextForURL(TorrentDownloadRetrier.this.url.substring(5), true);
                        }
                        if (retry_url != null) {
                            TorrentDownloadRetrier.this.delegate = TorrentDownloaderFactory.getClass(TorrentDownloadRetrier.this.logged);
                            if (TorrentDownloadRetrier.this.sdp_set) {
                                TorrentDownloadRetrier.this.delegate.setDownloadPath(TorrentDownloadRetrier.this.sdp_path, TorrentDownloadRetrier.this.sdp_file);
                            }
                            if (TorrentDownloadRetrier.this.dfoc_set) {
                                TorrentDownloadRetrier.this.delegate.setDeleteFileOnCancel(TorrentDownloadRetrier.this.dfoc);
                            }
                            if (TorrentDownloadRetrier.this.irc_set) {
                                TorrentDownloadRetrier.this.delegate.setIgnoreReponseCode(TorrentDownloadRetrier.this.irc);
                            }
                            TorrentDownloadRetrier.this.delegate.init(this, retry_url, TorrentDownloadRetrier.this.referrer, TorrentDownloadRetrier.this.request_properties, TorrentDownloadRetrier.this.fileordir);
                            this.no_retry = true;
                            TorrentDownloadRetrier.this.delegate.start();
                            return;
                        }
                        this.no_retry = true;
                    }
                    if (this.original_callback != null) {
                        this.original_callback.TorrentDownloaderEvent(state, TorrentDownloadRetrier.this);
                    }
                }
            };
            this.delegate = TorrentDownloaderFactory.getClass(this.logged);
            this.delegate.init(callback, this.url, this.referrer, this.request_properties, this.fileordir);
        }

        public void start() {
            this.delegate.start();
        }

        public void cancel() {
            this.cancelled = true;
            this.delegate.cancel();
        }

        public void setDownloadPath(String path, String file) {
            this.sdp_set = true;
            this.sdp_path = path;
            this.sdp_file = file;
            this.delegate.setDownloadPath(path, file);
        }

        public int getDownloadState() {
            return this.delegate.getDownloadState();
        }

        public File getFile() {
            return this.delegate.getFile();
        }

        public int getPercentDone() {
            return this.delegate.getPercentDone();
        }

        public int getTotalRead() {
            return this.delegate.getTotalRead();
        }

        public String getError() {
            return this.delegate.getError();
        }

        public String getStatus() {
            return this.delegate.getStatus();
        }

        public String getURL() {
            return this.delegate.getURL();
        }

        public int getLastReadCount() {
            return this.delegate.getLastReadCount();
        }

        public byte[] getLastReadBytes() {
            return this.delegate.getLastReadBytes();
        }

        public boolean getDeleteFileOnCancel() {
            return this.delegate.getDeleteFileOnCancel();
        }

        public void setDeleteFileOnCancel(boolean deleteFileOnCancel) {
            this.dfoc_set = true;
            this.dfoc = deleteFileOnCancel;
            this.delegate.setDeleteFileOnCancel(deleteFileOnCancel);
        }

        public boolean isIgnoreReponseCode() {
            return this.delegate.isIgnoreReponseCode();
        }

        public void setIgnoreReponseCode(boolean ignoreReponseCode) {
            this.irc_set = true;
            this.irc = ignoreReponseCode;
            this.delegate.setIgnoreReponseCode(ignoreReponseCode);
        }
    }
}

