/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.torrent.test;

import java.io.File;
import java.net.URL;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentCreator;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.torrent.TOTorrentProgressListener;
import org.gudy.azureus2.core3.util.Debug;

public class Main {
    static int TT_ENCODE = 1;
    static int TT_DECODE = 2;
    static int TT_CREATE = 3;

    static void usage() {
        System.err.println("Usage: encode|decode|create");
        SESecurityManager.exitVM(1);
    }

    public static void main(String[] args) {
        int test_type = 0;
        if (args.length != 1) {
            Main.usage();
        }
        if (args[0].equalsIgnoreCase("encode")) {
            test_type = TT_ENCODE;
        } else if (args[0].equalsIgnoreCase("decode")) {
            test_type = TT_DECODE;
        } else if (args[0].equalsIgnoreCase("create")) {
            test_type = TT_CREATE;
        } else {
            Main.usage();
        }
        try {
            if (test_type != TT_ENCODE) {
                if (test_type == TT_DECODE) {
                    File f = new File("c:\\temp\\az3008-broken.torrent");
                    TOTorrent torrent = TOTorrentFactory.deserialiseFromBEncodedFile(f);
                    torrent.print();
                } else if (test_type == TT_CREATE) {
                    TOTorrent t;
                    TOTorrentProgressListener list = new TOTorrentProgressListener(){

                        public void reportProgress(int p) {
                            System.out.println("" + p);
                        }

                        public void reportCurrentTask(String task_description) {
                            System.out.println("task = " + task_description);
                        }
                    };
                    boolean do_file = false;
                    boolean do_fixed = false;
                    if (do_fixed) {
                        if (do_file) {
                            TOTorrentCreator c = TOTorrentFactory.createFromFileOrDirWithFixedPieceLength(new File("c:\\temp\\test.wmf"), new URL("http://127.0.0.1:6969/announce"), 10240L);
                            c.addListener(list);
                            t = c.create();
                        } else {
                            TOTorrentCreator c = TOTorrentFactory.createFromFileOrDirWithFixedPieceLength(new File("c:\\temp\\scans"), new URL("http://127.0.0.1:6969/announce"), 262144L);
                            c.addListener(list);
                            t = c.create();
                        }
                    } else if (do_file) {
                        TOTorrentCreator c = TOTorrentFactory.createFromFileOrDirWithComputedPieceLength(new File("c:\\temp\\test.wmf"), new URL("http://127.0.0.1:6969/announce"));
                        c.addListener(list);
                        t = c.create();
                    } else {
                        TOTorrentCreator c = TOTorrentFactory.createFromFileOrDirWithComputedPieceLength(new File("c:\\temp\\qqq"), new URL("http://127.0.0.1:6969/announce"));
                        c.addListener(list);
                        t = c.create();
                        t.setCreationDate(12345L);
                        t.setComment("poo pee plop mcjock");
                    }
                    t.print();
                    t.serialiseToBEncodedFile(new File("c:\\temp\\test.torrent"));
                }
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }
}

