/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.ipchecker.natchecker;

import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamDecoder;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamEncoder;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamFactory;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessageDecoder;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessageEncoder;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class NatCheckerServer
extends AEThread {
    private static final LogIDs LOGID = LogIDs.NET;
    private static final String incoming_handshake = "NATCHECK_HANDSHAKE";
    private final InetAddress bind_ip;
    private boolean bind_ip_set;
    private final String check;
    private final boolean http_test;
    private ServerSocket server;
    private volatile boolean bContinue = true;
    private final boolean use_incoming_router;
    private NetworkManager.ByteMatcher matcher;

    public NatCheckerServer(InetAddress _bind_ip, int _port, String _check, boolean _http_test) throws Exception {
        super("Nat Checker Server");
        Object net_man;
        this.bind_ip = _bind_ip;
        this.check = _check;
        this.http_test = _http_test;
        if (this.http_test) {
            net_man = HTTPNetworkManager.getSingleton();
            this.use_incoming_router = ((HTTPNetworkManager)net_man).isHTTPListenerEnabled() ? _port == ((HTTPNetworkManager)net_man).getHTTPListeningPortNumber() : false;
            if (this.use_incoming_router && !((HTTPNetworkManager)net_man).isEffectiveBindAddress(this.bind_ip)) {
                ((HTTPNetworkManager)net_man).setExplicitBindAddress(this.bind_ip);
                this.bind_ip_set = true;
            }
        } else {
            net_man = TCPNetworkManager.getSingleton();
            this.use_incoming_router = ((TCPNetworkManager)net_man).isTCPListenerEnabled() ? _port == ((TCPNetworkManager)net_man).getTCPListeningPortNumber() : false;
            if (this.use_incoming_router) {
                if (!((TCPNetworkManager)net_man).isEffectiveBindAddress(this.bind_ip)) {
                    ((TCPNetworkManager)net_man).setExplicitBindAddress(this.bind_ip);
                    this.bind_ip_set = true;
                }
                this.matcher = new NetworkManager.ByteMatcher(){

                    public int matchThisSizeOrBigger() {
                        return this.maxSize();
                    }

                    public int maxSize() {
                        return NatCheckerServer.incoming_handshake.getBytes().length;
                    }

                    public int minSize() {
                        return this.maxSize();
                    }

                    public Object matches(TransportHelper transport, ByteBuffer to_compare, int port) {
                        int old_limit = to_compare.limit();
                        to_compare.limit(to_compare.position() + this.maxSize());
                        boolean matches = to_compare.equals(ByteBuffer.wrap(NatCheckerServer.incoming_handshake.getBytes()));
                        to_compare.limit(old_limit);
                        return matches ? "" : null;
                    }

                    public Object minMatches(TransportHelper transport, ByteBuffer to_compare, int port) {
                        return this.matches(transport, to_compare, port);
                    }

                    public byte[][] getSharedSecrets() {
                        return null;
                    }

                    public int getSpecificPort() {
                        return -1;
                    }
                };
                NetworkManager.getSingleton().requestIncomingConnectionRouting(this.matcher, new NetworkManager.RoutingListener(){

                    public void connectionRouted(NetworkConnection connection, Object routing_data) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "Incoming connection from [" + connection + "] successfully routed to NAT CHECKER"));
                        }
                        try {
                            ByteBuffer msg = NatCheckerServer.this.getMessage();
                            Transport transport = connection.getTransport();
                            long start = SystemTime.getCurrentTime();
                            while (msg.hasRemaining()) {
                                transport.write(new ByteBuffer[]{msg}, 0, 1);
                                if (!msg.hasRemaining()) continue;
                                long now = SystemTime.getCurrentTime();
                                if (now < start) {
                                    start = now;
                                } else if (now - start > 30000L) {
                                    throw new Exception("Timeout");
                                }
                                Thread.sleep(50L);
                            }
                        }
                        catch (Throwable t) {
                            Debug.out("Nat check write failed", t);
                        }
                        connection.close(null);
                    }

                    public boolean autoCryptoFallback() {
                        return true;
                    }
                }, new MessageStreamFactory(){

                    public MessageStreamEncoder createEncoder() {
                        return new AZMessageEncoder(0);
                    }

                    public MessageStreamDecoder createDecoder() {
                        return new AZMessageDecoder();
                    }
                });
            }
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "NAT tester using central routing for server socket"));
            }
        }
        if (!this.use_incoming_router) {
            try {
                this.server = new ServerSocket();
                this.server.setReuseAddress(true);
                InetSocketAddress address = this.bind_ip != null ? new InetSocketAddress(this.bind_ip, _port) : new InetSocketAddress(_port);
                this.server.bind(address);
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "NAT tester server socket bound to " + address));
                }
            }
            catch (Exception e) {
                Logger.log(new LogEvent(LOGID, "NAT tester failed to setup listener socket", e));
                throw e;
            }
        }
    }

    protected ByteBuffer getMessage() throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("check", this.check);
        byte[] map_bytes = BEncoder.encode(map);
        ByteBuffer msg = ByteBuffer.allocate(4 + map_bytes.length);
        msg.putInt(map_bytes.length);
        msg.put(map_bytes);
        msg.flip();
        return msg;
    }

    public void runSupport() {
        while (this.bContinue) {
            try {
                if (this.use_incoming_router) {
                    Thread.sleep(20L);
                    continue;
                }
                Socket sck = this.server.accept();
                sck.getOutputStream().write(this.getMessage().array());
                sck.close();
            }
            catch (Exception e) {
                this.bContinue = false;
            }
        }
    }

    public void stopIt() {
        this.bContinue = false;
        if (this.use_incoming_router) {
            if (this.http_test) {
                if (this.bind_ip_set) {
                    HTTPNetworkManager.getSingleton().clearExplicitBindAddress();
                }
            } else {
                NetworkManager.getSingleton().cancelIncomingConnectionRouting(this.matcher);
                if (this.bind_ip_set) {
                    TCPNetworkManager.getSingleton().clearExplicitBindAddress();
                }
            }
        } else if (this.server != null) {
            try {
                this.server.close();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

