/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectParser;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.asn1.ASN1TaggedObjectParser;
import org.bouncycastle.asn1.BEROctetStringParser;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.BERSequenceParser;
import org.bouncycastle.asn1.BERSetParser;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DefiniteLengthInputStream;
import org.bouncycastle.asn1.IndefiniteLengthInputStream;

public class BERTaggedObjectParser
implements ASN1TaggedObjectParser {
    private int _baseTag;
    private int _tagNumber;
    private InputStream _contentStream;
    private boolean _indefiniteLength;

    protected BERTaggedObjectParser(int baseTag, int tagNumber, InputStream contentStream) {
        this._baseTag = baseTag;
        this._tagNumber = tagNumber;
        this._contentStream = contentStream;
        this._indefiniteLength = contentStream instanceof IndefiniteLengthInputStream;
    }

    public boolean isConstructed() {
        return (this._baseTag & 0x20) != 0;
    }

    public int getTagNo() {
        return this._tagNumber;
    }

    public DEREncodable getObjectParser(int tag, boolean isExplicit) throws IOException {
        if (isExplicit) {
            return new ASN1StreamParser(this._contentStream).readObject();
        }
        switch (tag) {
            case 17: {
                if (this._indefiniteLength) {
                    return new BERSetParser(new ASN1ObjectParser(this._baseTag, this._tagNumber, this._contentStream));
                }
                return new DERSet(this.loadVector(this._contentStream)).parser();
            }
            case 16: {
                if (this._indefiniteLength) {
                    return new BERSequenceParser(new ASN1ObjectParser(this._baseTag, this._tagNumber, this._contentStream));
                }
                return new DERSequence(this.loadVector(this._contentStream)).parser();
            }
            case 4: {
                if (this._indefiniteLength || this.isConstructed()) {
                    return new BEROctetStringParser(new ASN1ObjectParser(this._baseTag, this._tagNumber, this._contentStream));
                }
                return new DEROctetString(((DefiniteLengthInputStream)this._contentStream).toByteArray()).parser();
            }
        }
        throw new RuntimeException("implicit tagging not implemented");
    }

    private ASN1EncodableVector loadVector(InputStream in) throws IOException {
        ASN1StreamParser aIn = new ASN1StreamParser(in);
        ASN1EncodableVector v = new ASN1EncodableVector();
        DEREncodable obj = aIn.readObject();
        while (obj != null) {
            v.add(obj.getDERObject());
            obj = aIn.readObject();
        }
        return v;
    }

    private ASN1EncodableVector rLoadVector(InputStream in) {
        try {
            return this.loadVector(in);
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public DERObject getDERObject() {
        if (this._indefiniteLength) {
            ASN1EncodableVector v = this.rLoadVector(this._contentStream);
            if (v.size() > 1) {
                return new BERTaggedObject(false, this._tagNumber, new BERSequence(v));
            }
            if (v.size() == 1) {
                return new BERTaggedObject(true, this._tagNumber, v.get(0));
            }
            return new BERTaggedObject(false, this._tagNumber, new BERSequence());
        }
        if (this.isConstructed()) {
            ASN1EncodableVector v = this.rLoadVector(this._contentStream);
            if (v.size() == 1) {
                return new DERTaggedObject(true, this._tagNumber, v.get(0));
            }
            return new DERTaggedObject(false, this._tagNumber, new DERSequence(v));
        }
        try {
            return new DERTaggedObject(false, this._tagNumber, new DEROctetString(((DefiniteLengthInputStream)this._contentStream).toByteArray()));
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }
}

