/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.udp.uc.impl;

import com.aelitis.azureus.core.proxy.AEProxyFactory;
import com.aelitis.net.udp.uc.PRUDPPacket;
import com.aelitis.net.udp.uc.PRUDPPacketHandler;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerException;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerStats;
import com.aelitis.net.udp.uc.PRUDPPacketReceiver;
import com.aelitis.net.udp.uc.PRUDPPrimordialHandler;
import com.aelitis.net.udp.uc.PRUDPRequestHandler;
import com.aelitis.net.udp.uc.impl.PRUDPPacketHandlerImpl;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.Socket;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HostNameToIPResolver;

public class PRUDPPacketHandlerSocks
implements PRUDPPacketHandler,
PRUDPPacketHandlerImpl.PacketTransformer {
    private static String socks_host;
    private static int socks_port;
    private static String socks_user;
    private static String socks_password;
    private final InetSocketAddress target;
    private Socket control_socket;
    private InetSocketAddress relay;
    private PRUDPPacketHandler delegate;
    private byte[] packet_out_header;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected PRUDPPacketHandlerSocks(InetSocketAddress _target) throws PRUDPPacketHandlerException {
        block27: {
            boolean ok;
            block28: {
                InetAddress relay_address;
                this.target = _target;
                ok = false;
                this.delegate = new PRUDPPacketHandlerImpl(0, null, this);
                this.control_socket = new Socket(Proxy.NO_PROXY);
                this.control_socket.connect(new InetSocketAddress(socks_host, socks_port));
                DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(this.control_socket.getOutputStream(), 256));
                DataInputStream dis = new DataInputStream(this.control_socket.getInputStream());
                dos.writeByte(5);
                dos.writeByte(2);
                dos.writeByte(0);
                dos.writeByte(2);
                dos.flush();
                dis.readByte();
                byte method = dis.readByte();
                if (method != 0 && method != 2) {
                    throw new IOException("SOCKS 5: no valid method [" + method + "]");
                }
                if (method == 2) {
                    dos.writeByte(1);
                    dos.writeByte((byte)socks_user.length());
                    dos.write(socks_user.getBytes());
                    dos.writeByte((byte)socks_password.length());
                    dos.write(socks_password.getBytes());
                    dos.flush();
                    dis.readByte();
                    byte status = dis.readByte();
                    if (status != 0) {
                        throw new IOException("SOCKS 5: authentication fails [status=" + status + "]");
                    }
                }
                String mapped_ip = this.target.isUnresolved() || this.target.getAddress() == null ? AEProxyFactory.getAddressMapper().internalise(this.target.getHostName()) : this.target.getAddress().getHostName();
                dos.writeByte(5);
                dos.writeByte(3);
                dos.writeByte(0);
                dos.writeByte(1);
                dos.write(new byte[4]);
                dos.writeShort((short)this.delegate.getPort());
                dos.flush();
                dis.readByte();
                byte reply = dis.readByte();
                if (reply != 0) {
                    throw new IOException("SOCKS 5: udp association fails [reply=" + reply + "]");
                }
                dis.readByte();
                byte atype = dis.readByte();
                if (atype == 1) {
                    byte[] bytes = new byte[4];
                    dis.readFully(bytes);
                    relay_address = InetAddress.getByAddress(bytes);
                } else if (atype == 3) {
                    byte len = dis.readByte();
                    byte[] bytes = new byte[len & 0xFF];
                    dis.readFully(bytes);
                    relay_address = InetAddress.getByName(new String(bytes));
                } else {
                    byte[] bytes = new byte[16];
                    dis.readFully(bytes);
                    relay_address = InetAddress.getByAddress(bytes);
                }
                int relay_port = dis.readByte() << 8 & 0xFF00 | dis.readByte() & 0xFF;
                if (relay_address.isAnyLocalAddress()) {
                    relay_address = this.control_socket.getInetAddress();
                }
                this.relay = new InetSocketAddress(relay_address, relay_port);
                ByteArrayOutputStream baos_temp = new ByteArrayOutputStream();
                DataOutputStream dos_temp = new DataOutputStream(baos_temp);
                dos_temp.writeByte(0);
                dos_temp.writeByte(0);
                dos_temp.writeByte(0);
                try {
                    byte[] ip_bytes = HostNameToIPResolver.syncResolve(mapped_ip).getAddress();
                    dos_temp.writeByte(ip_bytes.length == 4 ? 1 : 4);
                    dos_temp.write(ip_bytes);
                }
                catch (Throwable e) {
                    dos_temp.writeByte(3);
                    dos_temp.writeByte((byte)mapped_ip.length());
                    dos_temp.write(mapped_ip.getBytes());
                }
                dos_temp.writeShort((short)this.target.getPort());
                dos_temp.flush();
                this.packet_out_header = baos_temp.toByteArray();
                ok = true;
                Thread.sleep(1000L);
                Object var15_20 = null;
                if (ok) break block27;
                try {
                    try {
                        this.control_socket.close();
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                        Object var18_23 = null;
                        this.control_socket = null;
                        break block28;
                    }
                    Object var18_22 = null;
                    this.control_socket = null;
                }
                catch (Throwable throwable) {
                    Object var18_24 = null;
                    this.control_socket = null;
                    throw throwable;
                }
            }
            if (this.delegate != null) {
                try {
                    this.delegate.destroy();
                    Object var20_32 = null;
                    this.delegate = null;
                }
                catch (Throwable throwable) {
                    Object var20_33 = null;
                    this.delegate = null;
                    throw throwable;
                }
            }
            break block27;
            {
                catch (Throwable e) {
                    throw new PRUDPPacketHandlerException("socks setup failed: " + Debug.getNestedExceptionMessage(e), e);
                }
            }
            catch (Throwable throwable) {
                Object var15_21 = null;
                if (!ok) {
                    try {
                        try {
                            this.control_socket.close();
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                            Object var18_26 = null;
                            this.control_socket = null;
                        }
                        Object var18_25 = null;
                        this.control_socket = null;
                    }
                    catch (Throwable throwable2) {
                        Object var18_27 = null;
                        this.control_socket = null;
                        throw throwable2;
                    }
                    if (this.delegate != null) {
                        try {
                            this.delegate.destroy();
                            Object var20_34 = null;
                            this.delegate = null;
                        }
                        catch (Throwable throwable3) {
                            Object var20_35 = null;
                            this.delegate = null;
                            throw throwable3;
                        }
                    }
                }
                throw throwable;
            }
        }
    }

    public void transformSend(DatagramPacket packet) {
        byte[] data = packet.getData();
        int data_len = packet.getLength();
        byte[] new_data = new byte[data_len + this.packet_out_header.length];
        System.arraycopy(this.packet_out_header, 0, new_data, 0, this.packet_out_header.length);
        System.arraycopy(data, 0, new_data, this.packet_out_header.length, data_len);
        packet.setData(new_data);
    }

    public void transformReceive(DatagramPacket packet) {
        byte[] data = packet.getData();
        int data_len = packet.getLength();
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data, 0, data_len));
        try {
            dis.readByte();
            dis.readByte();
            dis.readByte();
            byte atype = dis.readByte();
            int encap_len = 4;
            encap_len = atype == 1 ? (encap_len += 4) : (atype == 3 ? (encap_len += 1 + (dis.readByte() & 0xFF)) : (encap_len += 16));
            byte[] new_data = new byte[data_len - (encap_len += 2)];
            System.arraycopy(data, encap_len, new_data, 0, data_len - encap_len);
            packet.setData(new_data);
        }
        catch (IOException e) {
            Debug.out(e);
        }
    }

    private void checkAddress(InetSocketAddress destination) throws PRUDPPacketHandlerException {
        if (!destination.equals(this.target)) {
            throw new PRUDPPacketHandlerException("Destination mismatch");
        }
    }

    public void sendAndReceive(PRUDPPacket request_packet, InetSocketAddress destination_address, PRUDPPacketReceiver receiver, long timeout, int priority) throws PRUDPPacketHandlerException {
        this.checkAddress(destination_address);
        this.delegate.sendAndReceive(request_packet, this.relay, receiver, timeout, priority);
    }

    public PRUDPPacket sendAndReceive(PasswordAuthentication auth, PRUDPPacket request_packet, InetSocketAddress destination_address) throws PRUDPPacketHandlerException {
        this.checkAddress(destination_address);
        return this.delegate.sendAndReceive(auth, request_packet, this.relay);
    }

    public PRUDPPacket sendAndReceive(PasswordAuthentication auth, PRUDPPacket request_packet, InetSocketAddress destination_address, long timeout_millis) throws PRUDPPacketHandlerException {
        this.checkAddress(destination_address);
        return this.delegate.sendAndReceive(auth, request_packet, this.relay, timeout_millis);
    }

    public PRUDPPacket sendAndReceive(PasswordAuthentication auth, PRUDPPacket request_packet, InetSocketAddress destination_address, long timeout_millis, int priority) throws PRUDPPacketHandlerException {
        this.checkAddress(destination_address);
        return this.delegate.sendAndReceive(auth, request_packet, this.relay, timeout_millis, priority);
    }

    public void send(PRUDPPacket request_packet, InetSocketAddress destination_address) throws PRUDPPacketHandlerException {
        this.checkAddress(destination_address);
        this.delegate.send(request_packet, this.relay);
    }

    public PRUDPRequestHandler getRequestHandler() {
        return this.delegate.getRequestHandler();
    }

    public void setRequestHandler(PRUDPRequestHandler request_handler) {
        this.delegate.setRequestHandler(request_handler);
    }

    public void primordialSend(byte[] data, InetSocketAddress target) throws PRUDPPacketHandlerException {
        throw new PRUDPPacketHandlerException("not imp");
    }

    public void addPrimordialHandler(PRUDPPrimordialHandler handler) {
    }

    public void removePrimordialHandler(PRUDPPrimordialHandler handler) {
    }

    public int getPort() {
        return this.delegate.getPort();
    }

    public void setDelays(int send_delay, int receive_delay, int queued_request_timeout) {
        this.delegate.setDelays(send_delay, receive_delay, queued_request_timeout);
    }

    public void setExplicitBindAddress(InetAddress address) {
        this.delegate.setExplicitBindAddress(address);
    }

    public PRUDPPacketHandlerStats getStats() {
        return this.delegate.getStats();
    }

    public PRUDPPacketHandler openSession(InetSocketAddress target) throws PRUDPPacketHandlerException {
        throw new PRUDPPacketHandlerException("not supported");
    }

    public void closeSession() throws PRUDPPacketHandlerException {
        if (this.control_socket != null) {
            try {
                this.control_socket.close();
                this.control_socket = null;
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        if (this.delegate != null) {
            this.delegate.destroy();
        }
    }

    public void destroy() {
        try {
            this.closeSession();
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Proxy.Host", "Proxy.Port", "Proxy.Username", "Proxy.Password"}, new ParameterListener(){

            public void parameterChanged(String parameter_name) {
                socks_host = COConfigurationManager.getStringParameter("Proxy.Host").trim();
                socks_port = Integer.parseInt(COConfigurationManager.getStringParameter("Proxy.Port").trim());
                socks_user = COConfigurationManager.getStringParameter("Proxy.Username").trim();
                socks_password = COConfigurationManager.getStringParameter("Proxy.Password").trim();
                if (socks_user.equalsIgnoreCase("<none>")) {
                    socks_user = "";
                }
            }
        });
    }
}

