/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.util;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.download.DownloadManagerEnhancer;
import com.aelitis.azureus.core.download.EnhancedDownloadManager;
import com.aelitis.azureus.core.download.StreamManager;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentV3;
import com.aelitis.azureus.util.DataSourceUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.swt.program.Program;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.utils.FeatureManager;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl;

public class PlayUtils {
    public static final boolean COMPLETE_PLAY_ONLY = true;
    public static final int fileSizeThreshold = 90;
    public static final String playableFileExtensions = ".avi .flv .flc .mp4 .divx .h264 .mkv .mov .mp2 .m4v .mp3 .aac";
    private static volatile String actualPlayableFileExtensions = ".avi .flv .flc .mp4 .divx .h264 .mkv .mov .mp2 .m4v .mp3 .aac";
    private static boolean triedLoadingEmpPluginClass = false;
    private static Method methodIsExternallyPlayable;
    private static Method methodIsExternallyPlayable2;
    private static PluginInterface piEmp;

    public static boolean prepareForPlay(DownloadManager dm) {
        EnhancedDownloadManager edm = DownloadManagerEnhancer.getSingleton().getEnhancedDownload(dm);
        if (edm != null) {
            edm.setProgressiveMode(true);
            return true;
        }
        return false;
    }

    public static boolean canProgressiveOrIsComplete(TOTorrent torrent) {
        if (torrent == null) {
            return false;
        }
        try {
            DownloadManagerEnhancer enhancer = DownloadManagerEnhancer.getSingleton();
            EnhancedDownloadManager edm = DownloadManagerEnhancer.getSingleton().getEnhancedDownload(torrent.getHash());
            if (edm == null) {
                return enhancer.isProgressiveAvailable() && PlatformTorrentUtils.isContentProgressive(torrent);
            }
            boolean complete = edm.getDownloadManager().isDownloadComplete(false);
            if (complete) {
                return true;
            }
            if (!edm.supportsProgressiveMode()) {
                return false;
            }
        }
        catch (TOTorrentException e) {
            return false;
        }
        return true;
    }

    public static boolean canUseEMP(DiskManagerFileInfo file) {
        return PlayUtils.isExternallyPlayable(file);
    }

    public static boolean canUseEMP(TOTorrent torrent, int file_index) {
        return PlayUtils.canUseEMP(torrent, file_index, true);
    }

    public static boolean canUseEMP(TOTorrent torrent, int file_index, boolean complete_only) {
        if (torrent == null) {
            return false;
        }
        if (PlayUtils.canPlayViaExternalEMP(torrent, file_index, complete_only)) {
            return true;
        }
        if (!PlatformTorrentUtils.useEMP(torrent) || !PlatformTorrentUtils.embeddedPlayerAvail()) {
            return false;
        }
        return PlayUtils.canProgressiveOrIsComplete(torrent);
    }

    private static boolean canPlay(DownloadManager dm, int file_index) {
        if (dm == null) {
            return false;
        }
        TOTorrent torrent = dm.getTorrent();
        return PlayUtils.canUseEMP(torrent, file_index);
    }

    private static boolean canPlay(TOTorrent torrent, int file_index) {
        if (!PlatformTorrentUtils.isContent(torrent, false)) {
            return false;
        }
        if (!AzureusCoreFactory.isCoreRunning()) {
            return false;
        }
        GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
        DownloadManager dm = gm.getDownloadManager(torrent);
        if (dm != null) {
            return dm.getAssumedComplete() || PlayUtils.canUseEMP(torrent, file_index);
        }
        return PlayUtils.canUseEMP(torrent, file_index);
    }

    public static boolean canPlayDS(Object ds, int file_index) {
        if (!Constants.isWindows && !Constants.isOSX) {
            return false;
        }
        if (ds == null) {
            return false;
        }
        if (ds instanceof org.gudy.azureus2.core3.disk.DiskManagerFileInfo) {
            org.gudy.azureus2.core3.disk.DiskManagerFileInfo fi = (org.gudy.azureus2.core3.disk.DiskManagerFileInfo)ds;
            return PlayUtils.canPlayDS(fi.getDownloadManager(), fi.getIndex());
        }
        DownloadManager dm = DataSourceUtils.getDM(ds);
        if (dm != null) {
            return PlayUtils.canPlay(dm, file_index);
        }
        TOTorrent torrent = DataSourceUtils.getTorrent(ds);
        if (torrent != null) {
            return PlayUtils.canPlay(torrent, file_index);
        }
        if (ds instanceof VuzeActivitiesEntry) {
            return ((VuzeActivitiesEntry)ds).isPlayable();
        }
        if (ds instanceof SelectedContentV3) {
            SelectedContentV3 sel = (SelectedContentV3)ds;
            return sel.canPlay();
        }
        return false;
    }

    public static boolean isStreamPermitted() {
        FeatureManager fm = PluginInitializer.getDefaultInterface().getUtilities().getFeatureManager();
        return fm.isFeatureInstalled("core");
    }

    private static boolean canStream(DownloadManager dm, int file_index) {
        org.gudy.azureus2.core3.disk.DiskManagerFileInfo file;
        if (dm == null) {
            return false;
        }
        if (file_index == -1) {
            EnhancedDownloadManager edm = DownloadManagerEnhancer.getSingleton().getEnhancedDownload(dm);
            if (edm == null) {
                return false;
            }
            file = edm.getPrimaryFile();
            file_index = file.getIndex();
        } else {
            file = dm.getDiskManagerFileInfoSet().getFiles()[file_index];
        }
        if (file.getDownloaded() == file.getLength()) {
            return false;
        }
        if (!StreamManager.getSingleton().isStreamingUsable()) {
            return false;
        }
        TOTorrent torrent = dm.getTorrent();
        return PlayUtils.canUseEMP(torrent, file_index, false);
    }

    public static boolean canStreamDS(Object ds, int file_index) {
        if (!Constants.isWindows && !Constants.isOSX) {
            return false;
        }
        if (ds == null) {
            return false;
        }
        if (ds instanceof org.gudy.azureus2.core3.disk.DiskManagerFileInfo) {
            org.gudy.azureus2.core3.disk.DiskManagerFileInfo fi = (org.gudy.azureus2.core3.disk.DiskManagerFileInfo)ds;
            return PlayUtils.canStreamDS(fi.getDownloadManager(), fi.getIndex());
        }
        DownloadManager dm = DataSourceUtils.getDM(ds);
        if (dm != null) {
            return PlayUtils.canStream(dm, file_index);
        }
        return false;
    }

    public static String getContentUrl(DownloadManager dmContent) {
        String contentPath;
        if (dmContent.isDownloadComplete(false)) {
            EnhancedDownloadManager edm = DownloadManagerEnhancer.getSingleton().getEnhancedDownload(dmContent);
            File file = edm != null ? edm.getPrimaryFile().getFile(true) : new File(dmContent.getDownloadState().getPrimaryFile());
            try {
                contentPath = file.toURL().toString();
            }
            catch (MalformedURLException e) {
                contentPath = file.getAbsolutePath();
            }
        } else {
            contentPath = PlayUtils.getMediaServerContentURL(dmContent);
        }
        return contentPath;
    }

    public static String getMediaServerContentURL(DownloadManager dm) {
        try {
            return PlayUtils.getMediaServerContentURL(DownloadManagerImpl.getDownloadStatic(dm));
        }
        catch (DownloadException downloadException) {
            return null;
        }
    }

    public static String getMediaServerContentURL(Download dl) {
        PluginManager pm = AzureusCoreFactory.getSingleton().getPluginManager();
        PluginInterface pi = pm.getPluginInterfaceByID("azupnpav", false);
        if (pi == null) {
            Logger.log(new LogEvent(LogIDs.UI3, "Media server plugin not found"));
            return null;
        }
        if (!pi.getPluginState().isOperational()) {
            Logger.log(new LogEvent(LogIDs.UI3, "Media server plugin not operational"));
            return null;
        }
        try {
            Program program = Program.findProgram(".qtl");
            boolean hasQuickTime = program == null ? false : program.getName().toLowerCase().indexOf("quicktime") != -1;
            pi.getIPC().invoke("setQuickTimeAvailable", new Object[]{new Boolean(hasQuickTime)});
            Object url = pi.getIPC().invoke("getContentURL", new Object[]{dl});
            if (url instanceof String) {
                return (String)url;
            }
        }
        catch (Throwable e) {
            Logger.log(new LogEvent(LogIDs.UI3, 1, "IPC to media server plugin failed", e));
        }
        return null;
    }

    public static URL getMediaServerContentURL(DiskManagerFileInfo file) {
        PluginManager pm = AzureusCoreFactory.getSingleton().getPluginManager();
        PluginInterface pi = pm.getPluginInterfaceByID("azupnpav", false);
        if (pi == null) {
            Logger.log(new LogEvent(LogIDs.UI3, "Media server plugin not found"));
            return null;
        }
        if (!pi.getPluginState().isOperational()) {
            Logger.log(new LogEvent(LogIDs.UI3, "Media server plugin not operational"));
            return null;
        }
        try {
            Program program = Program.findProgram(".qtl");
            boolean hasQuickTime = program == null ? false : program.getName().toLowerCase().indexOf("quicktime") != -1;
            pi.getIPC().invoke("setQuickTimeAvailable", new Object[]{new Boolean(hasQuickTime)});
            Object url = pi.getIPC().invoke("getContentURL", new Object[]{file});
            if (url instanceof String) {
                return new URL((String)url);
            }
        }
        catch (Throwable e) {
            Logger.log(new LogEvent(LogIDs.UI3, 1, "IPC to media server plugin failed", e));
        }
        return null;
    }

    private static final synchronized boolean loadEmpPluginClass() {
        if (piEmp != null && piEmp.getPluginState().isUnloaded()) {
            piEmp = null;
            triedLoadingEmpPluginClass = false;
            methodIsExternallyPlayable = null;
            methodIsExternallyPlayable2 = null;
        }
        if (!triedLoadingEmpPluginClass) {
            triedLoadingEmpPluginClass = true;
            try {
                piEmp = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("azemp");
                if (piEmp == null) {
                    return false;
                }
                Class<?> empPluginClass = piEmp.getPlugin().getClass();
                methodIsExternallyPlayable = empPluginClass.getMethod("isExternallyPlayable", TOTorrent.class);
                try {
                    methodIsExternallyPlayable2 = empPluginClass.getMethod("isExternallyPlayable", TOTorrent.class, Integer.TYPE);
                }
                catch (Throwable e) {
                    Logger.log(new LogEvent(LogIDs.UI3, "isExternallyPlayable with file_index not found"));
                }
            }
            catch (Exception e1) {
                return false;
            }
        }
        return true;
    }

    public static File getPrimaryFile(Download d) {
        DiskManagerFileInfo info = PlayUtils.getPrimaryFileInfo(d);
        if (info == null) {
            return null;
        }
        return info.getFile(true);
    }

    public static int getPrimaryFileIndex(DownloadManager dm) {
        return PlayUtils.getPrimaryFileIndex(PluginCoreUtils.wrap(dm));
    }

    public static int getPrimaryFileIndex(Download d) {
        DiskManagerFileInfo info = PlayUtils.getPrimaryFileInfo(d);
        if (info == null) {
            return -1;
        }
        return info.getIndex();
    }

    public static DiskManagerFileInfo getPrimaryFileInfo(Download d) {
        long size = d.getTorrent().getSize();
        DiskManagerFileInfo[] infos = d.getDiskManagerFileInfo();
        for (int i = 0; i < infos.length; ++i) {
            DiskManagerFileInfo info = infos[i];
            if (info.isSkipped() || info.isDeleted() || info.getLength() <= 90L * size / 100L) continue;
            return info;
        }
        return null;
    }

    public static boolean isExternallyPlayable(Download d, int file_index, boolean complete_only) {
        int primary_file_index = -1;
        if (file_index == -1) {
            DiskManagerFileInfo file = PlayUtils.getPrimaryFileInfo(d);
            if (file == null) {
                return false;
            }
            if (file.getDownloaded() != file.getLength() && (complete_only || PlayUtils.getMediaServerContentURL(file) == null)) {
                return false;
            }
            primary_file_index = PlayUtils.getPrimaryFileIndex(d);
        } else {
            DiskManagerFileInfo file = d.getDiskManagerFileInfo(file_index);
            if (file.getDownloaded() != file.getLength() && (complete_only || PlayUtils.getMediaServerContentURL(file) == null)) {
                return false;
            }
            primary_file_index = file_index;
        }
        if (primary_file_index == -1) {
            return false;
        }
        return PlayUtils.isExternallyPlayable(d.getDiskManagerFileInfo()[primary_file_index]);
    }

    public static String getPlayableFileExtensions() {
        return actualPlayableFileExtensions;
    }

    public static void setPlayableFileExtensions(String str) {
        actualPlayableFileExtensions = str;
    }

    private static boolean isExternallyPlayable(DiskManagerFileInfo file) {
        String name = file.getFile(true).getName();
        int extIndex = name.lastIndexOf(".");
        if (extIndex > -1) {
            String ext = name.substring(extIndex);
            if (ext == null) {
                return false;
            }
            ext = ext.toLowerCase();
            if (PlayUtils.getPlayableFileExtensions().indexOf(ext) > -1) {
                return true;
            }
        }
        return false;
    }

    public static boolean isExternallyPlayable(TOTorrent torrent, int file_index, boolean complete_only) {
        if (torrent == null) {
            return false;
        }
        try {
            Download download = AzureusCoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface().getDownloadManager().getDownload(torrent.getHash());
            if (download != null) {
                return PlayUtils.isExternallyPlayable(download, file_index, complete_only);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static final boolean canPlayViaExternalEMP(TOTorrent torrent, int file_index, boolean complete_only) {
        block8: {
            if (torrent == null) {
                return false;
            }
            if (!PlayUtils.loadEmpPluginClass() || methodIsExternallyPlayable == null) {
                return PlayUtils.isExternallyPlayable(torrent, file_index, complete_only);
            }
            try {
                Object retObj;
                if (file_index != -1 && methodIsExternallyPlayable2 != null) {
                    try {
                        retObj = methodIsExternallyPlayable2.invoke(null, torrent, file_index);
                    }
                    catch (Throwable e) {
                        Logger.log(new LogEvent(LogIDs.UI3, "isExternallyPlayable with file_index failed", e));
                    }
                }
                if ((retObj = methodIsExternallyPlayable.invoke(null, torrent)) instanceof Boolean) {
                    return (Boolean)retObj;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                if (e.getMessage() != null && e.getMessage().toLowerCase().endsWith("only")) break block8;
                Debug.out(e);
            }
        }
        return false;
    }
}

