/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.util;

import java.util.List;
import java.util.Map;
import org.bouncycastle.util.encoders.Base64;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;

public class MapUtils {
    public static int getMapInt(Map map, String key, int def) {
        if (map == null) {
            return def;
        }
        try {
            Number n = (Number)map.get(key);
            if (n == null) {
                return def;
            }
            return n.intValue();
        }
        catch (Throwable e) {
            Debug.out(e);
            return def;
        }
    }

    public static long getMapLong(Map map, String key, long def) {
        if (map == null) {
            return def;
        }
        try {
            Number n = (Number)map.get(key);
            if (n == null) {
                return def;
            }
            return n.longValue();
        }
        catch (Throwable e) {
            Debug.out(e);
            return def;
        }
    }

    public static String getMapString(Map map, String key, String def) {
        if (map == null) {
            return def;
        }
        try {
            Object o = map.get(key);
            if (o == null && !map.containsKey(key)) {
                return def;
            }
            if (o instanceof String) {
                return (String)o;
            }
            if (o instanceof byte[]) {
                return new String((byte[])o, "utf-8");
            }
            return def;
        }
        catch (Throwable t) {
            Debug.out(t);
            return def;
        }
    }

    public static byte[] getMapByteArray(Map map, String key, byte[] def) {
        if (map == null) {
            return def;
        }
        try {
            Object o = map.get(key);
            if (o instanceof byte[]) {
                return (byte[])o;
            }
            String b64Key = key + ".B64";
            if (map.containsKey(b64Key) && (o = map.get(b64Key)) instanceof String) {
                return Base64.decode((String)o);
            }
            String b32Key = key + ".B32";
            if (map.containsKey(b32Key) && (o = map.get(b32Key)) instanceof String) {
                return Base32.decode((String)o);
            }
            return def;
        }
        catch (Throwable t) {
            Debug.out(t);
            return def;
        }
    }

    public static Object getMapObject(Map map, String key, Object def, Class cla) {
        if (map == null) {
            return def;
        }
        try {
            Object o = map.get(key);
            if (cla.isInstance(o)) {
                return o;
            }
            return def;
        }
        catch (Throwable t) {
            Debug.out(t);
            return def;
        }
    }

    public static boolean getMapBoolean(Map map, String key, boolean def) {
        if (map == null) {
            return def;
        }
        try {
            Object o = map.get(key);
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
            if (o instanceof Long) {
                return (Long)o == 1L;
            }
            return def;
        }
        catch (Throwable e) {
            Debug.out(e);
            return def;
        }
    }

    public static List getMapList(Map map, String key, List def) {
        if (map == null) {
            return def;
        }
        try {
            List list = (List)map.get(key);
            if (list == null && !map.containsKey(key)) {
                return def;
            }
            return list;
        }
        catch (Throwable t) {
            Debug.out(t);
            return def;
        }
    }

    public static Map getMapMap(Map map, String key, Map def) {
        if (map == null) {
            return def;
        }
        try {
            Map valMap = (Map)map.get(key);
            if (valMap == null && !map.containsKey(key)) {
                return def;
            }
            return valMap;
        }
        catch (Throwable t) {
            Debug.out(t);
            return def;
        }
    }
}

