/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.utils;

import java.lang.reflect.Method;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Utils;

public class FontUtils {
    private static Method mFontData_SetHeight;
    private static Method mFontData_GetHeightF;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float getFontHeightFromPX(Font baseFont, GC gc, int heightInPixels) {
        float[] size;
        Font font;
        block7: {
            font = null;
            Device device = baseFont.getDevice();
            float[] fArray = new float[]{Utils.pixelsToPoint(++heightInPixels, device.getDPI().y) + 1};
            size = fArray;
            if (size[0] <= 0.0f) {
                return 0.0f;
            }
            boolean bOurGC = gc == null || gc.isDisposed();
            try {
                if (bOurGC) {
                    gc = new GC((Drawable)device);
                }
                FontData[] fontData = baseFont.getFontData();
                font = FontUtils.findFont(gc, font, fontData, size, heightInPixels, -1);
                Object var9_8 = null;
                if (!bOurGC) break block7;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (bOurGC) {
                    gc.dispose();
                }
                if (font != null && !font.isDisposed()) {
                    font.dispose();
                }
                throw throwable;
            }
            gc.dispose();
        }
        if (font != null && !font.isDisposed()) {
            font.dispose();
        }
        return size[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float getFontHeightFromPX(Device device, FontData[] fontData, GC gc, int heightInPixels) {
        float[] size;
        Font font;
        block7: {
            font = null;
            float[] fArray = new float[]{Utils.pixelsToPoint(++heightInPixels, device.getDPI().y) + 1};
            size = fArray;
            if (size[0] <= 0.0f) {
                return 0.0f;
            }
            boolean bOurGC = gc == null || gc.isDisposed();
            try {
                if (bOurGC) {
                    gc = new GC((Drawable)device);
                }
                font = FontUtils.findFont(gc, font, fontData, size, heightInPixels, -1);
                Object var8_7 = null;
                if (!bOurGC) break block7;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (bOurGC) {
                    gc.dispose();
                }
                if (font != null && !font.isDisposed()) {
                    font.dispose();
                }
                throw throwable;
            }
            gc.dispose();
        }
        if (font != null && !font.isDisposed()) {
            font.dispose();
        }
        return size[0];
    }

    public static Font getFontWithHeight(Font baseFont, GC gc, int heightInPixels) {
        return FontUtils.getFontWithHeight(baseFont, gc, heightInPixels, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Font getFontWithHeight(Font baseFont, GC gc, int heightInPixels, int style) {
        Font font = null;
        Device device = baseFont.getDevice();
        float[] fArray = new float[]{Utils.pixelsToPoint(++heightInPixels, device.getDPI().y) + 1};
        float[] size = fArray;
        if (size[0] <= 0.0f) {
            size[0] = 2.0f;
        }
        boolean bOurGC = gc == null || gc.isDisposed();
        try {
            if (bOurGC) {
                gc = new GC((Drawable)device);
            }
            FontData[] fontData = baseFont.getFontData();
            font = FontUtils.findFont(gc, font, fontData, size, heightInPixels, style);
            Object var10_9 = null;
            if (!bOurGC) return font;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (!bOurGC) throw throwable;
            gc.dispose();
            throw throwable;
        }
        gc.dispose();
        return font;
    }

    public static void setFontDataHeight(FontData[] fd, float fontSize) {
        if (mFontData_SetHeight != null) {
            try {
                mFontData_SetHeight.invoke((Object)fd[0], Float.valueOf(fontSize));
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        fd[0].setHeight((int)fontSize);
    }

    private static Font findFont(GC gc, Font font, FontData[] fontData, float[] size, int heightInPixels, int style) {
        if (mFontData_SetHeight != null) {
            return FontUtils.findFontByFloat(gc, font, fontData, size, heightInPixels, style);
        }
        return FontUtils.findFontByInt(gc, font, fontData, size, heightInPixels, style);
    }

    public static Font findFontByInt(GC gc, Font font, FontData[] fontData, float[] returnSize, int heightInPixels, int style) {
        int size = (int)returnSize[0];
        do {
            if (font != null) {
                --size;
                font.dispose();
            }
            fontData[0].setHeight(size);
            if (style != -1) {
                fontData[0].setStyle(style);
            }
            font = new Font(gc.getDevice(), fontData);
            gc.setFont(font);
        } while (font != null && gc.textExtent((String)"(/|,jI~`gy").y > heightInPixels && size > 1);
        returnSize[0] = size;
        return font;
    }

    public static Font findFontByFloat(GC gc, Font font, FontData[] fontData, float[] returnSize, int heightInPixels, int style) {
        boolean fits;
        float size = returnSize[0];
        float delta = 2.0f;
        int numLoops = 0;
        do {
            ++numLoops;
            if (font != null) {
                size -= delta;
                font.dispose();
            }
            try {
                mFontData_SetHeight.invoke((Object)fontData[0], Float.valueOf(size));
            }
            catch (Throwable e) {
                Debug.out(e);
            }
            if (style != -1) {
                fontData[0].setStyle(style);
            }
            font = new Font(gc.getDevice(), fontData);
            gc.setFont(font);
            boolean bl = fits = gc.textExtent((String)"(/|,jI~`gy").y <= heightInPixels;
            if (!fits || !((double)delta > 0.1)) continue;
            size += delta;
            delta /= 2.0f;
            fits = false;
        } while (!fits && size > 1.0f);
        returnSize[0] = size;
        return font;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFontHeightInPX(FontData[] fd) {
        int n;
        Font font = new Font((Device)Display.getDefault(), fd);
        try {
            n = FontUtils.getFontHeightInPX(font);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            font.dispose();
            throw throwable;
        }
        font.dispose();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFontHeightInPX(Font font) {
        int n;
        GC gc = new GC((Drawable)font.getDevice());
        try {
            gc.setFont(font);
            n = gc.textExtent((String)"(/|,jI~`gy").y;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            gc.dispose();
            throw throwable;
        }
        gc.dispose();
        return n;
    }

    public static void setFontHeight(Control control, int height, int style) {
        FontData[] fDatas = control.getFont().getFontData();
        for (int i = 0; i < fDatas.length; ++i) {
            fDatas[i].height = height;
            fDatas[i].setStyle(style);
        }
        final Font newFont = new Font((Device)control.getDisplay(), fDatas);
        control.setFont(newFont);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (null != newFont && !newFont.isDisposed()) {
                    newFont.dispose();
                }
            }
        });
    }

    public static float getHeight(FontData[] fd) {
        if (mFontData_GetHeightF != null) {
            try {
                return ((Number)mFontData_GetHeightF.invoke((Object)fd[0], new Object[0])).floatValue();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return fd[0].getHeight();
    }

    public static Font getFontPercentOf(Font baseFont, float pct) {
        FontData[] fontData = baseFont.getFontData();
        float height = FontUtils.getHeight(fontData) * pct;
        FontUtils.setFontDataHeight(fontData, height);
        return new Font(baseFont.getDevice(), fontData);
    }

    static {
        try {
            mFontData_SetHeight = FontData.class.getDeclaredMethod("setHeight", Float.TYPE);
            mFontData_SetHeight.setAccessible(true);
        }
        catch (Throwable e) {
            mFontData_SetHeight = null;
        }
        try {
            mFontData_GetHeightF = FontData.class.getDeclaredMethod("getHeightF", new Class[0]);
            mFontData_GetHeightF.setAccessible(true);
        }
        catch (Throwable e) {
            mFontData_GetHeightF = null;
        }
    }
}

