/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.subscriptions;

import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManagerFactory;
import com.aelitis.azureus.core.messenger.ClientMessageContext;
import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionListener;
import com.aelitis.azureus.core.subs.SubscriptionManagerFactory;
import com.aelitis.azureus.ui.common.ToolBarEnabler;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.browser.BrowserContext;
import com.aelitis.azureus.ui.swt.browser.CookiesListener;
import com.aelitis.azureus.ui.swt.browser.OpenCloseSearchDetailsListener;
import com.aelitis.azureus.ui.swt.browser.listener.ConfigListener;
import com.aelitis.azureus.ui.swt.browser.listener.DisplayListener;
import com.aelitis.azureus.ui.swt.browser.listener.ExternalLoginCookieListener;
import com.aelitis.azureus.ui.swt.browser.listener.MetaSearchListener;
import com.aelitis.azureus.ui.swt.browser.listener.TorrentListener;
import com.aelitis.azureus.ui.swt.browser.listener.VuzeListener;
import com.aelitis.azureus.ui.swt.mdi.MdiEntrySWT;
import com.aelitis.azureus.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.aelitis.azureus.ui.swt.subscriptions.SubscriptionMDIEntry;
import com.aelitis.azureus.ui.swt.subscriptions.SubscriptionManagerUI;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.MapUtils;
import com.aelitis.azureus.util.UrlFilter;
import java.util.Map;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AERunnableObject;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.views.AbstractIView;
import org.gudy.azureus2.ui.swt.views.IView;
import org.gudy.azureus2.ui.swt.views.IViewExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptionView
extends AbstractIView
implements IViewExtension,
OpenCloseSearchDetailsListener,
ToolBarEnabler {
    private Subscription subs;
    private Composite parent_composite;
    private Composite composite;
    private Browser mainBrowser;
    private Browser detailsBrowser;
    private final SubscriptionMDIEntry mdiInfo;

    public SubscriptionView(Subscription _subs) {
        this.subs = _subs;
        this.mdiInfo = (SubscriptionMDIEntry)this.subs.getUserData(SubscriptionManagerUI.SUB_ENTRYINFO_KEY);
    }

    protected void refreshView() {
        IView view;
        MdiEntrySWT entry;
        String key = "Subscription_" + ByteFormatter.encodeString(this.subs.getPublicKey());
        MultipleDocumentInterfaceSWT mdi = UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT();
        if (mdi != null && (entry = mdi.getEntrySWT(key)) != null && (view = entry.getIView()) instanceof SubscriptionView) {
            SubscriptionView subsView = (SubscriptionView)view;
            subsView.updateBrowser(false);
        }
    }

    @Override
    public void delete() {
        super.delete();
    }

    @Override
    public void initialize(Composite _parent_composite) {
        this.parent_composite = _parent_composite;
        this.composite = new Composite(this.parent_composite, 0);
        this.composite.setLayout(new FormLayout());
        this.subs.addListener(new SubscriptionListener(){

            public void subscriptionChanged(Subscription subs) {
                Utils.execSWTThread(new Runnable(){

                    public void run() {
                        SubscriptionView.this.updateInfo();
                    }
                });
            }

            public void subscriptionDownloaded(Subscription subs, boolean auto) {
                if (auto) {
                    SubscriptionView.this.updateBrowser(true);
                }
            }
        });
        this.updateInfo();
    }

    protected void createBrowsers() {
        if (this.mainBrowser != null && !this.mainBrowser.isDisposed()) {
            return;
        }
        try {
            this.mainBrowser = new Browser(this.composite, Utils.getInitialBrowserStyle(0));
            this.mainBrowser.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ((Browser)e.widget).setUrl("about:blank");
                    ((Browser)e.widget).setVisible(false);
                    while (!e.display.isDisposed() && e.display.readAndDispatch()) {
                    }
                }
            });
            BrowserContext context2 = new BrowserContext("browser-window" + Math.random(), this.mainBrowser, null, true);
            context2.addListener(new BrowserContext.loadingListener(){

                public void browserLoadingChanged(boolean loading, String url) {
                    if (((SubscriptionView)SubscriptionView.this).mdiInfo.spinnerImage != null) {
                        ((SubscriptionView)SubscriptionView.this).mdiInfo.spinnerImage.setVisible(loading);
                    }
                }
            });
            context2.addMessageListener(new TorrentListener());
            context2.addMessageListener(new VuzeListener());
            context2.addMessageListener(new DisplayListener(this.mainBrowser));
            context2.addMessageListener(new ConfigListener(this.mainBrowser));
            context2.addMessageListener(new MetaSearchListener(this));
            ContentNetwork contentNetwork = ContentNetworkManagerFactory.getSingleton().getContentNetwork(context2.getContentNetworkID());
            String url = contentNetwork.getSubscriptionURL(this.subs.getID());
            Boolean edit_mode = (Boolean)this.subs.getUserData(SubscriptionManagerUI.SUB_EDIT_MODE_KEY);
            if (edit_mode != null) {
                if (edit_mode.booleanValue()) {
                    url = url + "&editMode=1";
                }
                this.subs.setUserData(SubscriptionManagerUI.SUB_EDIT_MODE_KEY, null);
            }
            this.mainBrowser.setUrl(url);
            this.mainBrowser.setData("StartURL", url);
            FormData data = new FormData();
            data.left = new FormAttachment(0, 0);
            data.right = new FormAttachment(100, 0);
            data.top = new FormAttachment(this.composite, 0);
            data.bottom = new FormAttachment(100, 0);
            this.mainBrowser.setLayoutData(data);
            this.detailsBrowser = new Browser(this.composite, Utils.getInitialBrowserStyle(0));
            this.detailsBrowser.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ((Browser)e.widget).setUrl("about:blank");
                    ((Browser)e.widget).setVisible(false);
                    while (!e.display.isDisposed() && e.display.readAndDispatch()) {
                    }
                }
            });
            BrowserContext detailsContext = new BrowserContext("browser-window" + Math.random(), this.detailsBrowser, null, false);
            detailsContext.addListener(new BrowserContext.loadingListener(){

                public void browserLoadingChanged(boolean loading, String url) {
                    if (((SubscriptionView)SubscriptionView.this).mdiInfo.spinnerImage != null) {
                        ((SubscriptionView)SubscriptionView.this).mdiInfo.spinnerImage.setVisible(loading);
                    }
                }
            });
            ClientMessageContext.torrentURLHandler url_handler = new ClientMessageContext.torrentURLHandler(){

                public void handleTorrentURL(final String url) {
                    Utils.execSWTThreadWithObject("SMUI", new AERunnableObject(){

                        public Object runSupport() {
                            Subscription subs;
                            String subscriptionId = (String)SubscriptionView.this.detailsBrowser.getData("subscription_id");
                            String subscriptionResultId = (String)SubscriptionView.this.detailsBrowser.getData("subscription_result_id");
                            if (subscriptionId != null && subscriptionResultId != null && (subs = SubscriptionManagerFactory.getSingleton().getSubscriptionByID(subscriptionId)) != null) {
                                subs.addPotentialAssociation(subscriptionResultId, url);
                            }
                            return null;
                        }
                    }, 10000L);
                }
            };
            detailsContext.setTorrentURLHandler(url_handler);
            TorrentListener torrent_listener = new TorrentListener();
            torrent_listener.setTorrentURLHandler(url_handler);
            detailsContext.addMessageListener(torrent_listener);
            detailsContext.addMessageListener(new VuzeListener());
            detailsContext.addMessageListener(new DisplayListener(this.detailsBrowser));
            detailsContext.addMessageListener(new ConfigListener(this.detailsBrowser));
            url = "about:blank";
            this.detailsBrowser.setUrl(url);
            this.detailsBrowser.setData("StartURL", url);
            ExternalLoginCookieListener cookieListener = new ExternalLoginCookieListener(new CookiesListener(){

                public void cookiesFound(String cookies) {
                    SubscriptionView.this.detailsBrowser.setData("current-cookies", cookies);
                }
            }, this.detailsBrowser);
            cookieListener.hook();
            data = new FormData();
            data.left = new FormAttachment(0, 0);
            data.right = new FormAttachment(100, 0);
            data.top = new FormAttachment(this.mainBrowser, 0);
            data.bottom = new FormAttachment(100, 0);
            this.detailsBrowser.setLayoutData(data);
            this.mainBrowser.setVisible(true);
            this.detailsBrowser.setVisible(false);
            this.mainBrowser.getParent().layout(true, true);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    @Override
    public void refreshToolBar(Map<String, Boolean> list) {
        list.put("share", true);
        list.put("remove", true);
    }

    @Override
    public boolean toolBarItemActivated(String itemKey) {
        if (itemKey.equals("remove")) {
            this.mdiInfo.removeWithConfirm();
        }
        return false;
    }

    protected void destroyBrowsers() {
        if (this.mainBrowser != null) {
            this.mainBrowser.dispose();
            this.mainBrowser = null;
        }
        if (this.detailsBrowser != null) {
            this.detailsBrowser.dispose();
            this.detailsBrowser = null;
        }
    }

    @Override
    public void closeSearchResults(Map params) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                SubscriptionView.this.detailsBrowser.setVisible(false);
                FormData gd = (FormData)SubscriptionView.this.mainBrowser.getLayoutData();
                gd.bottom = new FormAttachment(100, 0);
                SubscriptionView.this.mainBrowser.setLayoutData(gd);
                SubscriptionView.this.mainBrowser.getParent().layout(true);
                SubscriptionView.this.detailsBrowser.setUrl("about:blank");
            }
        });
    }

    @Override
    public void openSearchResults(final Map params) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                String listenerAdded;
                String url = MapUtils.getMapString(params, "url", "http://google.com/search?q=" + Math.random());
                if (UrlFilter.getInstance().urlCanRPC(url)) {
                    url = ConstantsVuze.getDefaultContentNetwork().appendURLSuffix(url, false, true);
                }
                if ((listenerAdded = (String)SubscriptionView.this.detailsBrowser.getData("g.nt.la")) == null) {
                    SubscriptionView.this.detailsBrowser.setData("g.nt.la", "");
                    SubscriptionView.this.detailsBrowser.addProgressListener(new ProgressListener(){

                        public void changed(ProgressEvent event2) {
                        }

                        public void completed(ProgressEvent event2) {
                            Browser search = (Browser)event2.widget;
                            String execAfterLoad = (String)search.getData("execAfterLoad");
                            search.setData("execAfterLoad", null);
                            if (execAfterLoad != null && !execAfterLoad.equals("")) {
                                boolean result = search.execute(execAfterLoad);
                            }
                        }
                    });
                }
                String execAfterLoad = MapUtils.getMapString(params, "execAfterLoad", null);
                SubscriptionView.this.detailsBrowser.setData("execAfterLoad", execAfterLoad);
                SubscriptionView.this.detailsBrowser.setData("subscription_id", MapUtils.getMapString(params, "subs_id", null));
                SubscriptionView.this.detailsBrowser.setData("subscription_result_id", MapUtils.getMapString(params, "subs_rid", null));
                SubscriptionView.this.detailsBrowser.setUrl(url);
                SubscriptionView.this.detailsBrowser.setData("StartURL", url);
                SubscriptionView.this.detailsBrowser.setVisible(true);
                FormData data = (FormData)SubscriptionView.this.mainBrowser.getLayoutData();
                data.bottom = null;
                data.height = MapUtils.getMapInt(params, "top-height", 120);
                SubscriptionView.this.mainBrowser.getParent().layout(true, true);
            }
        });
    }

    protected void updateBrowser(final boolean is_auto) {
        if (this.mainBrowser != null && !this.mainBrowser.isDisposed()) {
            Utils.execSWTThread(new Runnable(){

                public void run() {
                    if (SubscriptionView.this.mainBrowser != null && !SubscriptionView.this.mainBrowser.isDisposed() && SubscriptionView.this.mainBrowser.isVisible()) {
                        String url = (String)SubscriptionView.this.mainBrowser.getData("StartURL");
                        if (is_auto && url.endsWith("&editMode=1")) {
                            url = url.substring(0, url.lastIndexOf("&editMode=1"));
                            SubscriptionView.this.mainBrowser.setData("StartURL", url);
                        }
                        SubscriptionView.this.mainBrowser.setUrl(url);
                    }
                }
            });
        }
    }

    protected void updateInfo() {
    }

    @Override
    public Composite getComposite() {
        return this.composite;
    }

    @Override
    public String getFullTitle() {
        return this.subs.getName();
    }

    @Override
    public void resizeMainBrowser() {
        if (this.mainBrowser != null) {
            Utils.execSWTThreadLater(0, new Runnable(){

                public void run() {
                    if (SubscriptionView.this.mainBrowser != null && !SubscriptionView.this.mainBrowser.isDisposed() && SubscriptionView.this.mainBrowser.isVisible()) {
                        FormData data = (FormData)SubscriptionView.this.mainBrowser.getLayoutData();
                        data.bottom = new FormAttachment(100, -1);
                        SubscriptionView.this.mainBrowser.getParent().layout(true);
                        Utils.execSWTThreadLater(0, new Runnable(){

                            public void run() {
                                if (SubscriptionView.this.mainBrowser != null && !SubscriptionView.this.mainBrowser.isDisposed() && SubscriptionView.this.mainBrowser.isVisible()) {
                                    FormData data = (FormData)SubscriptionView.this.mainBrowser.getLayoutData();
                                    data.bottom = new FormAttachment(100, 0);
                                    SubscriptionView.this.mainBrowser.getParent().layout(true);
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    @Override
    public void resizeSecondaryBrowser() {
    }

    @Override
    public Menu getPrivateMenu() {
        return null;
    }

    @Override
    public void viewActivated() {
        this.createBrowsers();
    }

    @Override
    public void viewDeactivated() {
        if (this.mdiInfo.spinnerImage != null) {
            this.mdiInfo.spinnerImage.setVisible(false);
        }
        this.destroyBrowsers();
    }
}

