/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.subscriptions;

import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.ui.selectedcontent.DownloadUrlInfo;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.ui.selectedcontent.ISelectedVuzeFileContent;
import java.io.File;
import java.net.URL;
import java.util.Map;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentCreator;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.Debug;

public class SubscriptionSelectedContent
implements ISelectedVuzeFileContent {
    private Subscription subs;
    private TOTorrent torrent;

    protected SubscriptionSelectedContent(Subscription _subs) {
        this.subs = _subs;
    }

    public String getDisplayName() {
        return MessageText.getString("subscriptions.column.name") + ": " + this.subs.getName();
    }

    public String getHash() {
        return this.subs.getID();
    }

    public VuzeFile getVuzeFile() {
        try {
            return this.subs.getVuzeFile();
        }
        catch (Throwable e) {
            Debug.out(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TOTorrent getTorrent() {
        SubscriptionSelectedContent subscriptionSelectedContent = this;
        synchronized (subscriptionSelectedContent) {
            block8: {
                if (this.torrent == null) {
                    try {
                        VuzeFile vf = this.subs.getVuzeFile();
                        if (vf == null) break block8;
                        File f1 = AETemporaryFileHandler.createTempFile();
                        File f = new File(f1.getParent(), "Update Vuze to access this share_" + f1.getName());
                        f1.delete();
                        try {
                            vf.write(f);
                            TOTorrentCreator cr = TOTorrentFactory.createFromFileOrDirWithComputedPieceLength(f, new URL("dht://"));
                            TOTorrent temp = cr.create();
                            Map vuze_map = vf.exportToMap();
                            Map torrent_map = temp.serialiseToMap();
                            torrent_map.putAll(vuze_map);
                            this.torrent = TOTorrentFactory.deserialiseFromMap(torrent_map);
                            Object var10_10 = null;
                            f.delete();
                        }
                        catch (Throwable throwable) {
                            Object var10_11 = null;
                            f.delete();
                            throw throwable;
                        }
                        {
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        }
        return this.torrent;
    }

    public void setHash(String hash) {
    }

    public DownloadManager getDownloadManager() {
        return null;
    }

    public int getFileIndex() {
        return 0;
    }

    public void setDownloadManager(DownloadManager dm) {
    }

    public void setTorrent(TOTorrent torrent) {
    }

    public void setDisplayName(String displayName) {
    }

    public DownloadUrlInfo getDownloadInfo() {
        return null;
    }

    public void setDownloadInfo(DownloadUrlInfo downloadInfo) {
    }

    public boolean sameAs(ISelectedContent _other) {
        if (_other == this) {
            return true;
        }
        if (_other instanceof SubscriptionSelectedContent) {
            SubscriptionSelectedContent other = (SubscriptionSelectedContent)_other;
            return this.subs == other.subs;
        }
        return false;
    }
}

