/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.skin;

import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBasic;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import java.util.Arrays;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.ui.swt.Utils;

public class SWTSkinObjectTextbox
extends SWTSkinObjectBasic {
    private Text textWidget;
    private Composite cBubble;
    private String text = "";

    public SWTSkinObjectTextbox(SWTSkin skin, SWTSkinProperties properties, String id, String configID, SWTSkinObject parentSkinObject) {
        super(skin, properties, id, configID, "textbox", parentSkinObject);
        Composite createOn = this.parent == null ? skin.getShell() : (Composite)this.parent.getControl();
        int style = 2048;
        String styleString = properties.getStringValue(this.sConfigID + ".style");
        if (styleString != null) {
            Object[] styles = Constants.PAT_SPLIT_COMMA.split(styleString.toLowerCase());
            Arrays.sort(styles);
            if (Arrays.binarySearch(styles, "readonly") >= 0) {
                style |= 8;
            }
            if (Arrays.binarySearch(styles, "wrap") >= 0) {
                style |= 0x40;
            }
            style = Arrays.binarySearch(styles, "multiline") >= 0 ? (style |= 0x202) : (style |= 4);
            if (Arrays.binarySearch(styles, "search") >= 0) {
                style |= 0x380;
                if (Constants.isWindows) {
                    this.cBubble = new Composite(createOn, 0);
                    this.cBubble.setLayout(new FormLayout());
                }
            }
        }
        if ((style & 0x40) == 0 && (style & 2) > 0) {
            style |= 0x100;
        }
        if (this.cBubble == null) {
            this.textWidget = new Text(createOn, style);
        } else {
            this.textWidget = new Text(this.cBubble, style & 0xFFFFF77F);
            FormData fd = new FormData();
            fd.top = new FormAttachment(0, 2);
            fd.bottom = new FormAttachment(100, -2);
            fd.left = new FormAttachment(0, 17);
            fd.right = new FormAttachment(100, -14);
            this.textWidget.setLayoutData(fd);
            this.cBubble.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    boolean textIsBlank;
                    Rectangle clientArea = SWTSkinObjectTextbox.this.cBubble.getClientArea();
                    e.gc.setBackground(SWTSkinObjectTextbox.this.textWidget.getBackground());
                    e.gc.setAdvanced(true);
                    e.gc.setAntialias(1);
                    e.gc.fillRoundRectangle(clientArea.x, clientArea.y, clientArea.width - 1, clientArea.height - 1, clientArea.height, clientArea.height);
                    e.gc.setAlpha(127);
                    e.gc.drawRoundRectangle(clientArea.x, clientArea.y, clientArea.width - 1, clientArea.height - 1, clientArea.height, clientArea.height);
                    e.gc.setLineCap(2);
                    int iconHeight = clientArea.height - 9;
                    if (iconHeight > 13) {
                        iconHeight = 13;
                    }
                    int iconY = clientArea.y + (clientArea.height - iconHeight + 1) / 2;
                    e.gc.setAlpha(120);
                    e.gc.setLineWidth(2);
                    e.gc.drawOval(clientArea.x + 6, iconY, 7, 6);
                    e.gc.drawPolyline(new int[]{clientArea.x + 12, iconY + 6, clientArea.x + 15, iconY + iconHeight});
                    boolean bl = textIsBlank = SWTSkinObjectTextbox.this.text.length() == 0;
                    if (!textIsBlank) {
                        e.gc.setAlpha(80);
                        Rectangle rXArea = new Rectangle(clientArea.x + clientArea.width - 16, clientArea.y + 1, 11, clientArea.height - 2);
                        SWTSkinObjectTextbox.this.cBubble.setData("XArea", rXArea);
                        e.gc.drawPolyline(new int[]{clientArea.x + clientArea.width - 7, clientArea.y + 7, clientArea.x + clientArea.width - 12, clientArea.y + clientArea.height - 7});
                        e.gc.drawPolyline(new int[]{clientArea.x + clientArea.width - 7, clientArea.y + clientArea.height - 7, clientArea.x + clientArea.width - 12, clientArea.y + 7});
                    }
                }
            });
            this.cBubble.addListener(3, new Listener(){

                public void handleEvent(Event event2) {
                    Rectangle r = (Rectangle)event2.widget.getData("XArea");
                    if (r != null && r.contains(event2.x, event2.y)) {
                        SWTSkinObjectTextbox.this.textWidget.setText("");
                    }
                }
            });
        }
        this.textWidget.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean textIsBlank;
                boolean textWasBlank = SWTSkinObjectTextbox.this.text.length() == 0;
                SWTSkinObjectTextbox.this.text = SWTSkinObjectTextbox.this.textWidget.getText();
                boolean bl = textIsBlank = SWTSkinObjectTextbox.this.text.length() == 0;
                if (textWasBlank != textIsBlank && SWTSkinObjectTextbox.this.cBubble != null) {
                    SWTSkinObjectTextbox.this.cBubble.redraw();
                }
            }
        });
        String message = properties.getStringValue(configID + ".message", (String)null);
        if (message != null && message.length() > 0) {
            this.textWidget.setMessage(message);
        }
        this.setControl(this.cBubble == null ? this.textWidget : this.cBubble);
    }

    public String switchSuffix(String suffix, int level, boolean walkUp, boolean walkDown) {
        if ((suffix = super.switchSuffix(suffix, level, walkUp, walkDown)) == null) {
            return null;
        }
        String sPrefix = this.sConfigID + ".text";
        String text = this.properties.getStringValue(sPrefix + suffix);
        if (text != null) {
            this.setText(text);
        }
        return suffix;
    }

    public void setText(final String val) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (SWTSkinObjectTextbox.this.textWidget != null && !SWTSkinObjectTextbox.this.textWidget.isDisposed()) {
                    SWTSkinObjectTextbox.this.textWidget.setText(val == null ? "" : val);
                    SWTSkinObjectTextbox.this.text = val;
                }
            }
        });
    }

    public String getText() {
        return this.text;
    }

    public Text getTextControl() {
        return this.textWidget;
    }
}

