/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.shells.main;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.ui.InitializerListener;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.UIFunctionsUserPrompter;
import com.aelitis.azureus.ui.UIStatusTextClickListener;
import com.aelitis.azureus.ui.UserPrompterResultListener;
import com.aelitis.azureus.ui.common.table.TableView;
import com.aelitis.azureus.ui.common.updater.UIUpdater;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MultipleDocumentInterface;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.swt.Initializer;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.mdi.BaseMdiEntry;
import com.aelitis.azureus.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.aelitis.azureus.ui.swt.plugininstall.SimplePluginInstaller;
import com.aelitis.azureus.ui.swt.shells.BrowserWindow;
import com.aelitis.azureus.ui.swt.shells.main.MainMenu;
import com.aelitis.azureus.ui.swt.shells.main.MainWindow;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectButton;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.uiupdater.UIUpdaterSWT;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import com.aelitis.azureus.ui.swt.views.skin.SkinViewManager;
import com.aelitis.azureus.ui.swt.views.skin.SkinnedDialog;
import com.aelitis.azureus.ui.swt.views.skin.ToolBarView;
import com.aelitis.azureus.util.ContentNetworkUtils;
import com.aelitis.azureus.util.UrlFilter;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginView;
import org.gudy.azureus2.plugins.ui.UIInputReceiver;
import org.gudy.azureus2.plugins.ui.UIInputReceiverListener;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.SimpleTextEntryWindow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.IMainMenu;
import org.gudy.azureus2.ui.swt.mainwindow.IMainWindow;
import org.gudy.azureus2.ui.swt.mainwindow.MainStatusBar;
import org.gudy.azureus2.ui.swt.mainwindow.MenuFactory;
import org.gudy.azureus2.ui.swt.mainwindow.PluginsMenuHelper;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.minibar.AllTransfersBar;
import org.gudy.azureus2.ui.swt.minibar.MiniBarManager;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.plugins.UISWTPluginView;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTInstanceImpl;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewImpl;
import org.gudy.azureus2.ui.swt.shells.CoreWaiterSWT;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.shells.MessageSlideShell;
import org.gudy.azureus2.ui.swt.update.FullUpdateWindow;
import org.gudy.azureus2.ui.swt.views.AbstractIView;
import org.gudy.azureus2.ui.swt.views.ConfigShell;
import org.gudy.azureus2.ui.swt.views.ConfigView;
import org.gudy.azureus2.ui.swt.views.IView;
import org.gudy.azureus2.ui.swt.views.LoggerView;
import org.gudy.azureus2.ui.swt.views.ManagerView;
import org.gudy.azureus2.ui.swt.views.MySharesView;
import org.gudy.azureus2.ui.swt.views.MyTrackerView;
import org.gudy.azureus2.ui.swt.views.PeerSuperView;
import org.gudy.azureus2.ui.swt.views.TorrentOptionsView;
import org.gudy.azureus2.ui.swt.views.clientstats.ClientStatsView;
import org.gudy.azureus2.ui.swt.views.stats.StatsView;

public class UIFunctionsImpl
implements UIFunctionsSWT {
    private static final LogIDs LOGID = LogIDs.GUI;
    private final MainWindow mainWindow;
    private SWTSkin skin = null;
    protected boolean isTorrentMenuVisible;

    public UIFunctionsImpl(MainWindow window) {
        this.mainWindow = window;
        COConfigurationManager.addAndFireParameterListener("show_torrents_menu", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                UIFunctionsImpl.this.isTorrentMenuVisible = COConfigurationManager.getBooleanParameter("show_torrents_menu");
            }
        });
    }

    public void addPluginView(PluginView view) {
        PluginsMenuHelper.getInstance().addPluginView(view, view.getPluginViewName());
    }

    public void addPluginView(final String viewID, final UISWTViewEventListener l) {
        try {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    PluginsMenuHelper.getInstance().addPluginView(viewID, l);
                }
            });
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "addPluginView", e));
        }
    }

    public void addPluginView(UISWTPluginView view) {
        PluginsMenuHelper.getInstance().addPluginView(view, view.getPluginViewName());
    }

    public void bringToFront() {
        this.bringToFront(true);
    }

    public void bringToFront(final boolean tryTricks) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                try {
                    UIFunctionsImpl.this.mainWindow.setVisible(true, tryTricks);
                }
                catch (Exception e) {
                    Logger.log(new LogEvent(LOGID, "bringToFront", e));
                }
            }
        });
    }

    public void closeDownloadBars() {
        try {
            Utils.execSWTThreadLater(0, new AERunnable(){

                public void runSupport() {
                    MiniBarManager.getManager().closeAll();
                }
            });
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "closeDownloadBars", e));
        }
    }

    public void closePluginView(IView view) {
        try {
            String id;
            MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
            if (mdi == null) {
                return;
            }
            if (view instanceof UISWTViewImpl) {
                id = ((UISWTViewImpl)view).getViewID();
            } else {
                id = view.getClass().getName();
                int i = id.lastIndexOf(46);
                if (i > 0) {
                    id = id.substring(i + 1);
                }
            }
            mdi.closeEntry(id);
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "closePluginView", e));
        }
    }

    public void closePluginViews(String sViewID) {
        try {
            MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
            if (mdi == null) {
                return;
            }
            mdi.closeEntry(sViewID);
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "closePluginViews", e));
        }
    }

    public boolean dispose(boolean for_restart, boolean close_already_in_progress) {
        try {
            return this.mainWindow.dispose(for_restart, close_already_in_progress);
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "Disposing MainWindow", e));
            return false;
        }
    }

    public Shell getMainShell() {
        return this.mainWindow.shell;
    }

    public UISWTView[] getPluginViews() {
        try {
            return new UISWTView[0];
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "getPluginViews", e));
            return new UISWTView[0];
        }
    }

    public UISWTInstanceImpl getSWTPluginInstanceImpl() {
        try {
            return (UISWTInstanceImpl)this.mainWindow.getUISWTInstanceImpl();
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "getSWTPluginInstanceImpl", e));
            return null;
        }
    }

    public void openPluginView(AbstractIView view, String name) {
        try {
            MultipleDocumentInterfaceSWT mdi = this.getMDISWT();
            if (mdi == null) {
                return;
            }
            if (mdi.createEntryFromIView("header.plugins", view, name, null, true, true, true) != null) {
                return;
            }
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "openPluginView", e));
        }
    }

    public void openPluginView(PluginView view) {
        this.openPluginView(view, view.getPluginViewName());
    }

    public void openPluginView(String sParentID, String sViewID, UISWTViewEventListener l, Object dataSource, boolean bSetFocus) {
        try {
            MultipleDocumentInterfaceSWT mdi = this.getMDISWT();
            if (mdi != null) {
                String sidebarParentID = null;
                if ("MyTorrents".equals(sParentID)) {
                    sidebarParentID = "header.transfers";
                } else if ("Main".equals(sParentID)) {
                    sidebarParentID = "header.plugins";
                } else {
                    System.err.println("Can't find parent " + sParentID + " for " + sViewID);
                }
                MdiEntry entry = mdi.createEntryFromEventListener(sidebarParentID, l, sViewID, true, dataSource);
                if (bSetFocus) {
                    mdi.showEntryByID(sViewID);
                } else if (entry instanceof BaseMdiEntry) {
                    ((BaseMdiEntry)entry).build();
                }
            }
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "openPluginView", e));
        }
    }

    public void openPluginView(UISWTPluginView view) {
        this.openPluginView(view, view.getPluginViewName());
    }

    public void refreshIconBar() {
        try {
            ToolBarView tb = (ToolBarView)SkinViewManager.getByClass(ToolBarView.class);
            if (tb != null) {
                tb.refreshCoreToolBarItems();
            }
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "refreshIconBar", e));
        }
    }

    public void refreshLanguage() {
        try {
            this.mainWindow.setSelectedLanguageItem();
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "refreshLanguage", e));
        }
    }

    public void removeManagerView(DownloadManager dm) {
    }

    public void removePluginView(String viewID) {
        try {
            PluginsMenuHelper.getInstance().removePluginViews(viewID);
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "removePluginView", e));
        }
    }

    public void removePluginView(UISWTPluginView view) {
        try {
            PluginsMenuHelper.getInstance().removePluginView(view, view.getPluginViewName());
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "removePluginView", e));
        }
    }

    public void setStatusText(final String string) {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                UIFunctionsImpl.this.getMainStatusBar().setStatusText(string);
            }
        });
    }

    public void setStatusText(final int statustype, final String string, final UIStatusTextClickListener l) {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                UIFunctionsImpl.this.getMainStatusBar().setStatusText(statustype, string, l);
            }
        });
    }

    public MainStatusBar getMainStatusBar() {
        return this.mainWindow.getMainStatusBar();
    }

    public boolean showConfig(String section) {
        try {
            boolean uiClassic = COConfigurationManager.getStringParameter("ui").equals("az2");
            if (uiClassic) {
                this.mainWindow.openView("header.plugins", ConfigView.class, null, section, true);
            } else {
                ConfigShell.getInstance().open(section);
            }
            return true;
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "showConfig", e));
            return false;
        }
    }

    public void openView(final int viewID, final Object data) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                UIFunctionsImpl.this._openView(viewID, data);
            }
        });
    }

    private void _openView(int viewID, Object data) {
        switch (viewID) {
            case 0: {
                this.mainWindow.openView("header.plugins", LoggerView.class, null, data, true);
                break;
            }
            case 10: {
                this.mainWindow.openView("header.transfers", PeerSuperView.class, null, data, true);
                break;
            }
            case 12: {
                this.mainWindow.openView("header.plugins", ClientStatsView.class, null, data, true);
                break;
            }
            case 4: {
                this.showConfig(data instanceof String ? (String)data : null);
                break;
            }
            case 5: {
                DownloadManager dm;
                TOTorrent torrent;
                String id = "DMDetails_";
                if (data instanceof DownloadManager && (torrent = (dm = (DownloadManager)data).getTorrent()) != null) {
                    try {
                        id = id + torrent.getHashWrapper().toBase32String();
                    }
                    catch (TOTorrentException e) {
                        e.printStackTrace();
                    }
                }
                this.mainWindow.openView("header.transfers", ManagerView.class, id, data, true);
                break;
            }
            case 6: {
                this.mainWindow.openView("header.transfers", TorrentOptionsView.class, null, data, true);
                break;
            }
            case 7: {
                this.mainWindow.openView("header.plugins", MySharesView.class, null, data, true);
                break;
            }
            case 8: {
                MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                if (mdi == null) break;
                mdi.showEntryByID("Library");
                break;
            }
            case 9: {
                this.mainWindow.openView("header.plugins", MyTrackerView.class, null, data, true);
                break;
            }
            case 1: {
                this.mainWindow.openView("header.plugins", StatsView.class, null, data, true);
                break;
            }
            case 13: {
                MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                if (mdi == null) break;
                mdi.showEntryByID("RelatedContent");
                break;
            }
        }
    }

    public UISWTInstance getUISWTInstance() {
        return this.mainWindow.getUISWTInstanceImpl();
    }

    public void viewURL(String url, String target, String sourceRef) {
        ContentNetworkUtils.setSourceRef(target, sourceRef, false);
        this.viewURL(url, target, 0, 0, true, false);
    }

    public boolean viewURL(final String url, final String target, final int w, final int h, final boolean allowResize, final boolean isModal) {
        this.mainWindow.shell.getDisplay().syncExec(new AERunnable(){

            public void runSupport() {
                String realURL = url;
                ContentNetwork cn = ContentNetworkUtils.getContentNetworkFromTarget(target);
                if (!realURL.startsWith("http") && !realURL.startsWith("#")) {
                    realURL = "_blank".equals(target) ? cn.getExternalSiteRelativeURL(realURL, false) : cn.getSiteRelativeURL(realURL, false);
                }
                if (target == null) {
                    if (UrlFilter.getInstance().urlCanRPC(realURL)) {
                        realURL = cn.appendURLSuffix(realURL, false, true);
                    }
                    BrowserWindow window = new BrowserWindow(((UIFunctionsImpl)UIFunctionsImpl.this).mainWindow.shell, realURL, w, h, allowResize, isModal);
                    window.waitUntilClosed();
                } else {
                    UIFunctionsImpl.this.mainWindow.showURL(realURL, target);
                }
            }
        });
        return true;
    }

    public boolean viewURL(final String url, final String target, final double w, final double h, final boolean allowResize, final boolean isModal) {
        this.mainWindow.shell.getDisplay().syncExec(new AERunnable(){

            public void runSupport() {
                String realURL = url;
                ContentNetwork cn = ContentNetworkUtils.getContentNetworkFromTarget(target);
                if (!realURL.startsWith("http")) {
                    realURL = "_blank".equals(target) ? cn.getExternalSiteRelativeURL(realURL, false) : cn.getSiteRelativeURL(realURL, false);
                }
                if (target == null) {
                    if (UrlFilter.getInstance().urlCanRPC(realURL)) {
                        realURL = cn.appendURLSuffix(realURL, false, true);
                    }
                    BrowserWindow window = new BrowserWindow(((UIFunctionsImpl)UIFunctionsImpl.this).mainWindow.shell, realURL, w, h, allowResize, isModal);
                    window.waitUntilClosed();
                } else {
                    UIFunctionsImpl.this.mainWindow.showURL(realURL, target);
                }
            }
        });
        return true;
    }

    public void promptUser(String title, String text, String[] buttons, int defaultOption, String rememberID, String rememberText, boolean rememberByDefault, int autoCloseInMS, UserPrompterResultListener l) {
        MessageBoxShell.open(this.getMainShell(), title, text, buttons, defaultOption, rememberID, rememberText, rememberByDefault, autoCloseInMS, l);
    }

    public UIFunctionsUserPrompter getUserPrompter(String title, String text, String[] buttons, int defaultOption) {
        MessageBoxShell mb = new MessageBoxShell(title, text, buttons, defaultOption);
        return mb;
    }

    public boolean isGlobalTransferBarShown() {
        if (!AzureusCoreFactory.isCoreRunning()) {
            return false;
        }
        return AllTransfersBar.getManager().isOpen(AzureusCoreFactory.getSingleton().getGlobalManager());
    }

    public void showGlobalTransferBar() {
        CoreWaiterSWT.waitForCoreRunning(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                AllTransfersBar.open(core.getGlobalManager(), UIFunctionsImpl.this.getMainShell());
            }
        });
    }

    public void closeGlobalTransferBar() {
        CoreWaiterSWT.waitForCoreRunning(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                AllTransfersBar.close(core.getGlobalManager());
            }
        });
    }

    public void refreshTorrentMenu() {
        if (!this.isTorrentMenuVisible) {
            return;
        }
        try {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    MenuItem torrentItem = MenuFactory.findMenuItem(UIFunctionsImpl.this.mainWindow.getMainMenu().getMenu("menu.bar"), "MainWindow.menu.torrent", false);
                    if (null != torrentItem) {
                        DownloadManager[] dms;
                        DownloadManager[] dm_final = dms = SelectedContentManager.getDMSFromSelectedContent();
                        boolean detailed_view_final = false;
                        if (null == dm_final) {
                            torrentItem.setEnabled(false);
                        } else {
                            TableView tv = SelectedContentManager.getCurrentlySelectedTableView();
                            torrentItem.getMenu().setData("TableView", tv);
                            torrentItem.getMenu().setData("downloads", dm_final);
                            torrentItem.getMenu().setData("is_detailed_view", false);
                            torrentItem.setEnabled(true);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "refreshTorrentMenu", e));
        }
    }

    public IMainMenu createMainMenu(Shell shell) {
        boolean uiClassic = COConfigurationManager.getStringParameter("ui").equals("az2");
        IMainMenu menu = uiClassic ? new org.gudy.azureus2.ui.swt.mainwindow.MainMenu(shell) : new MainMenu(this.skin, shell);
        return menu;
    }

    public SWTSkin getSkin() {
        return this.skin;
    }

    public void setSkin(SWTSkin skin) {
        this.skin = skin;
    }

    public IMainWindow getMainWindow() {
        return this.mainWindow;
    }

    public UIUpdater getUIUpdater() {
        return UIUpdaterSWT.getInstance();
    }

    public void closeAllDetails() {
        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
        if (mdi == null) {
            return;
        }
        MdiEntry[] sideBarEntries = mdi.getEntries();
        for (int i = 0; i < sideBarEntries.length; ++i) {
            MdiEntry entry = sideBarEntries[i];
            String id = entry.getId();
            if (id == null || !id.startsWith("DMDetails_")) continue;
            mdi.closeEntry(id);
        }
    }

    public boolean hasDetailViews() {
        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
        if (mdi == null) {
            return false;
        }
        MdiEntry[] sideBarEntries = mdi.getEntries();
        for (int i = 0; i < sideBarEntries.length; ++i) {
            MdiEntry entry = sideBarEntries[i];
            String id = entry.getId();
            if (id == null || !id.startsWith("DMDetails_")) continue;
            return true;
        }
        return false;
    }

    public void performAction(int action_id, Object args, final UIFunctions.actionListener listener) {
        if (action_id == 1) {
            FullUpdateWindow.handleUpdate((String)args, listener);
        } else if (action_id == 2) {
            String MSG_PREFIX = "UpdateMonitor.messagebox.";
            String title = MessageText.getString(MSG_PREFIX + "restart.title");
            String text = MessageText.getString(MSG_PREFIX + "restart.text");
            this.bringToFront();
            boolean no_timeout = args instanceof Boolean && (Boolean)args != false;
            int timeout = 180000;
            if (no_timeout || !PluginInitializer.getDefaultInterface().getPluginManager().isSilentRestartEnabled()) {
                timeout = -1;
            }
            this.promptUser(title, text, new String[]{MessageText.getString("UpdateWindow.restart"), MessageText.getString("UpdateWindow.restartLater")}, 0, null, null, false, timeout, new UserPrompterResultListener(){

                public void prompterClosed(int result) {
                    listener.actionComplete(result == 0);
                }
            });
        } else {
            Debug.out("Unknown action " + action_id);
        }
    }

    public Shell showCoreWaitDlg() {
        Initializer initializer;
        final SkinnedDialog closeDialog = new SkinnedDialog("skin3_dlg_coreloading", "coreloading.body", 67616);
        closeDialog.setTitle(MessageText.getString("dlg.corewait.title"));
        SWTSkin skin = closeDialog.getSkin();
        SWTSkinObjectButton soButton = (SWTSkinObjectButton)skin.getSkinObject("close");
        final SWTSkinObjectText soWaitTask = (SWTSkinObjectText)skin.getSkinObject("task");
        final SWTSkinObject soWaitProgress = skin.getSkinObject("progress");
        if (soWaitProgress != null) {
            soWaitProgress.getControl().addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    Control c = (Control)e.widget;
                    Point size = c.getSize();
                    e.gc.setBackground(ColorCache.getColor((Device)e.display, "#23a7df"));
                    Object data = soWaitProgress.getData("progress");
                    if (data instanceof Long) {
                        int waitProgress = ((Long)data).intValue();
                        int breakX = size.x * waitProgress / 100;
                        e.gc.fillRectangle(0, 0, breakX, size.y);
                        e.gc.setBackground(ColorCache.getColor((Device)e.display, "#cccccc"));
                        e.gc.fillRectangle(breakX, 0, size.x - breakX, size.y);
                    }
                }
            });
        }
        if (!AzureusCoreFactory.isCoreRunning() && (initializer = Initializer.getLastInitializer()) != null) {
            initializer.addListener(new InitializerListener(){

                public void reportPercent(final int percent) {
                    Utils.execSWTThread(new AERunnable(){

                        public void runSupport() {
                            if (soWaitProgress != null && !soWaitProgress.isDisposed()) {
                                soWaitProgress.setData("progress", new Long(percent));
                                soWaitProgress.getControl().redraw();
                                soWaitProgress.getControl().update();
                            }
                        }
                    });
                    if (percent > 100) {
                        initializer.removeListener(this);
                    }
                }

                public void reportCurrentTask(String currentTask) {
                    if (soWaitTask != null && !soWaitTask.isDisposed()) {
                        soWaitTask.setText(currentTask);
                    }
                }
            });
        }
        if (soButton != null) {
            soButton.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    closeDialog.close();
                }
            });
        }
        closeDialog.addCloseListener(new SkinnedDialog.SkinnedDialogClosedListener(){

            public void skinDialogClosed(SkinnedDialog dialog) {
            }
        });
        closeDialog.open();
        return closeDialog.getShell();
    }

    public void doSearch(String searchText) {
        MainWindow.doSearch(searchText);
    }

    public void promptForSearch() {
        SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("Button.search", "search.dialog.text");
        entryWindow.prompt(new UIInputReceiverListener(){

            public void UIInputReceiverClosed(UIInputReceiver receiver) {
                if (receiver.hasSubmittedInput()) {
                    UIFunctionsImpl.this.doSearch(receiver.getSubmittedInput());
                }
            }
        });
    }

    public MultipleDocumentInterface getMDI() {
        return (MultipleDocumentInterface)((Object)SkinViewManager.getByViewID("mdi"));
    }

    public MultipleDocumentInterfaceSWT getMDISWT() {
        return (MultipleDocumentInterfaceSWT)((Object)SkinViewManager.getByViewID("mdi"));
    }

    public void forceNotify(final int iconID, final String title, final String text, final String details, final Object[] relatedObjects, final int timeoutSecs) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                int swtIconID = 2;
                switch (iconID) {
                    case 1: {
                        swtIconID = 8;
                        break;
                    }
                    case 2: {
                        swtIconID = 1;
                    }
                }
                new MessageSlideShell(SWTThread.getInstance().getDisplay(), swtIconID, title, text, details, relatedObjects, timeoutSecs);
            }
        });
    }

    public void installPlugin(String plugin_id, String resource_prefix, UIFunctions.actionListener listener) {
        new SimplePluginInstaller(plugin_id, resource_prefix, listener);
    }
}

