/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.shells.main;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManagerFactory;
import com.aelitis.azureus.core.util.FeatureAvailability;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.mdi.MdiChildCloseListener;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MdiEntryCreationListener;
import com.aelitis.azureus.ui.mdi.MdiListener;
import com.aelitis.azureus.ui.mdi.MultipleDocumentInterface;
import com.aelitis.azureus.ui.swt.feature.FeatureManagerUI;
import com.aelitis.azureus.ui.swt.mdi.BaseMdiEntry;
import com.aelitis.azureus.ui.swt.views.skin.SBC_ActivityTableView;
import com.aelitis.azureus.ui.swt.views.skin.SBC_PlusFTUX;
import com.aelitis.azureus.ui.swt.views.skin.SB_Transfers;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.ContentNetworkUtils;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.impl.ConfigurationChecker;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.ui.swt.Utils;

public class MainMDISetup {
    public static void setupSideBar(final MultipleDocumentInterface mdi, final MdiListener l) {
        if (Utils.isAZ2UI()) {
            MainMDISetup.setupSidebarClassic(mdi);
        } else {
            MainMDISetup.setupSidebarVuze(mdi);
        }
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                String startTab;
                ContentNetwork startupCN;
                String CFG_STARTTAB = "v3.StartTab";
                boolean showWelcome = COConfigurationManager.getBooleanParameter("v3.Show Welcome");
                if (ConfigurationChecker.isNewVersion()) {
                    showWelcome = true;
                }
                if (!(startupCN = ContentNetworkManagerFactory.getSingleton().getStartupContentNetwork()).isServiceSupported(8)) {
                    showWelcome = false;
                }
                if (showWelcome) {
                    startTab = "Welcome";
                } else {
                    if (!COConfigurationManager.hasParameter("v3.StartTab", true)) {
                        COConfigurationManager.setParameter("v3.StartTab", "Library");
                    }
                    startTab = COConfigurationManager.getStringParameter("v3.StartTab");
                    MultipleDocumentInterface mdi2 = UIFunctionsManager.getUIFunctions().getMDI();
                    if (mdi2 == null || mdi2.getEntry(startTab) == null) {
                        startTab = "Library";
                    }
                }
                if (startTab.equals("Plus")) {
                    SBC_PlusFTUX.setSourceRef("lastview");
                }
                mdi.showEntryByID(startTab);
                if (l != null) {
                    mdi.addListener(l);
                }
            }
        });
        COConfigurationManager.addAndFireParameterListener("Beta Programme Enabled", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                boolean enabled = COConfigurationManager.getBooleanParameter("Beta Programme Enabled");
                if (enabled) {
                    mdi.showEntryByID("BetaProgramme");
                }
            }
        });
        mdi.registerEntry("BetaProgramme", new MdiEntryCreationListener(){

            public MdiEntry createMDiEntry(String id) {
                MdiEntry entry = mdi.createEntryFromSkinRef("header.vuze", "BetaProgramme", "main.area.beta", "{Sidebar.beta.title}", null, null, true, "");
                return entry;
            }
        });
    }

    private static void setupSidebarClassic(final MultipleDocumentInterface mdi) {
        mdi.registerEntry("Library", new MdiEntryCreationListener(){

            public MdiEntry createMDiEntry(String id) {
                boolean uiClassic = COConfigurationManager.getStringParameter("ui").equals("az2");
                String title = uiClassic ? "{MyTorrentsView.mytorrents}" : "{sidebar.Library}";
                MdiEntry entry = mdi.createEntryFromSkinRef(null, "Library", "library", title, null, null, false, "");
                entry.setImageLeftID("image.sidebar.library");
                return entry;
            }
        });
        mdi.showEntryByID("Library");
    }

    private static void setupSidebarVuze(final MultipleDocumentInterface mdi) {
        String[] preferredOrder = new String[]{"header.vuze", "header.transfers", "header.devices", "header.subscriptions", "header.dvd", "header.plugins"};
        mdi.setPreferredOrder(preferredOrder);
        boolean[] disableCollapses = new boolean[]{true, true, false, false, false, false};
        for (int i = 0; i < preferredOrder.length; ++i) {
            String id = preferredOrder[i];
            final boolean disableCollapse = disableCollapses[i];
            mdi.registerEntry(id, new MdiEntryCreationListener(){

                public MdiEntry createMDiEntry(String id) {
                    MdiEntry entry = mdi.createHeader(id, "sidebar." + id, null);
                    if (disableCollapse) {
                        entry.setCollapseDisabled(true);
                    } else {
                        entry.setDefaultExpanded(true);
                    }
                    if (id.equals("header.plugins")) {
                        entry.addListener(new MdiChildCloseListener(){

                            public void mdiChildEntryClosed(MdiEntry parent, MdiEntry child, boolean user) {
                                if (mdi.getChildrenOf(parent.getId()).size() == 0) {
                                    parent.close(true);
                                }
                            }
                        });
                    }
                    return entry;
                }
            });
        }
        mdi.loadEntryByID("Library", false);
        mdi.loadEntryByID("LibraryUnopened", false);
        mdi.loadEntryByID("Subscriptions", false);
        mdi.loadEntryByID("Devices", false);
        MdiEntry entry = mdi.createEntryFromSkinRef("header.vuze", ContentNetworkUtils.getTarget(ConstantsVuze.getDefaultContentNetwork()), "main.area.browsetab", "{sidebar.VuzeHDNetwork}", null, null, false, null);
        entry.setImageLeftID("image.sidebar.vuze");
        if (Constants.isWindows && FeatureAvailability.isGamesEnabled()) {
            mdi.registerEntry("Games", new MdiEntryCreationListener(){

                public MdiEntry createMDiEntry(String id) {
                    MdiEntry entry = mdi.createEntryFromSkinRef("header.vuze", "Games", "main.generic.browse", "{mdi.entry.games}", null, null, true, null);
                    ((BaseMdiEntry)entry).setPreferredAfterID(ContentNetworkUtils.getTarget(ConstantsVuze.getDefaultContentNetwork()));
                    String url = ConstantsVuze.getDefaultContentNetwork().getSiteRelativeURL("starts/games.start", false);
                    entry.setDatasource(url);
                    entry.setImageLeftID("image.sidebar.games");
                    return entry;
                }
            });
            mdi.loadEntryByID("Games", false, true);
        }
        mdi.registerEntry("About.Plugins", new MdiEntryCreationListener(){

            public MdiEntry createMDiEntry(String id) {
                MdiEntry entry = mdi.createEntryFromSkinRef("header.plugins", "About.Plugins", "main.generic.browse", "{mdi.entry.about.plugins}", null, null, true, "");
                String url = ConstantsVuze.getDefaultContentNetwork().getSiteRelativeURL("plugins", true);
                entry.setDatasource(url);
                entry.setImageLeftID("image.sidebar.plugin");
                return entry;
            }
        });
        final int burnInfoShown = COConfigurationManager.getIntParameter("burninfo.shown", 0);
        if (burnInfoShown == 0) {
            AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

                public void azureusCoreRunning(AzureusCore core) {
                    Utils.execSWTThread(new AERunnable(){

                        public void runSupport() {
                            if (FeatureManagerUI.enabled) {
                                mdi.loadEntryByID("Plus", false);
                                if (!FeatureManagerUI.hasFullBurn()) {
                                    mdi.loadEntryByID("BurnInfo", false);
                                }
                                COConfigurationManager.setParameter("burninfo.shown", burnInfoShown + 1);
                            }
                        }
                    });
                }
            });
        }
        SBC_ActivityTableView.setupSidebarEntry();
        SB_Transfers.setup(mdi);
    }
}

