/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.shells;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.pairing.PairingException;
import com.aelitis.azureus.core.pairing.PairingManager;
import com.aelitis.azureus.core.pairing.PairingManagerFactory;
import com.aelitis.azureus.core.pairing.PairingManagerListener;
import com.aelitis.azureus.core.pairing.PairingTest;
import com.aelitis.azureus.core.pairing.PairingTestListener;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectButton;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectImage;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText_UrlClickedListener;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import com.aelitis.azureus.ui.swt.utils.FontUtils;
import com.aelitis.azureus.ui.swt.views.skin.SkinnedDialog;
import com.aelitis.azureus.util.StringCompareUtils;
import java.util.HashMap;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.installer.InstallablePlugin;
import org.gudy.azureus2.plugins.installer.PluginInstallationListener;
import org.gudy.azureus2.plugins.installer.PluginInstaller;
import org.gudy.azureus2.plugins.installer.StandardPlugin;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.ClipboardCopy;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.shells.CoreWaiterSWT;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;

public class RemotePairingWindow
implements PairingManagerListener {
    private static final String PLUGINID_WEBUI = "xmwebui";
    private static final boolean SHOW_SPEW = false;
    private static final boolean DEBUG = false;
    static RemotePairingWindow instance = null;
    private SkinnedDialog skinnedDialog;
    private SWTSkin skin;
    private SWTSkinObjectButton soEnablePairing;
    private PairingManager pairingManager;
    private SWTSkinObject soCodeArea;
    private Font fontCode;
    private String accessCode;
    private Control control;
    private SWTSkinObjectText soStatusText;
    private SWTSkinObject soFTUX;
    private SWTSkinObject soCode;
    private SWTSkinObjectText soToClipboard;
    private boolean hideCode = true;
    private String fallBackStatusText = "";
    private static testPairingClass testPairingClass;
    private PairingTest pairingTest;
    private boolean alreadyTested;
    private String storedToClipboardText;
    private String lastPairingTestError;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void open() {
        Class<RemotePairingWindow> clazz = RemotePairingWindow.class;
        synchronized (RemotePairingWindow.class) {
            if (instance == null) {
                instance = new RemotePairingWindow();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.SWT_THREAD, new AzureusCoreRunningListener(){

                public void azureusCoreRunning(AzureusCore core) {
                    instance._open();
                }
            });
            return;
        }
    }

    private PluginInterface getWebUI() {
        return AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID(PLUGINID_WEBUI, true);
    }

    private void _open() {
        boolean showFTUX;
        this.alreadyTested = false;
        this.pairingManager = PairingManagerFactory.getSingleton();
        PluginInterface piWebUI = this.getWebUI();
        boolean bl = showFTUX = piWebUI == null || !this.pairingManager.isEnabled();
        if (this.skinnedDialog == null || this.skinnedDialog.isDisposed()) {
            this.skinnedDialog = new SkinnedDialog("skin3_dlg_remotepairing", "shell", 2144);
            this.skin = this.skinnedDialog.getSkin();
            this.soCodeArea = this.skin.getSkinObject("code-area");
            this.control = this.soCodeArea.getControl();
            this.soEnablePairing = (SWTSkinObjectButton)this.skin.getSkinObject("enable-pairing");
            this.soEnablePairing.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    skinObject.getControl().setEnabled(false);
                    if (!RemotePairingWindow.this.pairingManager.isEnabled()) {
                        RemotePairingWindow.this.pairingManager.setEnabled(true);
                    } else {
                        RemotePairingWindow.this.somethingChanged(RemotePairingWindow.this.pairingManager);
                    }
                    if (RemotePairingWindow.this.getWebUI() == null) {
                        RemotePairingWindow.this.installWebUI();
                    } else {
                        RemotePairingWindow.this.switchToCode();
                    }
                }
            });
            this.soFTUX = this.skin.getSkinObject("pairing-ftux");
            this.soCode = this.skin.getSkinObject("pairing-code");
            this.soStatusText = (SWTSkinObjectText)this.skin.getSkinObject("status-text");
            this.soStatusText.addUrlClickedListener(new SWTSkinObjectText_UrlClickedListener(){

                public boolean urlClicked(GCStringPrinter.URLInfo urlInfo) {
                    if (urlInfo.url.equals("retry")) {
                        RemotePairingWindow.this.alreadyTested = false;
                        RemotePairingWindow.this.testPairing(false);
                        return true;
                    }
                    return false;
                }
            });
            this.pairingManager.addListener(this);
            Font font = this.control.getFont();
            GC gc = new GC(this.control);
            this.fontCode = FontUtils.getFontWithHeight(font, gc, Constants.isWindows ? 20 : 18, 1);
            gc.dispose();
            this.control.setFont(this.fontCode);
            this.control.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    Color oldColor = e.gc.getForeground();
                    Rectangle printArea = ((Composite)e.widget).getClientArea();
                    int fullWidth = printArea.width;
                    int fullHeight = printArea.height;
                    GCStringPrinter sp = new GCStringPrinter(e.gc, MessageText.getString("remote.pairing.accesscode"), printArea, false, false, 0);
                    sp.calculateMetrics();
                    Point sizeAccess = sp.getCalculatedSize();
                    String drawAccessCode = RemotePairingWindow.this.accessCode == null ? "      " : RemotePairingWindow.this.accessCode;
                    int numBoxes = drawAccessCode == null ? 0 : drawAccessCode.length();
                    int boxSize = 25;
                    int boxSizeAndPadding = 30;
                    int allBoxesWidth = numBoxes * boxSizeAndPadding;
                    int textPadding = 15;
                    printArea.x = (fullWidth - (allBoxesWidth + sizeAccess.x + textPadding)) / 2;
                    printArea.width = sizeAccess.x;
                    sp.printString(e.gc, printArea, 0);
                    e.gc.setBackground(Colors.white);
                    e.gc.setForeground(Colors.blue);
                    int xStart = printArea.x + sizeAccess.x + textPadding;
                    int yStart = (fullHeight - boxSize) / 2;
                    for (int i = 0; i < numBoxes; ++i) {
                        Rectangle r = new Rectangle(xStart + i * boxSizeAndPadding, yStart, boxSize, boxSize);
                        e.gc.fillRectangle(r);
                        e.gc.setForeground(Colors.blues[9]);
                        e.gc.drawRectangle(r);
                        if (RemotePairingWindow.this.hideCode) continue;
                        e.gc.setForeground(oldColor);
                        GCStringPrinter.printString(e.gc, "" + drawAccessCode.charAt(i), r, false, false, 0x1000000);
                    }
                }
            });
            this.soToClipboard = (SWTSkinObjectText)this.skin.getSkinObject("pair-clipboard");
            this.soToClipboard.addUrlClickedListener(new SWTSkinObjectText_UrlClickedListener(){

                public boolean urlClicked(GCStringPrinter.URLInfo urlInfo) {
                    if (urlInfo.url.equals("new")) {
                        try {
                            RemotePairingWindow.this.accessCode = RemotePairingWindow.this.pairingManager.getReplacementAccessCode();
                        }
                        catch (PairingException e) {
                            // empty catch block
                        }
                        RemotePairingWindow.this.control.redraw();
                        String s = RemotePairingWindow.this.soToClipboard.getText();
                        int i = s.indexOf("|");
                        if (i > 0) {
                            RemotePairingWindow.this.soToClipboard.setText(s.substring(0, i - 1));
                        }
                    } else if (urlInfo.url.equals("clip")) {
                        ClipboardCopy.copyToClipBoard(RemotePairingWindow.this.accessCode);
                    }
                    return true;
                }
            });
            SWTSkinButtonUtility btnToClipboard = new SWTSkinButtonUtility(this.soToClipboard);
            btnToClipboard.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                }
            });
            this.skinnedDialog.addCloseListener(new SkinnedDialog.SkinnedDialogClosedListener(){

                public void skinDialogClosed(SkinnedDialog dialog) {
                    RemotePairingWindow.this.skinnedDialog = null;
                    RemotePairingWindow.this.pairingManager.removeListener(RemotePairingWindow.this);
                    Utils.disposeSWTObjects(new Object[]{RemotePairingWindow.this.fontCode});
                    if (RemotePairingWindow.this.pairingTest != null) {
                        RemotePairingWindow.this.pairingTest.cancel();
                    }
                }
            });
            if (showFTUX) {
                this.soFTUX.getControl().moveAbove(null);
            }
        }
        this.hideCode = true;
        this.skinnedDialog.open();
        this.hideCode = false;
        if (showFTUX) {
            this.switchToFTUX();
        } else {
            this.switchToCode();
        }
    }

    public void switchToFTUX() {
        SWTSkinObject soPairInstallArea = this.skin.getSkinObject("pair-install");
        if (soPairInstallArea != null) {
            soPairInstallArea.getControl().moveAbove(null);
        }
        this.soFTUX.setVisible(true);
        this.soCode.setVisible(false);
    }

    public void switchToCode() {
        this.somethingChanged(this.pairingManager);
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                SWTSkinObject soPairArea;
                if (RemotePairingWindow.this.skinnedDialog == null || RemotePairingWindow.this.skinnedDialog.isDisposed()) {
                    return;
                }
                SWTSkinObjectImage soImage = (SWTSkinObjectImage)RemotePairingWindow.this.skin.getSkinObject("status-image");
                if (soImage != null) {
                    soImage.setImageByID("icon.spin", null);
                }
                if ((soPairArea = RemotePairingWindow.this.skin.getSkinObject("reset-pair-area")) != null) {
                    soPairArea.getControl().moveAbove(null);
                }
                RemotePairingWindow.this.soFTUX.setVisible(false);
                RemotePairingWindow.this.soCode.setVisible(true);
            }
        });
    }

    protected void testPairing(boolean delay) {
        if (this.alreadyTested) {
            return;
        }
        this.lastPairingTestError = "";
        this.alreadyTested = true;
        this.storedToClipboardText = this.soToClipboard.getText();
        try {
            this.hideCode = true;
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    RemotePairingWindow.this.control.redraw();
                    SWTSkinObjectImage soImage = (SWTSkinObjectImage)RemotePairingWindow.this.skin.getSkinObject("status-image");
                    if (soImage != null) {
                        soImage.setImageByID("icon.spin", null);
                    }
                }
            });
            this.soStatusText.setTextID("remote.pairing.test.running");
            this.soStatusText.setTextColor(ColorCache.getColor((Device)this.control.getDisplay(), "#000000"));
            this.soToClipboard.setText(" ");
            final PairingTestListener testListener = new PairingTestListener(){

                public void testStarted(PairingTest test) {
                }

                public void testComplete(PairingTest test) {
                    if (RemotePairingWindow.this.skinnedDialog.isDisposed()) {
                        return;
                    }
                    int outcome = test.getOutcome();
                    String iconID = null;
                    String colorID = "#000000";
                    switch (outcome) {
                        case 1: {
                            RemotePairingWindow.this.fallBackStatusText = MessageText.getString("remote.pairing.test.success");
                            iconID = "icon.success";
                            colorID = "#007305";
                            break;
                        }
                        case 6: {
                            RemotePairingWindow.this.fallBackStatusText = test.getErrorMessage();
                            iconID = "icon.warning";
                            colorID = "#A97000";
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            RemotePairingWindow.this.fallBackStatusText = MessageText.getString("remote.pairing.test.unavailable", new String[]{test.getErrorMessage()});
                            iconID = "icon.warning";
                            colorID = "#C98000";
                            break;
                        }
                        default: {
                            RemotePairingWindow.this.fallBackStatusText = MessageText.getString("remote.pairing.test.fail", new String[]{test.getErrorMessage()});
                            iconID = "icon.failure";
                            colorID = "#c90000";
                        }
                    }
                    RemotePairingWindow.this.hideCode = false;
                    final String fIconID = iconID;
                    RemotePairingWindow.this.somethingChanged(RemotePairingWindow.this.pairingManager);
                    RemotePairingWindow.this.lastPairingTestError = RemotePairingWindow.this.pairingTest.getErrorMessage();
                    Utils.execSWTThread(new AERunnable(){

                        public void runSupport() {
                            RemotePairingWindow.this.control.redraw();
                            SWTSkinObjectImage soImage = (SWTSkinObjectImage)RemotePairingWindow.this.skin.getSkinObject("status-image");
                            if (soImage != null) {
                                soImage.setImageByID(fIconID, null);
                            }
                        }
                    });
                    RemotePairingWindow.this.updateToolTip();
                    RemotePairingWindow.this.soStatusText.setText(RemotePairingWindow.this.fallBackStatusText);
                    RemotePairingWindow.this.soStatusText.setTextColor(ColorCache.getColor((Device)RemotePairingWindow.this.control.getDisplay(), colorID));
                    RemotePairingWindow.this.soToClipboard.setText(RemotePairingWindow.this.storedToClipboardText);
                }
            };
            SimpleTimer.addEvent("testPairing", SystemTime.getOffsetTime(delay ? 5000L : 0L), new TimerEventPerformer(){

                public void perform(TimerEvent event2) {
                    try {
                        RemotePairingWindow.this.pairingTest = RemotePairingWindow.this.pairingManager.testService(RemotePairingWindow.PLUGINID_WEBUI, testListener);
                    }
                    catch (PairingException e) {
                        RemotePairingWindow.this.finishFailedTest();
                        RemotePairingWindow.this.soStatusText.setText(Debug.getNestedExceptionMessage(e));
                        Debug.out(e);
                    }
                    if (RemotePairingWindow.this.pairingTest == null) {
                        RemotePairingWindow.this.finishFailedTest();
                    }
                }
            });
        }
        catch (Exception e) {
            this.finishFailedTest();
            this.soStatusText.setText(Debug.getNestedExceptionMessage(e));
            Debug.out(e);
        }
    }

    protected void updateToolTip() {
        SWTSkinObjectImage soImage = (SWTSkinObjectImage)this.skin.getSkinObject("status-image");
        if (soImage != null) {
            String lastPairingErr;
            String status;
            String s = this.lastPairingTestError;
            if (s == null) {
                s = "";
            }
            if ((status = this.pairingManager.getStatus()) != null && status.length() > 0) {
                if (s.length() > 0) {
                    s = s + "\n";
                }
                s = s + "Pairing Status: " + status;
            }
            if ((lastPairingErr = this.pairingManager.getLastServerError()) != null && lastPairingErr.length() > 0) {
                if (s.length() > 0) {
                    s = s + "\n";
                }
                s = s + "Pairing Error: " + lastPairingErr;
            }
            soImage.setTooltipID("!" + s + "!");
        }
    }

    private void finishFailedTest() {
        this.hideCode = false;
        this.somethingChanged(this.pairingManager);
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                RemotePairingWindow.this.control.redraw();
            }
        });
        if (this.storedToClipboardText != null && this.storedToClipboardText.length() > 0) {
            this.soToClipboard.setText(this.storedToClipboardText);
        }
    }

    protected void installWebUI() {
        PluginInstaller installer = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInstaller();
        StandardPlugin vuze_plugin = null;
        try {
            vuze_plugin = installer.getStandardPlugin(PLUGINID_WEBUI);
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (vuze_plugin == null) {
            return;
        }
        if (vuze_plugin.isAlreadyInstalled()) {
            PluginInterface plugin = vuze_plugin.getAlreadyInstalledPlugin();
            plugin.getPluginState().setDisabled(false);
            return;
        }
        try {
            this.switchToFTUX();
            SWTSkinObject soInstall = this.skin.getSkinObject("pairing-install");
            final SWTSkinObject soLearnMore = this.skin.getSkinObject("learn-more");
            if (soLearnMore != null) {
                soLearnMore.setVisible(false);
            }
            HashMap<Integer, Object> properties = new HashMap<Integer, Object>();
            properties.put(1, 2);
            properties.put(2, soInstall.getControl());
            properties.put(3, true);
            installer.install(new InstallablePlugin[]{vuze_plugin}, false, properties, new PluginInstallationListener(){

                public void completed() {
                    if (soLearnMore != null) {
                        soLearnMore.setVisible(true);
                    }
                    RemotePairingWindow.this.switchToCode();
                }

                public void cancelled() {
                    Utils.execSWTThread(new AERunnable(){

                        public void runSupport() {
                            if (RemotePairingWindow.this.skinnedDialog != null && !RemotePairingWindow.this.skinnedDialog.isDisposed()) {
                                RemotePairingWindow.this.skinnedDialog.close();
                                RemotePairingWindow.this.skinnedDialog = null;
                            }
                        }
                    });
                }

                public void failed(PluginException e) {
                    Debug.out(e);
                }
            });
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public void somethingChanged(PairingManager pm) {
        boolean newAccessCode;
        if (this.skinnedDialog.isDisposed()) {
            return;
        }
        this.updateToolTip();
        String lastAccessCode = this.accessCode;
        this.accessCode = this.pairingManager.peekAccessCode();
        boolean bl = newAccessCode = !StringCompareUtils.equals(lastAccessCode, this.accessCode);
        if (this.accessCode != null && this.getWebUI() != null && !this.alreadyTested && !pm.hasActionOutstanding()) {
            if (newAccessCode) {
                this.testPairing(true);
            } else {
                this.testPairing(false);
            }
        }
        if (newAccessCode) {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    RemotePairingWindow.this.control.redraw();
                }
            });
        }
    }

    public static class testPairingClass
    implements PairingTest {
        int curOutcome = 0;
        int[] testOutcomes = new int[]{1, 2, 6, 5, 4, 3};
        String[] testErrs = new String[]{"Success", "Could Not Connect blah blah technical stuff", "You Cancelled (unpossible!)", "Server Failed", "Server Overloaded", "Server Unavailable"};

        public void inc() {
            ++this.curOutcome;
            if (this.curOutcome == this.testOutcomes.length) {
                this.curOutcome = 0;
            }
        }

        public int getOutcome() {
            return this.testOutcomes[this.curOutcome];
        }

        public String getErrorMessage() {
            return this.testErrs[this.curOutcome];
        }

        public void cancel() {
        }
    }
}

