/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.shells;

import com.aelitis.azureus.core.messenger.ClientMessageContext;
import com.aelitis.azureus.ui.swt.browser.BrowserContext;
import com.aelitis.azureus.ui.swt.browser.listener.ConfigListener;
import com.aelitis.azureus.ui.swt.browser.listener.DisplayListener;
import com.aelitis.azureus.ui.swt.browser.listener.TorrentListener;
import com.aelitis.azureus.ui.swt.browser.listener.VuzeListener;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;

public class BrowserWindow {
    private Shell shell;
    private ClientMessageContext context;
    private Browser browser;

    public BrowserWindow(Shell parent, String url, double wPct, double hPct, boolean allowResize, boolean isModal) {
        if (parent == null) {
            this.init(parent, url, 0, 0, allowResize, isModal);
        } else {
            Rectangle clientArea = parent.getClientArea();
            this.init(parent, url, (int)((double)clientArea.width * wPct), (int)((double)clientArea.height * hPct), allowResize, isModal);
        }
    }

    public BrowserWindow(Shell parent, String url, int w, int h, boolean allowResize, boolean isModal) {
        this.init(parent, url, w, h, allowResize, isModal);
    }

    public void init(Shell parent, String url, int w, int h, boolean allowResize, boolean isModal) {
        int style = 2144;
        if (allowResize) {
            style |= 0x10;
        }
        if (isModal) {
            style |= 0x10000;
        }
        this.shell = ShellFactory.createShell(parent, style);
        this.shell.setLayout(new FillLayout());
        Utils.setShellIcon(this.shell);
        this.shell.setText(url);
        this.shell.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    BrowserWindow.this.shell.dispose();
                    e.doit = false;
                }
            }
        });
        final Listener escListener = new Listener(){

            public void handleEvent(Event event2) {
                if (event2.keyCode == 27) {
                    BrowserWindow.this.shell.dispose();
                }
            }
        };
        this.shell.getDisplay().addFilter(1, escListener);
        this.shell.addListener(12, new Listener(){

            public void handleEvent(Event event2) {
                event2.display.removeFilter(1, escListener);
            }
        });
        this.browser = Utils.createSafeBrowser(this.shell, 0);
        if (this.browser == null) {
            this.shell.dispose();
            return;
        }
        this.context = new BrowserContext("browser-window" + Math.random(), this.browser, null, true);
        this.context.addMessageListener(new TorrentListener());
        this.context.addMessageListener(new VuzeListener());
        this.context.addMessageListener(new DisplayListener(this.browser));
        this.context.addMessageListener(new ConfigListener(this.browser));
        this.browser.addProgressListener(new ProgressListener(){

            public void completed(ProgressEvent event2) {
                if (BrowserWindow.this.browser.isDisposed() || BrowserWindow.this.browser.getShell().isDisposed()) {
                    return;
                }
                BrowserWindow.this.shell.open();
            }

            public void changed(ProgressEvent event2) {
            }
        });
        this.browser.addCloseWindowListener(new CloseWindowListener(){

            public void close(WindowEvent event2) {
                if (BrowserWindow.this.browser.isDisposed() || BrowserWindow.this.browser.getShell().isDisposed()) {
                    return;
                }
                BrowserWindow.this.context.debug("window.close called");
                BrowserWindow.this.shell.dispose();
            }
        });
        this.browser.addTitleListener(new TitleListener(){

            public void changed(TitleEvent event2) {
                if (BrowserWindow.this.browser.isDisposed() || BrowserWindow.this.browser.getShell().isDisposed()) {
                    return;
                }
                BrowserWindow.this.shell.setText(event2.title);
            }
        });
        this.browser.addStatusTextListener(new StatusTextListener(){

            public void changed(StatusTextEvent event2) {
                if (BrowserWindow.this.browser.isDisposed() || BrowserWindow.this.browser.getShell().isDisposed()) {
                    return;
                }
                if ("__VUZE__MessageBoxShell__CLOSE".equals(event2.text)) {
                    Utils.execSWTThreadLater(0, new Runnable(){

                        public void run() {
                            if (!BrowserWindow.this.browser.isDisposed() && !BrowserWindow.this.shell.isDisposed()) {
                                BrowserWindow.this.shell.close();
                            }
                        }
                    });
                }
            }
        });
        SimpleTimer.addEvent("showWin", SystemTime.getOffsetTime(3000L), new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        if (BrowserWindow.this.shell != null && !BrowserWindow.this.shell.isDisposed()) {
                            BrowserWindow.this.shell.open();
                        }
                    }
                });
            }
        });
        if (w > 0 && h > 0) {
            Rectangle computeTrim = this.shell.computeTrim(0, 0, w, h);
            this.shell.setSize(computeTrim.width, computeTrim.height);
        }
        Utils.centerWindowRelativeTo(this.shell, parent);
        this.browser.setUrl(url);
        this.browser.setData("StartURL", url);
    }

    public void waitUntilClosed() {
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public ClientMessageContext getContext() {
        return this.context;
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display, 2144);
        new BrowserWindow(shell, "http://google.com", 500, 200, true, false);
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }
}

