/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.plugininstall;

import com.aelitis.azureus.ui.UserPrompterResultListener;
import com.aelitis.azureus.ui.swt.plugininstall.SimplePluginInstaller;
import com.aelitis.azureus.ui.swt.plugininstall.SimplePluginInstallerListener;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.views.skin.VuzeMessageBox;
import com.aelitis.azureus.ui.swt.views.skin.VuzeMessageBoxListener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.ui.swt.Utils;

public class SimplePluginInstallWindow
implements SimplePluginInstallerListener {
    private static final boolean FAKE_DELAY = Constants.IS_CVS_VERSION;
    private VuzeMessageBox box;
    private ProgressBar progressBar;
    private SWTSkinObjectText soProgressText;
    private String progressText;
    private SWTSkinObjectText soInstallPct;
    private SimplePluginInstaller installer;
    private String resource_prefix;

    public SimplePluginInstallWindow(SimplePluginInstaller _installer, String _resource_prefix) {
        this.installer = _installer;
        this.resource_prefix = _resource_prefix;
        this.installer.setListener(this);
    }

    public void open() {
        this.box = new VuzeMessageBox("", "", null, 0);
        this.box.setSubTitle(MessageText.getString(this.resource_prefix + ".subtitle"));
        this.box.addResourceBundle(SimplePluginInstallWindow.class, "com/aelitis/azureus/ui/skin/", "skin3_dlg_register");
        this.box.setIconResource(this.resource_prefix + ".image");
        this.progressText = MessageText.getString(this.resource_prefix + ".description");
        this.box.setListener(new VuzeMessageBoxListener(){

            public void shellReady(Shell shell, SWTSkinObjectContainer soExtra) {
                SWTSkin skin = soExtra.getSkin();
                skin.createSkinObject("dlg.register.install", "dlg.register.install", soExtra);
                SWTSkinObjectContainer soProgressBar = (SWTSkinObjectContainer)skin.getSkinObject("progress-bar");
                if (soProgressBar != null) {
                    SimplePluginInstallWindow.this.progressBar = new ProgressBar(soProgressBar.getComposite(), 256);
                    SimplePluginInstallWindow.this.progressBar.setMinimum(0);
                    SimplePluginInstallWindow.this.progressBar.setMaximum(100);
                    SimplePluginInstallWindow.this.progressBar.setLayoutData(Utils.getFilledFormData());
                }
                SimplePluginInstallWindow.this.soInstallPct = (SWTSkinObjectText)skin.getSkinObject("install-pct");
                SimplePluginInstallWindow.this.soProgressText = (SWTSkinObjectText)skin.getSkinObject("progress-text");
                if (SimplePluginInstallWindow.this.soProgressText != null && SimplePluginInstallWindow.this.progressText != null) {
                    SimplePluginInstallWindow.this.soProgressText.setText(SimplePluginInstallWindow.this.progressText);
                }
            }
        });
        this.box.open(new UserPrompterResultListener(){

            public void prompterClosed(int result) {
                SimplePluginInstallWindow.this.installer.setListener(null);
                SimplePluginInstallWindow.this.installer.cancel();
            }
        });
    }

    public void failed(Throwable e) {
        if (this.box != null) {
            this.box.close(0);
        }
    }

    public void finished() {
        if (this.box != null) {
            this.box.close(0);
        }
    }

    public void progress(final int percent) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                int pct;
                int n = pct = percent == 100 ? 99 : percent;
                if (SimplePluginInstallWindow.this.soInstallPct != null) {
                    SimplePluginInstallWindow.this.soInstallPct.setText(MessageText.getString("dlg.auth.install.pct", new String[]{"" + pct}));
                }
                if (SimplePluginInstallWindow.this.progressBar != null && !SimplePluginInstallWindow.this.progressBar.isDisposed()) {
                    SimplePluginInstallWindow.this.progressBar.setSelection(pct);
                }
            }
        });
    }
}

