/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.mdi;

import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo;
import com.aelitis.azureus.ui.mdi.MdiEntryVitalityImage;
import com.aelitis.azureus.ui.swt.mdi.BaseMdiEntry;
import com.aelitis.azureus.ui.swt.mdi.MdiSWTMenuHackListener;
import com.aelitis.azureus.ui.swt.mdi.TabbedMDI;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import java.lang.reflect.Constructor;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCore;
import org.gudy.azureus2.ui.swt.views.IView;

public class TabbedEntry
extends BaseMdiEntry
implements DisposeListener {
    private CTabItem swtItem;
    private SWTSkin skin;
    private boolean showonSWTItemSet;
    private boolean buildonSWTItemSet;
    private static long uniqueNumber = 0L;

    public TabbedEntry(TabbedMDI mdi, SWTSkin skin, String id) {
        super(mdi, id);
        this.skin = skin;
    }

    public void build() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                TabbedEntry.this.swt_build();
                TabbedEntry.super.build();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean swt_build() {
        if (this.swtItem == null) {
            this.buildonSWTItemSet = true;
            return true;
        }
        this.buildonSWTItemSet = false;
        Control control = this.swtItem.getControl();
        if (control == null) {
            block24: {
                CTabFolder parent = this.swtItem.getParent();
                SWTSkinObject soParent = (SWTSkinObject)parent.getData("SkinObject");
                String skinRef = this.getSkinRef();
                if (skinRef != null) {
                    Shell shell = parent.getShell();
                    Cursor cursor = shell.getCursor();
                    try {
                        shell.setCursor(shell.getDisplay().getSystemCursor(1));
                        SWTSkinObject skinObject = this.skin.createSkinObject(this.id, skinRef, soParent, this.getDatasourceCore());
                        control = skinObject.getControl();
                        control.setLayoutData(Utils.getFilledFormData());
                        control.getParent().layout(true);
                        CTabItem oldSelection = this.swtItem.getParent().getSelection();
                        this.swtItem.getParent().setSelection(this.swtItem);
                        this.swtItem.setControl(control);
                        if (oldSelection != null) {
                            this.swtItem.getParent().setSelection(oldSelection);
                        }
                        this.setSkinObject(skinObject, skinObject);
                        Object var10_17 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_18 = null;
                        shell.setCursor(cursor);
                        throw throwable;
                    }
                    shell.setCursor(cursor);
                    {
                        break block24;
                    }
                }
                if (this.iview != null) {
                    try {
                        UISWTView swtView;
                        SWTSkinObjectContainer soContents = (SWTSkinObjectContainer)this.skin.createSkinObject("MdiIView." + uniqueNumber++, "mdi.content.item", soParent);
                        this.skin.addSkinObject(soContents);
                        parent.setBackgroundMode(0);
                        Composite viewComposite = soContents.getComposite();
                        boolean doGridLayout = true;
                        if (this.iview instanceof UISWTView && (swtView = (UISWTView)((Object)this.iview)).getControlType() == 257) {
                            doGridLayout = false;
                        }
                        if (doGridLayout) {
                            GridLayout gridLayout = new GridLayout();
                            gridLayout.marginWidth = 0;
                            gridLayout.marginHeight = 0;
                            gridLayout.verticalSpacing = 0;
                            gridLayout.horizontalSpacing = 0;
                            viewComposite.setLayout(gridLayout);
                            viewComposite.setLayoutData(Utils.getFilledFormData());
                        }
                        if (this.iview instanceof UISWTViewCore) {
                            UISWTViewCore uiViewCore = (UISWTViewCore)((Object)this.iview);
                            uiViewCore.setSkinObject(soContents, soContents.getComposite());
                        }
                        this.iview.initialize(viewComposite);
                        this.setTitle(this.iview.getFullTitle());
                        Composite iviewComposite = this.iview.getComposite();
                        control = iviewComposite;
                        if (doGridLayout) {
                            Object existingLayoutData = iviewComposite.getLayoutData();
                            Object existingParentLayoutData = iviewComposite.getParent().getLayoutData();
                            if (existingLayoutData == null || !(existingLayoutData instanceof GridData) && existingParentLayoutData instanceof GridLayout) {
                                GridData gridData = new GridData(1808);
                                iviewComposite.setLayoutData(gridData);
                            }
                        }
                        CTabItem oldSelection = this.swtItem.getParent().getSelection();
                        this.swtItem.getParent().setSelection(this.swtItem);
                        this.swtItem.setControl(soContents.getControl());
                        if (oldSelection != null) {
                            this.swtItem.getParent().setSelection(oldSelection);
                        }
                        this.setSkinObject(soContents, soContents);
                    }
                    catch (Exception e) {
                        Debug.out("Error creating sidebar content area for " + this.id, e);
                        this.close(true);
                    }
                } else if (this.iviewClass != null) {
                    try {
                        IView view = null;
                        if (this.iviewClassArgs == null) {
                            view = (IView)this.iviewClass.newInstance();
                        } else {
                            Constructor constructor = this.iviewClass.getConstructor(this.iviewClassArgs);
                            view = (IView)constructor.newInstance(this.iviewClassVals);
                        }
                        if (view != null) {
                            this.setIView(view);
                            return this.swt_build();
                        }
                        this.close(true);
                        return false;
                    }
                    catch (Exception e) {
                        Debug.out(e);
                        this.close(true);
                    }
                }
            }
            if (control != null && !control.isDisposed()) {
                control.setData("BaseMDIEntry", this);
                control.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        TabbedEntry.this.close(true);
                    }
                });
            } else {
                return false;
            }
        }
        return true;
    }

    public void show() {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                TabbedEntry.this.swt_show();
            }
        });
    }

    private void swt_show() {
        if (this.swtItem == null) {
            this.showonSWTItemSet = true;
            return;
        }
        this.showonSWTItemSet = false;
        if (!this.swt_build()) {
            return;
        }
        this.triggerOpenListeners();
        if (this.swtItem.getParent().getSelection() != this.swtItem) {
            this.swtItem.getParent().setSelection(this.swtItem);
        }
        super.show();
    }

    public MdiEntryVitalityImage addVitalityImage(String imageID) {
        return null;
    }

    public boolean isCloseable() {
        return true;
    }

    public void setSwtItem(CTabItem swtItem) {
        this.swtItem = swtItem;
        if (swtItem == null) {
            this.setDisposed(true);
            return;
        }
        this.setDisposed(false);
        swtItem.addDisposeListener(this);
        String title = this.getTitle();
        if (title != null) {
            swtItem.setText(this.escapeAccelerators(title));
        } else if (this.iviewClass != null) {
            swtItem.setText(this.iviewClass.getSimpleName());
        }
        if (this.buildonSWTItemSet) {
            this.build();
        }
        if (this.showonSWTItemSet) {
            this.show();
        }
    }

    public Item getSwtItem() {
        return this.swtItem;
    }

    public void setTitle(String title) {
        super.setTitle(title);
        if (this.swtItem != null) {
            this.swtItem.setText(this.escapeAccelerators(title));
        }
    }

    public MdiEntryVitalityImage[] getVitalityImages() {
        return new MdiEntryVitalityImage[0];
    }

    public boolean close(boolean forceClose) {
        if (!super.close(forceClose)) {
            return false;
        }
        Utils.execSWTThread(new Runnable(){

            public void run() {
                if (TabbedEntry.this.swtItem != null && !TabbedEntry.this.swtItem.isDisposed()) {
                    TabbedEntry.this.swtItem.dispose();
                    TabbedEntry.this.swtItem = null;
                } else if (TabbedEntry.this.iview != null) {
                    TabbedEntry.this.iview.delete();
                    TabbedEntry.this.iview = null;
                    TabbedEntry.this.triggerCloseListeners(!SWTThread.getInstance().isTerminated());
                }
            }
        });
        return true;
    }

    public void redraw() {
    }

    public void widgetDisposed(DisposeEvent e) {
        SWTSkinObject so;
        this.setSwtItem(null);
        this.triggerCloseListeners(!SWTThread.getInstance().isTerminated());
        IView iview = this.getIView();
        if (iview != null) {
            this.setIView(null);
            iview.delete();
        }
        if ((so = this.getSkinObject()) != null) {
            this.setSkinObject(null, null);
            so.getSkin().removeSkinObject(so);
        }
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                if (SWTThread.getInstance().isTerminated()) {
                    return;
                }
                try {
                    COConfigurationManager.removeParameter("SideBar.AutoOpen." + TabbedEntry.this.id);
                }
                catch (Exception e2) {
                    Debug.out(e2);
                }
                TabbedEntry.this.mdi.removeItem(TabbedEntry.this);
                TabbedEntry.this.mdi.setEntryAutoOpen(TabbedEntry.this.id, false);
            }
        });
    }

    private String escapeAccelerators(String str) {
        if (str == null) {
            return str;
        }
        return str.replaceAll("&", "&&");
    }

    public void expandTo() {
    }

    public void viewTitleInfoRefresh(ViewTitleInfo titleInfoToRefresh) {
        String newText;
        super.viewTitleInfoRefresh(titleInfoToRefresh);
        if (titleInfoToRefresh == null || this.viewTitleInfo != titleInfoToRefresh) {
            return;
        }
        if (this.isDisposed()) {
            return;
        }
        String textIndicator = null;
        try {
            textIndicator = (String)this.viewTitleInfo.getTitleInfoProperty(0);
        }
        catch (Exception e) {
            Debug.out(e);
        }
        if (textIndicator != null) {
            this.setPullTitleFromIView(false);
        }
        if ((newText = (String)this.viewTitleInfo.getTitleInfoProperty(5)) != null) {
            if (textIndicator != null) {
                newText = newText + " (" + textIndicator + ")";
            }
            this.setPullTitleFromIView(false);
            this.setTitle(newText);
        } else if (this.iview != null) {
            newText = this.iview.getShortTitle();
            if (textIndicator != null) {
                newText = newText + " (" + textIndicator + ")";
            }
            this.setTitle(newText);
        }
    }

    public boolean isSelectable() {
        return true;
    }

    public void setSelectable(boolean selectable) {
    }

    public void addListener(MdiSWTMenuHackListener l) {
    }

    public void removeListener(MdiSWTMenuHackListener l) {
    }
}

