/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.mdi;

import com.aelitis.azureus.ui.common.ToolBarEnabler;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo2;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfoListener;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.aelitis.azureus.ui.mdi.MdiChildCloseListener;
import com.aelitis.azureus.ui.mdi.MdiCloseListener;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MdiEntryDropListener;
import com.aelitis.azureus.ui.mdi.MdiEntryLogIdListener;
import com.aelitis.azureus.ui.mdi.MdiEntryOpenListener;
import com.aelitis.azureus.ui.mdi.MdiEntryVitalityImage;
import com.aelitis.azureus.ui.mdi.MultipleDocumentInterface;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.ui.swt.mdi.MdiEntrySWT;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.impl.ConfigurationDefaults;
import org.gudy.azureus2.core3.config.impl.ConfigurationParameterNotFoundException;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.PluginsMenuHelper;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.BasicPluginViewImpl;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewEventListenerHolder;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewImpl;
import org.gudy.azureus2.ui.swt.views.IView;
import org.gudy.azureus2.ui.swt.views.IViewExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseMdiEntry
implements MdiEntrySWT,
ViewTitleInfoListener {
    protected final MultipleDocumentInterface mdi;
    protected final String id;
    protected String logID;
    protected Object datasource;
    protected Class<?> iviewClass;
    protected Class<?>[] iviewClassArgs;
    protected Object[] iviewClassVals;
    protected IView iview;
    private String skinRef;
    private List<MdiCloseListener> listCloseListeners = null;
    private List<MdiChildCloseListener> listChildCloseListeners = null;
    private List<MdiEntryLogIdListener> listLogIDListeners = null;
    private List<MdiEntryOpenListener> listOpenListeners = null;
    private List<MdiEntryDropListener> listDropListeners = null;
    protected ViewTitleInfo viewTitleInfo;
    private SWTSkinObject skinObject;
    private String title;
    private String titleID;
    private UISWTViewEventListener eventListener;
    private String parentID;
    private boolean pullTitleFromIView;
    private boolean closeable;
    private Boolean isExpanded = null;
    private boolean disposed = false;
    private boolean added = false;
    private String imageLeftID;
    private Image imageLeft;
    private boolean collapseDisabled = false;
    private SWTSkinObject soMaster;
    private Set<ToolBarEnabler> setToolBarEnablers = new HashSet<ToolBarEnabler>(1);
    private String preferredAfterID;

    private BaseMdiEntry() {
        this.mdi = null;
        this.id = null;
        this.setDefaultExpanded(false);
    }

    public BaseMdiEntry(MultipleDocumentInterface mdi, String id) {
        int i;
        this.mdi = mdi;
        this.id = id;
        this.pullTitleFromIView = true;
        this.logID = id == null ? "null" : ((i = id.indexOf(95)) > 0 ? id.substring(0, i) : id);
        this.setDefaultExpanded(false);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public MdiEntryVitalityImage addVitalityImage(String imageID) {
        return null;
    }

    @Override
    public boolean close(boolean forceClose) {
        if (!forceClose && this.iview instanceof UISWTViewImpl && !((UISWTViewImpl)this.iview).requestClose()) {
            return false;
        }
        this.disposed = true;
        ViewTitleInfoManager.removeListener(this);
        return true;
    }

    public Object getDatasourceCore() {
        return this.datasource;
    }

    @Override
    public Object getDatasource() {
        return PluginCoreUtils.convert(this.datasource, false);
    }

    @Override
    public void setDatasource(Object datasource) {
        this.datasource = datasource;
        if (this.isAdded()) {
            if (this.iview != null) {
                this.iview.dataSourceChanged(datasource);
            }
            if (this.skinObject != null) {
                this.skinObject.triggerListeners(7, datasource);
            }
        }
    }

    @Override
    public IView getIView() {
        return this.iview;
    }

    @Override
    public Class<?> getIViewClass() {
        return this.iviewClass;
    }

    public void setIViewClass(Class<?> iviewClass, Class<?>[] iviewClassArgs, Object[] iviewClassVals) {
        this.iviewClass = iviewClass;
        this.iviewClassArgs = iviewClassArgs;
        this.iviewClassVals = iviewClassVals;
    }

    @Override
    public Class<?>[] getIViewClassArgs() {
        return this.iviewClassArgs;
    }

    @Override
    public Object[] getIViewClassVals() {
        return this.iviewClassVals;
    }

    @Override
    public String getLogID() {
        return this.logID;
    }

    @Override
    public MultipleDocumentInterface getMDI() {
        return this.mdi;
    }

    @Override
    public String getParentID() {
        return this.parentID;
    }

    @Override
    public void setParentID(String id) {
        if (id == null || "Tools".equals(id)) {
            id = this.getId().equals("header.dvd") && id == null ? "" : "header.plugins";
        }
        if (id.equals(this.getId())) {
            Debug.out("Setting Parent to same ID as child! " + id);
            return;
        }
        this.parentID = id;
        this.mdi.loadEntryByID(this.parentID, false);
    }

    @Override
    public MdiEntryVitalityImage[] getVitalityImages() {
        return null;
    }

    @Override
    public boolean isCloseable() {
        return this.closeable;
    }

    public boolean isCollapseDisabled() {
        return this.collapseDisabled;
    }

    @Override
    public void setCollapseDisabled(boolean collapseDisabled) {
        this.collapseDisabled = collapseDisabled;
        this.setExpanded(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(MdiCloseListener l) {
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listCloseListeners == null) {
                this.listCloseListeners = new ArrayList<MdiCloseListener>(1);
            }
            this.listCloseListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(MdiCloseListener l) {
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listCloseListeners != null) {
                this.listCloseListeners.remove(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerCloseListeners(boolean user) {
        Object[] list = new Object[]{};
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listCloseListeners != null) {
                list = this.listCloseListeners.toArray();
            }
        }
        for (int i = 0; i < list.length; ++i) {
            MdiCloseListener l = (MdiCloseListener)list[i];
            try {
                l.mdiEntryClosed(this, user);
                continue;
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
        MdiEntry parentEntry = this.mdi.getEntry(this.parentID);
        if (parentEntry instanceof BaseMdiEntry) {
            ((BaseMdiEntry)parentEntry).triggerChildCloseListeners(this, user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(MdiChildCloseListener l) {
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listChildCloseListeners == null) {
                this.listChildCloseListeners = new ArrayList<MdiChildCloseListener>(1);
            }
            this.listChildCloseListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(MdiChildCloseListener l) {
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listChildCloseListeners != null) {
                this.listChildCloseListeners.remove(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerChildCloseListeners(MdiEntry child, boolean user) {
        Object[] list;
        if (this.listChildCloseListeners == null) {
            return;
        }
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            list = this.listChildCloseListeners.toArray();
        }
        for (int i = 0; i < list.length; ++i) {
            MdiChildCloseListener l = (MdiChildCloseListener)list[i];
            try {
                l.mdiChildEntryClosed(this, child, user);
                continue;
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(MdiEntryLogIdListener l) {
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listLogIDListeners == null) {
                this.listLogIDListeners = new ArrayList<MdiEntryLogIdListener>(1);
            }
            this.listLogIDListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(MdiEntryLogIdListener sideBarLogIdListener) {
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listLogIDListeners != null) {
                this.listLogIDListeners.remove(sideBarLogIdListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerLogIDListeners(String oldID) {
        Object[] list;
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listLogIDListeners == null) {
                return;
            }
            list = this.listLogIDListeners.toArray();
        }
        for (int i = 0; i < list.length; ++i) {
            MdiEntryLogIdListener l = (MdiEntryLogIdListener)list[i];
            l.mdiEntryLogIdChanged(this, oldID, this.logID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(MdiEntryOpenListener l) {
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listOpenListeners == null) {
                this.listOpenListeners = new ArrayList<MdiEntryOpenListener>(1);
            }
            this.listOpenListeners.add(l);
        }
        if (this.iview != null) {
            l.mdiEntryOpen(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(MdiEntryOpenListener l) {
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listOpenListeners != null) {
                this.listOpenListeners.remove(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerOpenListeners() {
        Object[] list;
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listOpenListeners == null) {
                return;
            }
            list = this.listOpenListeners.toArray();
        }
        for (int i = 0; i < list.length; ++i) {
            MdiEntryOpenListener l = (MdiEntryOpenListener)list[i];
            try {
                l.mdiEntryOpen(this);
                continue;
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(MdiEntryDropListener l) {
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listDropListeners == null) {
                this.listDropListeners = new ArrayList<MdiEntryDropListener>(1);
            }
            this.listDropListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(MdiEntryDropListener l) {
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listDropListeners != null) {
                this.listDropListeners.remove(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDropListeners() {
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            return this.listDropListeners != null && this.listDropListeners.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean triggerDropListeners(Object o) {
        MdiEntryDropListener l;
        Object[] list;
        boolean handled = false;
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listDropListeners == null) {
                return handled;
            }
            list = this.listDropListeners.toArray();
        }
        for (int i = 0; i < list.length && !(handled = (l = (MdiEntryDropListener)list[i]).mdiEntryDrop(this, o)); ++i) {
        }
        return handled;
    }

    @Override
    public void setLogID(String logID) {
        if (logID == null || logID.equals("" + this.logID)) {
            return;
        }
        String oldID = this.logID;
        this.logID = logID;
        this.triggerLogIDListeners(oldID);
    }

    @Override
    public ViewTitleInfo getViewTitleInfo() {
        return this.viewTitleInfo;
    }

    @Override
    public void setViewTitleInfo(ViewTitleInfo viewTitleInfo) {
        if (this.viewTitleInfo == viewTitleInfo) {
            return;
        }
        this.viewTitleInfo = viewTitleInfo;
        if (viewTitleInfo != null) {
            String imageID;
            String newTitle;
            if (viewTitleInfo instanceof ViewTitleInfo2) {
                ViewTitleInfo2 vti2 = (ViewTitleInfo2)viewTitleInfo;
                try {
                    vti2.titleInfoLinked(this.mdi, this);
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
            if ((newTitle = (String)viewTitleInfo.getTitleInfoProperty(5)) != null) {
                this.setPullTitleFromIView(false);
                this.setTitle(newTitle);
            }
            if ((imageID = (String)viewTitleInfo.getTitleInfoProperty(2)) != null) {
                this.setImageLeftID(imageID.length() == 0 ? null : imageID);
            }
            ViewTitleInfoManager.addListener(this);
        }
    }

    @Override
    public void addToolbarEnabler(ToolBarEnabler enabler) {
        this.setToolBarEnablers.add(enabler);
    }

    @Override
    public void removeToolbarEnabler(ToolBarEnabler enabler) {
        this.setToolBarEnablers.remove(enabler);
    }

    @Override
    public ToolBarEnabler[] getToolbarEnablers() {
        return this.setToolBarEnablers.toArray(new ToolBarEnabler[0]);
    }

    public void setIView(IView iview) {
        UISWTViewEventListener eventListener;
        this.iview = iview;
        if (iview instanceof ViewTitleInfo) {
            this.setViewTitleInfo((ViewTitleInfo)((Object)iview));
        } else if (iview instanceof UISWTViewImpl && (eventListener = ((UISWTViewImpl)iview).getEventListener()) instanceof ViewTitleInfo) {
            this.setViewTitleInfo((ViewTitleInfo)((Object)eventListener));
        }
        if (iview instanceof ToolBarEnabler) {
            this.addToolbarEnabler((ToolBarEnabler)((Object)iview));
        }
        if (iview != null) {
            if (this.title == null) {
                this.setTitle(iview.getFullTitle());
            }
            if (this.datasource != null) {
                try {
                    iview.dataSourceChanged(this.datasource);
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        }
    }

    public SWTSkinObject getSkinObject() {
        return this.skinObject;
    }

    public void setSkinObject(SWTSkinObject skinObject, SWTSkinObject soMaster) {
        this.skinObject = skinObject;
        this.soMaster = soMaster;
        if (this.datasource != null) {
            if (skinObject != null) {
                skinObject.triggerListeners(7, this.datasource);
            }
            if (this.iview != null) {
                this.iview.dataSourceChanged(this.datasource);
            }
        }
    }

    public SWTSkinObject getSkinObjectMaster() {
        if (this.soMaster == null) {
            return this.skinObject;
        }
        return this.soMaster;
    }

    public void setSkinRef(String configID, Object params) {
        this.skinRef = configID;
        if (params != null) {
            this.setDatasource(params);
        }
    }

    public String getSkinRef() {
        return this.skinRef;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        if (title == null) {
            return;
        }
        if (title.startsWith("{") && title.endsWith("}") && title.length() > 2) {
            this.setTitleID(title.substring(1, title.length() - 1));
            return;
        }
        if (title.equals(this.title)) {
            return;
        }
        this.title = title;
        this.titleID = null;
        this.redraw();
    }

    @Override
    public void setTitleID(String titleID) {
        String title = MessageText.getString(titleID);
        this.setTitle(title.startsWith("{") ? title.substring(1) : title);
        this.titleID = titleID;
    }

    public void updateLanguage() {
        if (this.titleID != null) {
            this.setTitleID(this.titleID);
        } else {
            if (this.viewTitleInfo != null) {
                this.viewTitleInfoRefresh(this.viewTitleInfo);
            }
            this.updateUI();
        }
    }

    public void show() {
        Composite c;
        SWTSkinObjectContainer container;
        Composite composite;
        if (this.skinObject == null) {
            return;
        }
        SelectedContentManager.clearCurrentlySelectedContent();
        UIFunctionsSWT uif = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (uif != null) {
            uif.refreshTorrentMenu();
        }
        SWTSkinObject skinObject = this.getSkinObjectMaster();
        skinObject.setVisible(true);
        if (skinObject instanceof SWTSkinObjectContainer && (composite = (container = (SWTSkinObjectContainer)skinObject).getComposite()) != null && !composite.isDisposed()) {
            composite.setVisible(true);
            composite.moveAbove(null);
            composite.getParent().layout();
        }
        if (this.iview != null && (c = this.iview.getComposite()) != null && !c.isDisposed()) {
            c.setData("BaseMDIEntry", this);
            c.setVisible(true);
            c.getParent().layout();
        }
        try {
            if (this.iview instanceof IViewExtension) {
                ((IViewExtension)((Object)this.iview)).viewActivated();
            } else if (this.iview instanceof UISWTView) {
                ((UISWTView)((Object)this.iview)).triggerEvent(3, null);
            }
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    @Override
    public void hide() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                BaseMdiEntry.this.swt_hide();
            }
        });
    }

    private void swt_hide() {
        Composite oldComposite;
        SWTSkinObjectContainer container;
        SWTSkinObject skinObjectMaster = this.getSkinObjectMaster();
        if (skinObjectMaster instanceof SWTSkinObjectContainer && (container = (SWTSkinObjectContainer)skinObjectMaster) != null) {
            Control oldComposite2 = container.getControl();
            container.setVisible(false);
            if (!oldComposite2.isDisposed()) {
                oldComposite2.getShell().update();
            }
        }
        if (this.iview != null && (oldComposite = this.iview.getComposite()) != null && !oldComposite.isDisposed()) {
            oldComposite.setVisible(false);
            oldComposite.getShell().update();
        }
        try {
            if (this.iview instanceof IViewExtension) {
                ((IViewExtension)((Object)this.iview)).viewDeactivated();
            } else if (this.iview instanceof UISWTView) {
                ((UISWTView)((Object)this.iview)).triggerEvent(4, null);
            }
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    public UISWTViewEventListener getEventListener() {
        return this.eventListener;
    }

    public void setEventListener(UISWTViewEventListener _eventListener) {
        this.eventListener = _eventListener;
        if (this.eventListener instanceof ToolBarEnabler) {
            this.addToolbarEnabler((ToolBarEnabler)((Object)this.eventListener));
        }
        if (this.eventListener instanceof ViewTitleInfo && this.viewTitleInfo == null) {
            this.setViewTitleInfo((ViewTitleInfo)((Object)this.eventListener));
        }
        UISWTViewEventListener eventListenerDelegate = _eventListener;
        if (this.iview != null) {
            return;
        }
        try {
            UISWTViewImpl iview = new UISWTViewImpl(this.parentID, this.id, eventListenerDelegate, this.datasource);
            this.setIView(iview);
            PluginsMenuHelper.IViewInfo foundViewInfo = PluginsMenuHelper.getInstance().findIViewInfo(this.eventListener);
            String title = foundViewInfo != null ? foundViewInfo.name : iview.getFullTitle();
            iview.setTitle(title);
            this.setTitle(title);
        }
        catch (Exception e) {
            Debug.out(e);
        }
        if ((_eventListener instanceof BasicPluginViewImpl || _eventListener instanceof UISWTViewEventListenerHolder && ((UISWTViewEventListenerHolder)_eventListener).isLogView()) && "image.sidebar.plugin".equals(this.getImageLeftID())) {
            this.setImageLeftID("image.sidebar.logview");
        }
    }

    public boolean isPullTitleFromIView() {
        return this.pullTitleFromIView;
    }

    public void setPullTitleFromIView(boolean pullTitleFromIView) {
        this.pullTitleFromIView = pullTitleFromIView;
    }

    @Override
    public void updateUI() {
        if (this.iview == null) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (BaseMdiEntry.this.iview != null && !BaseMdiEntry.this.isDisposed()) {
                    BaseMdiEntry.this.iview.refresh();
                }
                if (BaseMdiEntry.this.isPullTitleFromIView() && BaseMdiEntry.this.isAdded()) {
                    BaseMdiEntry.this.setTitle(BaseMdiEntry.this.iview.getFullTitle());
                }
            }
        });
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    public void setCloseable(boolean closeable) {
        this.closeable = closeable;
        if (closeable) {
            Object datasource;
            LightHashMap<String, Object> autoOpenInfo = new LightHashMap<String, Object>();
            if (this.getParentID() != null) {
                autoOpenInfo.put("parentID", this.getParentID());
            }
            if (this.getIViewClass() != null) {
                autoOpenInfo.put("iviewClass", this.getIViewClass().getName());
            }
            if (this.getEventListener() != null) {
                autoOpenInfo.put("eventlistenerid", this.id);
            }
            if (this.getIView() != null) {
                autoOpenInfo.put("title", this.getIView().getFullTitle());
            }
            if ((datasource = this.getDatasourceCore()) instanceof DownloadManager) {
                try {
                    autoOpenInfo.put("dm", ((DownloadManager)datasource).getTorrent().getHashWrapper().toBase32String());
                }
                catch (Throwable t) {}
            } else if (datasource instanceof DownloadManager[]) {
                DownloadManager[] dms = (DownloadManager[])datasource;
                ArrayList<String> list = new ArrayList<String>();
                for (DownloadManager dm : dms) {
                    try {
                        list.add(dm.getTorrent().getHashWrapper().toBase32String());
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                autoOpenInfo.put("dms", list);
            } else if (datasource != null) {
                autoOpenInfo.put("datasource", datasource.toString());
            }
            this.mdi.informAutoOpenSet(this, autoOpenInfo);
            COConfigurationManager.setParameter("SideBar.AutoOpen." + this.id, true);
        } else {
            COConfigurationManager.removeParameter("SideBar.AutoOpen." + this.id);
        }
    }

    @Override
    public void setDefaultExpanded(boolean defaultExpanded) {
        COConfigurationManager.setBooleanDefault("SideBar.Expanded." + this.id, defaultExpanded);
    }

    @Override
    public boolean isExpanded() {
        return this.isExpanded == null ? COConfigurationManager.getBooleanParameter("SideBar.Expanded." + this.id) : this.isExpanded;
    }

    @Override
    public void setExpanded(boolean expanded) {
        this.isExpanded = expanded;
        boolean defExpanded = true;
        try {
            defExpanded = ConfigurationDefaults.getInstance().getBooleanParameter("SideBar.Expanded." + this.id);
        }
        catch (ConfigurationParameterNotFoundException configurationParameterNotFoundException) {
            // empty catch block
        }
        if (this.isExpanded == defExpanded) {
            COConfigurationManager.removeParameter("SideBar.Expanded." + this.id);
        } else {
            COConfigurationManager.setParameter("SideBar.Expanded." + this.id, this.isExpanded);
        }
    }

    @Override
    public boolean isAdded() {
        return this.added;
    }

    public void setDisposed(boolean b) {
        this.disposed = b;
        this.added = !b;
    }

    @Override
    public void setImageLeftID(String id) {
        this.imageLeftID = id;
        this.imageLeft = null;
        this.redraw();
    }

    @Override
    public String getImageLeftID() {
        return this.imageLeftID;
    }

    public void setImageLeft(Image imageLeft) {
        this.imageLeft = imageLeft;
        this.imageLeftID = null;
        this.redraw();
    }

    public Image getImageLeft(String suffix) {
        if (this.imageLeft != null) {
            return this.imageLeft;
        }
        if (this.imageLeftID == null) {
            return null;
        }
        Image img = null;
        img = suffix == null ? ImageLoader.getInstance().getImage(this.imageLeftID) : ImageLoader.getInstance().getImage(this.imageLeftID + suffix);
        if (ImageLoader.isRealImage(img)) {
            return img;
        }
        return null;
    }

    public void releaseImageLeft(String suffix) {
        if (this.imageLeft != null) {
            ImageLoader.getInstance().releaseImage(this.imageLeftID + (suffix == null ? "" : suffix));
        }
    }

    @Override
    public void viewTitleInfoRefresh(ViewTitleInfo titleInfoToRefresh) {
        String imageID;
        if (titleInfoToRefresh == null || this.viewTitleInfo != titleInfoToRefresh) {
            return;
        }
        if (this.isDisposed()) {
            return;
        }
        String newText = (String)this.viewTitleInfo.getTitleInfoProperty(5);
        if (newText != null) {
            this.setPullTitleFromIView(false);
            this.setTitle(newText);
        }
        if ((imageID = (String)this.viewTitleInfo.getTitleInfoProperty(2)) != null) {
            this.setImageLeftID(imageID.length() == 0 ? null : imageID);
        }
        this.redraw();
        String logID = (String)this.viewTitleInfo.getTitleInfoProperty(7);
        if (logID != null) {
            this.setLogID(logID);
        }
    }

    public void build() {
    }

    @Override
    public void setPreferredAfterID(String preferredAfterID) {
        this.preferredAfterID = preferredAfterID;
    }

    @Override
    public String getPreferredAfterID() {
        return this.preferredAfterID;
    }
}

