/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.imageloader;

import org.eclipse.swt.graphics.Image;

public class ImageLoaderRefInfo {
    private Image[] images;
    private long refcount;

    protected ImageLoaderRefInfo(Image[] images) {
        this.images = images;
        this.refcount = 1L;
    }

    protected ImageLoaderRefInfo(Image image) {
        this.images = new Image[]{image};
        this.refcount = 1L;
    }

    protected void setNonDisposable() {
        this.refcount = -2L;
    }

    protected boolean isNonDisposable() {
        return this.refcount == -2L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addref() {
        ImageLoaderRefInfo imageLoaderRefInfo = this;
        synchronized (imageLoaderRefInfo) {
            if (this.refcount >= 0L) {
                ++this.refcount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unref() {
        ImageLoaderRefInfo imageLoaderRefInfo = this;
        synchronized (imageLoaderRefInfo) {
            if (this.refcount >= 0L) {
                --this.refcount;
            }
        }
    }

    protected boolean canDispose() {
        return this.refcount == 0L || this.refcount == -1L;
    }

    protected long getRefCount() {
        return this.refcount;
    }

    protected Image[] getImages() {
        return this.images;
    }

    protected void setImages(Image[] images) {
        this.images = images;
    }
}

