/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.browser.msg;

import com.aelitis.azureus.core.messenger.ClientMessageContext;
import com.aelitis.azureus.core.messenger.browser.BrowserMessage;
import com.aelitis.azureus.core.messenger.browser.BrowserMessageDispatcher;
import com.aelitis.azureus.core.messenger.browser.listeners.BrowserMessageListener;
import com.aelitis.azureus.util.JSONUtils;
import com.aelitis.azureus.util.UrlFilter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Utils;

public class MessageDispatcherSWT
implements BrowserMessageDispatcher {
    private ClientMessageContext context;
    private Map<String, BrowserMessageListener> listeners = new HashMap<String, BrowserMessageListener>();
    private Browser browser;
    private BrowserFunction browserFunction;

    public MessageDispatcherSWT(ClientMessageContext context2) {
        this.context = context2;
    }

    public void registerBrowser(final Browser browser) {
        this.browser = browser;
        try {
            this.browserFunction = new BrowserFunction(browser, "sendMessageToAZ"){

                public Object function(Object[] args) {
                    if (args == null) {
                        MessageDispatcherSWT.this.context.debug("sendMessageToAZ: arguments null on " + browser.getUrl());
                        return null;
                    }
                    if (args.length != 3 && args.length != 2) {
                        MessageDispatcherSWT.this.context.debug("sendMessageToAZ: # arguments not 2 or 3 (" + args.length + ") on " + browser.getUrl());
                        return null;
                    }
                    if (!(args[0] instanceof String)) {
                        MessageDispatcherSWT.this.context.debug("sendMessageToAZ: Param 1 not String");
                        return null;
                    }
                    if (!(args[1] instanceof String)) {
                        MessageDispatcherSWT.this.context.debug("sendMessageToAZ: Param 2 not String");
                        return null;
                    }
                    Map params = Collections.EMPTY_MAP;
                    if (args.length == 3) {
                        if (!(args[2] instanceof String)) {
                            MessageDispatcherSWT.this.context.debug("sendMessageToAZ: Param 3 not String");
                            return null;
                        }
                        params = JSONUtils.decodeJSON((String)args[2]);
                    }
                    BrowserMessage message = new BrowserMessage((String)args[0], (String)args[1], params);
                    message.setReferer(browser.getUrl());
                    MessageDispatcherSWT.this.dispatch(message);
                    return null;
                }
            };
        }
        catch (Throwable t) {
            Debug.out(t);
        }
    }

    public void deregisterBrowser(Browser browser) {
        if (this.browserFunction != null && !this.browserFunction.isDisposed()) {
            this.browserFunction.dispose();
        }
    }

    public synchronized void addListener(BrowserMessageListener listener) {
        String id = listener.getId();
        BrowserMessageListener registered = this.listeners.get(id);
        if (registered != null) {
            if (registered != listener) {
                throw new IllegalStateException("Listener " + registered.getClass().getName() + " already registered for ID " + id);
            }
        } else {
            listener.setContext(this.context);
            this.listeners.put(id, listener);
        }
    }

    public synchronized void removeListener(BrowserMessageListener listener) {
        this.removeListener(listener.getId());
    }

    public synchronized void removeListener(String id) {
        BrowserMessageListener removed = this.listeners.remove(id);
        if (removed != null) {
            removed.setContext(null);
        }
    }

    public BrowserMessageListener getListener(String id) {
        return this.listeners.get(id);
    }

    public void dispatch(final BrowserMessage message) {
        BrowserMessageListener listener;
        String listenerId;
        if (message == null) {
            return;
        }
        String referer = message.getReferer();
        if (referer != null && !UrlFilter.getInstance().urlCanRPC(referer)) {
            this.context.debug("blocked " + message + "\n  " + referer);
            return;
        }
        this.context.debug("Received " + message);
        if (this.browser != null && !this.browser.isDisposed() && Utils.isThisThreadSWT()) {
            this.context.debug("   browser url: " + this.browser.getUrl());
        }
        if ("lightbox-browser".equals(listenerId = message.getListenerId())) {
            listenerId = "display";
        }
        if ((listener = this.getListener(listenerId)) == null) {
            this.context.debug("No listener registered with ID " + listenerId);
        } else {
            new AEThread2("dispatch for " + listenerId, true){

                public void run() {
                    listener.handleMessage(message);
                    message.complete(true, true, null);
                }
            }.start();
        }
    }
}

