/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.common;

import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;

public class RememberedDecisionsManager {
    public static int getRememberedDecision(String id) {
        return RememberedDecisionsManager.getRememberedDecision(id, -1);
    }

    public static int getRememberedDecision(String id, int onlyIfInMask) {
        if (id == null || onlyIfInMask == 0) {
            return -1;
        }
        Map remembered_decisions = COConfigurationManager.getMapParameter("MessageBoxWindow.decisions", new HashMap());
        Long l = (Long)remembered_decisions.get(id);
        if (l != null) {
            int i = l.intValue();
            if (onlyIfInMask == -1 || (i & onlyIfInMask) != 0) {
                return i;
            }
        }
        return -1;
    }

    public static void setRemembered(String id, int value) {
        if (id == null) {
            return;
        }
        Map remembered_decisions = COConfigurationManager.getMapParameter("MessageBoxWindow.decisions", new HashMap());
        if (value == -1) {
            remembered_decisions.remove(id);
        } else {
            remembered_decisions.put(id, new Long(value));
        }
        COConfigurationManager.setParameter("MessageBoxWindow.decisions", remembered_decisions);
        COConfigurationManager.save();
    }
}

