/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DNSUtils {
    private static String getFactory() {
        return System.getProperty("azureus.dns.context.factory", "com.sun.jndi.dns.DnsContextFactory");
    }

    public static DirContext getInitialDirContext() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", DNSUtils.getFactory());
        return new InitialDirContext(env);
    }

    public static Inet6Address getIPV6ByName(String host) throws UnknownHostException {
        List<Inet6Address> all = DNSUtils.getAllIPV6ByName(host);
        return all.get(0);
    }

    public static List<Inet6Address> getAllIPV6ByName(String host) throws UnknownHostException {
        ArrayList<Inet6Address> result = new ArrayList<Inet6Address>();
        try {
            Attribute attr;
            DirContext context2 = DNSUtils.getInitialDirContext();
            Attributes attrs = context2.getAttributes(host, new String[]{"AAAA"});
            if (attrs != null && (attr = attrs.get("aaaa")) != null) {
                NamingEnumeration<?> values = attr.getAll();
                while (values.hasMore()) {
                    Object value = values.next();
                    if (!(value instanceof String)) continue;
                    try {
                        result.add((Inet6Address)InetAddress.getByName((String)value));
                    }
                    catch (Throwable e) {}
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (result.size() > 0) {
            return result;
        }
        throw new UnknownHostException(host);
    }
}

