/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.speedmanager.impl.v3;

import com.aelitis.azureus.core.neuronal.NeuralSpeedLimiter;
import com.aelitis.azureus.core.speedmanager.SpeedManagerPingSource;
import com.aelitis.azureus.core.speedmanager.impl.SpeedManagerAlgorithmProvider;
import com.aelitis.azureus.core.speedmanager.impl.SpeedManagerAlgorithmProviderAdapter;
import com.aelitis.azureus.core.util.average.Average;
import com.aelitis.azureus.core.util.average.AverageFactory;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;

public class SpeedManagerAlgorithmProviderV3
implements SpeedManagerAlgorithmProvider {
    private static final String CONFIG_MIN_UP = "AutoSpeed Min Upload KBs";
    private static final String CONFIG_MAX_UP = "AutoSpeed Max Upload KBs";
    private static final String CONFIG_MAX_INC = "AutoSpeed Max Increment KBs";
    private static final String CONFIG_MAX_DEC = "AutoSpeed Max Decrement KBs";
    private static final String CONFIG_CHOKE_PING = "AutoSpeed Choking Ping Millis";
    private static final String CONFIG_DOWNADJ_ENABLE = "AutoSpeed Download Adj Enable";
    private static final String CONFIG_DOWNADJ_RATIO = "AutoSpeed Download Adj Ratio";
    private static final String CONFIG_LATENCY_FACTOR = "AutoSpeed Latency Factor";
    private static final String CONFIG_FORCED_MIN = "AutoSpeed Forced Min KBs";
    private static int PING_CHOKE_TIME;
    private static int MIN_UP;
    private static int MAX_UP;
    private static boolean ADJUST_DOWNLOAD_ENABLE;
    private static float ADJUST_DOWNLOAD_RATIO;
    private static int MAX_INCREMENT;
    private static int MAX_DECREMENT;
    private static int LATENCY_FACTOR;
    private static int FORCED_MIN_SPEED;
    private static final String[] CONFIG_PARAMS;
    private static final int UNLIMITED = Integer.MAX_VALUE;
    private static final int MODE_RUNNING = 0;
    private static final int MODE_FORCED_MIN = 1;
    private static final int MODE_FORCED_MAX = 2;
    private static final int FORCED_MAX_TICKS = 30;
    private static final int FORCED_MIN_TICKS = 60;
    private static final int FORCED_MIN_AT_START_TICK_LIMIT = 60;
    private static final int PING_AVERAGE_HISTORY_COUNT = 5;
    private static final int IDLE_UPLOAD_SPEED = 5120;
    private static final int INITIAL_IDLE_AVERAGE = 100;
    private static final int MIN_IDLE_AVERAGE = 50;
    private static final int INCREASING = 1;
    private static final int DECREASING = 2;
    private SpeedManagerAlgorithmProviderAdapter adapter;
    private NeuralSpeedLimiter limiter;
    private Average upload_average = AverageFactory.MovingImmediateAverage(5);
    private Average upload_short_average = AverageFactory.MovingImmediateAverage(2);
    private Average upload_short_prot_average = AverageFactory.MovingImmediateAverage(2);
    private Average ping_average_history = AverageFactory.MovingImmediateAverage(5);
    private Average choke_speed_average = AverageFactory.MovingImmediateAverage(3);
    private Map ping_sources;
    private volatile int replacement_contacts;
    private int mode;
    private volatile int mode_ticks;
    private int saved_limit;
    private int direction;
    private int ticks;
    private int idle_ticks;
    private int idle_average;
    private boolean idle_average_set;
    private int max_ping;
    private int max_upload_average;

    public SpeedManagerAlgorithmProviderV3(SpeedManagerAlgorithmProviderAdapter _adapter) {
        this.adapter = _adapter;
        this.limiter = new NeuralSpeedLimiter();
    }

    public void destroy() {
    }

    public void updateStats() {
        int current_protocol_speed = this.adapter.getCurrentProtocolUploadSpeed();
        int current_data_speed = this.adapter.getCurrentDataUploadSpeed();
        int current_speed = current_protocol_speed + current_data_speed;
        this.upload_average.update(current_speed);
        this.upload_short_average.update(current_speed);
        this.upload_short_prot_average.update(current_protocol_speed);
        ++this.mode_ticks;
        ++this.ticks;
    }

    public void reset() {
        this.ticks = 0;
        this.mode = 0;
        this.mode_ticks = 0;
        this.idle_ticks = 0;
        this.idle_average = 100;
        this.idle_average_set = false;
        this.max_upload_average = 0;
        this.direction = 1;
        this.max_ping = 0;
        this.replacement_contacts = 0;
        this.ping_sources = new HashMap();
        this.choke_speed_average.reset();
        this.upload_average.reset();
        this.upload_short_average.reset();
        this.upload_short_prot_average.reset();
        this.ping_average_history.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pingSourceFound(SpeedManagerPingSource source, boolean is_replacement) {
        if (is_replacement) {
            ++this.replacement_contacts;
        }
        Map map = this.ping_sources;
        synchronized (map) {
            this.ping_sources.put(source, new pingSource(source));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pingSourceFailed(SpeedManagerPingSource source) {
        Map map = this.ping_sources;
        synchronized (map) {
            this.ping_sources.remove(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculate(SpeedManagerPingSource[] sources) {
        int current_limit;
        int up_average;
        int min_rtt = Integer.MAX_VALUE;
        for (int i = 0; i < sources.length; ++i) {
            int rtt = sources[i].getPingTime();
            if (rtt < 0 || rtt >= min_rtt) continue;
            min_rtt = rtt;
        }
        String str = "";
        int ping_total = 0;
        int ping_count = 0;
        for (int i = 0; i < sources.length; ++i) {
            pingSource ps;
            Map map = this.ping_sources;
            synchronized (map) {
                ps = (pingSource)this.ping_sources.get(sources[i]);
            }
            int rtt = sources[i].getPingTime();
            str = str + (i == 0 ? "" : ",") + rtt;
            if (ps != null) {
                boolean good_ping = rtt < 5 * Math.max(min_rtt, 75);
                ps.pingReceived(rtt, good_ping);
                if (!good_ping) {
                    rtt = -1;
                }
            }
            if (rtt == -1) continue;
            ping_total += rtt;
            ++ping_count;
        }
        if (ping_count == 0) {
            return;
        }
        int ping_average = ping_total / ping_count;
        ping_average = (ping_average + min_rtt) / 2;
        int running_average = (int)this.ping_average_history.update(ping_average);
        if (ping_average > this.max_ping) {
            this.max_ping = ping_average;
        }
        if ((up_average = (int)this.upload_average.getAverage()) <= 5120 || running_average < this.idle_average && !this.idle_average_set) {
            ++this.idle_ticks;
            if (this.idle_ticks >= 5) {
                this.idle_average = Math.max(running_average, 50);
                this.log("New idle average: " + this.idle_average);
                this.idle_average_set = true;
            }
        } else {
            if (up_average > this.max_upload_average) {
                this.max_upload_average = up_average;
                this.log("New max upload:" + this.max_upload_average);
            }
            this.idle_ticks = 0;
        }
        if (this.idle_average_set && running_average < this.idle_average) {
            this.idle_average = Math.max(running_average, 50);
        }
        int current_speed = this.adapter.getCurrentDataUploadSpeed() + this.adapter.getCurrentProtocolUploadSpeed();
        int new_limit = current_limit = this.adapter.getCurrentUploadLimit();
        this.log("Pings: " + str + ", average=" + ping_average + ", running_average=" + running_average + ",idle_average=" + this.idle_average + ", speed=" + current_speed + ",limit=" + current_limit + ",choke = " + (int)this.choke_speed_average.getAverage());
        if (this.mode == 2) {
            if (this.mode_ticks > 30) {
                this.mode = 0;
                current_limit = new_limit = this.saved_limit;
            }
        } else if (this.mode == 1) {
            if (this.idle_average_set || this.mode_ticks > 60) {
                this.log("Mode -> running");
                if (!this.idle_average_set) {
                    this.idle_average = Math.max(running_average, 50);
                    this.idle_average_set = true;
                }
                this.mode = 0;
                this.mode_ticks = 0;
                current_limit = new_limit = this.saved_limit;
            } else if (this.mode_ticks == 5) {
                this.ping_average_history.reset();
            }
        }
        if (this.mode == 0) {
            if (this.ticks > 60 && !this.idle_average_set || this.replacement_contacts >= 2 && this.idle_average_set) {
                this.log("Mode -> forced min");
                this.mode = 1;
                this.mode_ticks = 0;
                this.saved_limit = current_limit;
                this.idle_average_set = false;
                this.idle_ticks = 0;
                this.replacement_contacts = 0;
                new_limit = FORCED_MIN_SPEED;
            } else {
                this.limiter.setDlSpeed(this.adapter.getCurrentDataDownloadSpeed());
                this.limiter.setUlSpeed(this.adapter.getCurrentDataUploadSpeed());
                this.limiter.setMaxDlSpeed(this.adapter.getSpeedManager().getEstimatedDownloadCapacityBytesPerSec().getBytesPerSec());
                this.limiter.setMaxUlSpeed(this.adapter.getSpeedManager().getEstimatedUploadCapacityBytesPerSec().getBytesPerSec());
                this.limiter.setLatency(ping_average);
                this.limiter.setMinLatency(this.idle_average);
                this.limiter.setMaxLatency(1500L);
                if (this.limiter.shouldLimitDownload()) {
                    this.adapter.setCurrentDownloadLimit((int)this.limiter.getDownloadLimit());
                } else {
                    this.adapter.setCurrentDownloadLimit(0);
                }
                if (this.limiter.shouldLimitUpload()) {
                    this.adapter.setCurrentUploadLimit((int)this.limiter.getUploadLimit());
                } else {
                    this.adapter.setCurrentUploadLimit(0);
                }
            }
        }
    }

    public int getIdlePingMillis() {
        return this.idle_average;
    }

    public int getCurrentPingMillis() {
        return (int)this.ping_average_history.getAverage();
    }

    public int getMaxPingMillis() {
        return this.max_ping;
    }

    public int getCurrentChokeSpeed() {
        return (int)this.choke_speed_average.getAverage();
    }

    public int getMaxUploadSpeed() {
        return this.max_upload_average;
    }

    public boolean getAdjustsDownloadLimits() {
        return ADJUST_DOWNLOAD_ENABLE;
    }

    protected void log(String str) {
        this.adapter.log(str);
    }

    static {
        CONFIG_PARAMS = new String[]{CONFIG_MIN_UP, CONFIG_MAX_UP, CONFIG_MAX_INC, CONFIG_MAX_DEC, CONFIG_CHOKE_PING, CONFIG_DOWNADJ_ENABLE, CONFIG_DOWNADJ_RATIO, CONFIG_LATENCY_FACTOR, CONFIG_FORCED_MIN};
        COConfigurationManager.addAndFireParameterListeners(CONFIG_PARAMS, new ParameterListener(){

            public void parameterChanged(String parameterName) {
                PING_CHOKE_TIME = COConfigurationManager.getIntParameter(SpeedManagerAlgorithmProviderV3.CONFIG_CHOKE_PING);
                MIN_UP = COConfigurationManager.getIntParameter(SpeedManagerAlgorithmProviderV3.CONFIG_MIN_UP) * 1024;
                MAX_UP = COConfigurationManager.getIntParameter(SpeedManagerAlgorithmProviderV3.CONFIG_MAX_UP) * 1024;
                MAX_INCREMENT = COConfigurationManager.getIntParameter(SpeedManagerAlgorithmProviderV3.CONFIG_MAX_INC) * 1024;
                MAX_DECREMENT = COConfigurationManager.getIntParameter(SpeedManagerAlgorithmProviderV3.CONFIG_MAX_DEC) * 1024;
                ADJUST_DOWNLOAD_ENABLE = COConfigurationManager.getBooleanParameter(SpeedManagerAlgorithmProviderV3.CONFIG_DOWNADJ_ENABLE);
                String str = COConfigurationManager.getStringParameter(SpeedManagerAlgorithmProviderV3.CONFIG_DOWNADJ_RATIO);
                LATENCY_FACTOR = COConfigurationManager.getIntParameter(SpeedManagerAlgorithmProviderV3.CONFIG_LATENCY_FACTOR);
                if (LATENCY_FACTOR < 1) {
                    LATENCY_FACTOR = 1;
                }
                FORCED_MIN_SPEED = COConfigurationManager.getIntParameter(SpeedManagerAlgorithmProviderV3.CONFIG_FORCED_MIN) * 1024;
                if (FORCED_MIN_SPEED < 1024) {
                    FORCED_MIN_SPEED = 1024;
                }
                try {
                    ADJUST_DOWNLOAD_RATIO = Float.parseFloat(str);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    protected class pingSource {
        private SpeedManagerPingSource source;
        private int last_good_ping;
        private int bad_pings;

        protected pingSource(SpeedManagerPingSource _source) {
            this.source = _source;
        }

        public void pingReceived(int time, boolean good_ping) {
            if (good_ping) {
                this.bad_pings = 0;
                this.last_good_ping = time;
            } else {
                ++this.bad_pings;
            }
            if (this.bad_pings == 3) {
                this.source.destroy();
            }
        }
    }
}

