/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.speedmanager.impl.v2;

public class SaturatedMode
implements Comparable {
    public static final SaturatedMode AT_LIMIT = new SaturatedMode("AT_LIMIT", 0.95f);
    public static final SaturatedMode HIGH = new SaturatedMode("HIGH", 0.75f);
    public static final SaturatedMode MED = new SaturatedMode("MED", 0.25f);
    public static final SaturatedMode LOW = new SaturatedMode("LOW", 0.03f);
    public static final SaturatedMode NONE = new SaturatedMode("NONE", 0.0f);
    private final String name;
    private final float percentCapacity;

    private SaturatedMode(String _name, float _percent) {
        this.name = _name;
        this.percentCapacity = _percent;
    }

    private float getThreshold() {
        return this.percentCapacity;
    }

    public static SaturatedMode getSaturatedMode(int currentRate, int limit) {
        float percent;
        if (limit == 0) {
            limit = 61440;
        }
        if ((percent = (float)currentRate / (float)limit) > AT_LIMIT.getThreshold()) {
            return AT_LIMIT;
        }
        if (percent > HIGH.getThreshold()) {
            return HIGH;
        }
        if (percent > MED.getThreshold()) {
            return MED;
        }
        if (percent > LOW.getThreshold()) {
            return LOW;
        }
        return NONE;
    }

    public String toString() {
        return this.name;
    }

    public boolean isGreater(SaturatedMode mode) {
        return this.compareTo(mode) > 0;
    }

    public int compareTo(SaturatedMode satMode) {
        if (this.percentCapacity < satMode.getThreshold()) {
            return -1;
        }
        if (this.percentCapacity > satMode.getThreshold()) {
            return 1;
        }
        return 0;
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof SaturatedMode)) {
            throw new ClassCastException("Only comparable to SaturatedMode class.");
        }
        SaturatedMode casted = (SaturatedMode)obj;
        return this.compareTo(casted);
    }
}

