/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.azureus;

import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.MessagingUtil;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessage;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class AZRequestHint
implements AZMessage {
    private final byte version;
    private DirectByteBuffer buffer = null;
    private int piece_number;
    private int offset;
    private int length;
    private int life;

    public AZRequestHint(int _piece_number, int _offset, int _length, int _life, byte _version) {
        this.piece_number = _piece_number;
        this.offset = _offset;
        this.length = _length;
        this.life = _life;
        this.version = _version;
    }

    public String getID() {
        return "AZ_REQUEST_HINT";
    }

    public byte[] getIDBytes() {
        return AZMessage.ID_AZ_REQUEST_HINT_BYTES;
    }

    public String getFeatureID() {
        return "AZ1";
    }

    public int getFeatureSubID() {
        return 3;
    }

    public int getType() {
        return 0;
    }

    public byte getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.getID() + " piece #" + this.piece_number + ":" + this.offset + "->" + (this.offset + this.length - 1) + "/" + this.life;
    }

    public int getPieceNumber() {
        return this.piece_number;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public int getLife() {
        return this.life;
    }

    public DirectByteBuffer[] getData() {
        if (this.buffer == null) {
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("piece", new Long(this.piece_number));
            map.put("offset", new Long(this.offset));
            map.put("length", new Long(this.length));
            map.put("life", new Long(this.life));
            this.buffer = MessagingUtil.convertPayloadToBencodedByteStream(map, (byte)12);
        }
        return new DirectByteBuffer[]{this.buffer};
    }

    public Message deserialize(DirectByteBuffer data, byte version) throws MessageException {
        Map payload = MessagingUtil.convertBencodedByteStreamToPayload(data, 1, this.getID());
        int piece_number = ((Long)payload.get("piece")).intValue();
        int offset = ((Long)payload.get("offset")).intValue();
        int length = ((Long)payload.get("length")).intValue();
        int life = ((Long)payload.get("life")).intValue();
        return new AZRequestHint(piece_number, offset, length, life, version);
    }

    public void destroy() {
        if (this.buffer != null) {
            this.buffer.returnToPool();
        }
    }
}

