/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.azureus;

import com.aelitis.azureus.core.networkmanager.RawMessage;
import com.aelitis.azureus.core.networkmanager.impl.RawMessageImpl;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.MessageManager;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZBadPiece;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZGenericMapPayload;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZHandshake;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZHave;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZPeerExchange;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZRequestHint;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZStatReply;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZStatRequest;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTChoke;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTInterested;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTUnchoke;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTUninterested;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public class AZMessageFactory {
    public static final byte MESSAGE_VERSION_INITIAL = 1;
    public static final byte MESSAGE_VERSION_SUPPORTS_PADDING = 2;
    public static final int AZ_HANDSHAKE_PAD_MAX = 64;
    public static final int SMALL_PAD_MAX = 8;
    public static final int BIG_PAD_MAX = 20;
    private static final byte bss = 11;
    private static final Map<String, LegacyData> legacy_data = new HashMap<String, LegacyData>();

    public static void init() {
        try {
            MessageManager.getSingleton().registerMessageType(new AZHandshake(new byte[20], null, null, "", "", 0, 0, 0, null, new String[0], new byte[0], 0, 2, false));
            MessageManager.getSingleton().registerMessageType(new AZPeerExchange(new byte[20], null, null, 2));
            MessageManager.getSingleton().registerMessageType(new AZRequestHint(-1, -1, -1, -1, 2));
            MessageManager.getSingleton().registerMessageType(new AZHave(new int[0], 2));
            MessageManager.getSingleton().registerMessageType(new AZBadPiece(-1, 2));
            MessageManager.getSingleton().registerMessageType(new AZStatRequest(null, 2));
            MessageManager.getSingleton().registerMessageType(new AZStatReply(null, 2));
        }
        catch (MessageException me) {
            me.printStackTrace();
        }
    }

    public static void registerGenericMapPayloadMessageType(String type_id) throws MessageException {
        MessageManager.getSingleton().registerMessageType(new AZGenericMapPayload(type_id, null, 1));
    }

    public static Message createAZMessage(DirectByteBuffer stream_payload) throws MessageException {
        byte flags;
        int id_length = stream_payload.getInt((byte)11);
        if (id_length < 1 || id_length > 1024 || id_length > stream_payload.remaining((byte)11) - 1) {
            byte bt_id = stream_payload.get((byte)0, 0);
            throw new MessageException("invalid AZ id length given: " + id_length + ", stream_payload.remaining(): " + stream_payload.remaining((byte)11) + ", BT id?=" + bt_id);
        }
        byte[] id_bytes = new byte[id_length];
        stream_payload.get((byte)11, id_bytes);
        byte version_and_flags = stream_payload.get((byte)11);
        byte version = (byte)(version_and_flags & 0xF);
        if (version >= 2 && ((flags = (byte)(version_and_flags >> 4 & 0xF)) & 1) != 0) {
            short padding_length = stream_payload.getShort((byte)11);
            byte[] padding = new byte[padding_length];
            stream_payload.get((byte)11, padding);
        }
        return MessageManager.getSingleton().createMessage(id_bytes, stream_payload, version);
    }

    public static RawMessage createAZRawMessage(Message base_message, int padding_mode) {
        int priority;
        DirectByteBuffer header;
        byte[] id_bytes = base_message.getIDBytes();
        byte version = base_message.getVersion();
        DirectByteBuffer[] payload = base_message.getData();
        int payload_size = 0;
        for (int i = 0; i < payload.length; ++i) {
            payload_size += payload[i].remaining((byte)11);
        }
        if (version >= 2) {
            short padding_length;
            boolean enable_padding;
            boolean bl = enable_padding = padding_mode != 0;
            if (enable_padding) {
                padding_length = padding_mode == 2 ? (short)(Math.random() * 8.0) : (short)(Math.random() * (double)(payload_size > 256 ? 8 : 20));
                if (padding_length == 0) {
                    enable_padding = false;
                }
            } else {
                padding_length = 0;
            }
            int flags = enable_padding ? 1 : 0;
            int header_size = 8 + id_bytes.length + 1 + (enable_padding ? 2 + padding_length : 0);
            header = DirectByteBufferPool.getBuffer((byte)22, header_size);
            header.putInt((byte)11, header_size - 4 + payload_size);
            header.putInt((byte)11, id_bytes.length);
            header.put((byte)11, id_bytes);
            byte version_and_flags = (byte)(flags << 4 | version);
            header.put((byte)11, version_and_flags);
            if (enable_padding) {
                byte[] padding = new byte[padding_length];
                header.putShort((byte)11, padding_length);
                header.put((byte)11, padding);
            }
        } else {
            int header_size = 8 + id_bytes.length + 1;
            header = DirectByteBufferPool.getBuffer((byte)22, header_size);
            header.putInt((byte)11, header_size - 4 + payload_size);
            header.putInt((byte)11, id_bytes.length);
            header.put((byte)11, id_bytes);
            header.put((byte)11, version);
        }
        header.flip((byte)11);
        DirectByteBuffer[] raw_buffs = new DirectByteBuffer[payload.length + 1];
        raw_buffs[0] = header;
        for (int i = 0; i < payload.length; ++i) {
            raw_buffs[i + 1] = payload[i];
        }
        String message_id = base_message.getID();
        LegacyData ld = legacy_data.get(message_id);
        if (ld != null) {
            return new RawMessageImpl(base_message, raw_buffs, ld.priority, ld.is_no_delay, ld.to_remove);
        }
        boolean no_delay = true;
        if (message_id == "AZ_HANDSHAKE") {
            priority = 2;
        } else if (message_id == "AZ_HAVE") {
            priority = 0;
            no_delay = false;
        } else {
            priority = base_message.getType() == 1 ? 0 : 1;
        }
        return new RawMessageImpl(base_message, raw_buffs, priority, no_delay, null);
    }

    static {
        legacy_data.put("BT_CHOKE", new LegacyData(2, true, new Message[]{new BTUnchoke(0)}));
        legacy_data.put("BT_UNCHOKE", new LegacyData(1, true, new Message[]{new BTChoke(0)}));
        legacy_data.put("BT_INTERESTED", new LegacyData(2, true, new Message[]{new BTUninterested(0)}));
        legacy_data.put("BT_UNINTERESTED", new LegacyData(1, false, new Message[]{new BTInterested(0)}));
        legacy_data.put("BT_HAVE", new LegacyData(0, false, null));
        legacy_data.put("BT_BITFIELD", new LegacyData(2, true, null));
        legacy_data.put("BT_HAVE_ALL", new LegacyData(2, true, null));
        legacy_data.put("BT_HAVE_NONE", new LegacyData(2, true, null));
        legacy_data.put("BT_REQUEST", new LegacyData(1, true, null));
        legacy_data.put("BT_REJECT_REQUEST", new LegacyData(1, true, null));
        legacy_data.put("BT_PIECE", new LegacyData(0, false, null));
        legacy_data.put("BT_CANCEL", new LegacyData(2, true, null));
        legacy_data.put("BT_HANDSHAKE", new LegacyData(2, true, null));
        legacy_data.put("BT_KEEP_ALIVE", new LegacyData(0, false, null));
        legacy_data.put("BT_DHT_PORT", new LegacyData(0, false, null));
        legacy_data.put("BT_SUGGEST_PIECE", new LegacyData(1, true, null));
        legacy_data.put("BT_ALLOWED_FAST", new LegacyData(0, false, null));
    }

    protected static class LegacyData {
        protected final int priority;
        protected final boolean is_no_delay;
        protected final Message[] to_remove;

        protected LegacyData(int prio, boolean no_delay, Message[] remove) {
            this.priority = prio;
            this.is_no_delay = no_delay;
            this.to_remove = remove;
        }
    }
}

