/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.admin.impl;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSpeedTester;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSpeedTesterResult;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminSpeedTesterImpl;
import java.io.File;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.download.DownloadManagerPeerListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.security.SECertificateListener;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.download.DownloadRemovalVetoException;
import org.gudy.azureus2.plugins.download.DownloadStats;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;

public class NetworkAdminSpeedTesterBTImpl
extends NetworkAdminSpeedTesterImpl
implements NetworkAdminSpeedTester {
    public static final String DOWNLOAD_AVE = "download-ave";
    public static final String UPLOAD_AVE = "upload-ave";
    public static final String DOWNLOAD_STD_DEV = "download-std-dev";
    public static final String UPLOAD_STD_DEV = "upload-std-dev";
    private static int testMode = 0;
    private static TorrentAttribute speedTestAttrib;
    private static NetworkAdminSpeedTesterResult lastResult;
    private PluginInterface plugin;
    private boolean test_started;
    private boolean test_completed;
    private boolean use_crypto;
    private volatile boolean aborted;
    private String deferred_abort;

    protected static void startUp() {
        PluginInterface plugin = PluginInitializer.getDefaultInterface();
        speedTestAttrib = plugin.getTorrentManager().getPluginAttribute(NetworkAdminSpeedTesterBTImpl.class.getName() + ".test.attrib");
        DownloadManager dm = plugin.getDownloadManager();
        Download[] downloads = dm.getDownloads();
        if (downloads != null) {
            int num = downloads.length;
            for (int i = 0; i < num; ++i) {
                Download download = downloads[i];
                if (!download.getBooleanAttribute(speedTestAttrib)) continue;
                try {
                    if (download.getState() != 7) {
                        try {
                            download.stop();
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                    download.remove(true, true);
                    continue;
                }
                catch (Throwable e) {
                    Debug.out("Had " + e.getMessage() + " while trying to remove " + downloads[i].getName());
                }
            }
        }
    }

    protected static NetworkAdminSpeedTesterResult getLastResult() {
        return lastResult;
    }

    public NetworkAdminSpeedTesterBTImpl(PluginInterface pi) {
        this.plugin = pi;
    }

    public int getTestType() {
        return 1;
    }

    public void setMode(int mode) {
        testMode = mode;
    }

    public int getMode() {
        return testMode;
    }

    public void setUseCrypto(boolean _use_crypto) {
        this.use_crypto = _use_crypto;
    }

    public boolean getUseCrypto() {
        return this.use_crypto;
    }

    public synchronized void start(TOTorrent tot) {
        if (this.test_started) {
            Debug.out("Test already started!");
            return;
        }
        this.test_started = true;
        try {
            TorrentUtils.setFlag(tot, 1, true);
            TorrentImpl torrent = new TorrentImpl(tot);
            String fileName = torrent.getName();
            this.sendStageUpdateToListeners(MessageText.getString("SpeedTestWizard.stage.message.preparing"));
            File saveLocation = AETemporaryFileHandler.createTempFile();
            File baseDir = saveLocation.getParentFile();
            File blankFile = new File(baseDir, fileName);
            File blankTorrentFile = new File(baseDir, "speedTestTorrent.torrent");
            torrent.writeToFile(blankTorrentFile);
            URL announce_url = torrent.getAnnounceURL();
            if (announce_url.getProtocol().equalsIgnoreCase("https")) {
                SESecurityManager.setCertificateHandler(announce_url, new SECertificateListener(){

                    public boolean trustCertificate(String resource, X509Certificate cert) {
                        return true;
                    }
                });
            }
            Download speed_download = this.plugin.getDownloadManager().addDownloadStopped(torrent, blankTorrentFile, blankFile);
            speed_download.setBooleanAttribute(speedTestAttrib, true);
            org.gudy.azureus2.core3.download.DownloadManager core_download = PluginCoreUtils.unwrap(speed_download);
            core_download.setPieceCheckingEnabled(false);
            core_download.getDownloadState().setIntParameter("max.uploads", 32);
            core_download.getDownloadState().setIntParameter("max.uploads.when.seeding", 32);
            if (this.use_crypto) {
                core_download.setCryptoLevel(1);
            }
            core_download.addPeerListener(new DownloadManagerPeerListener(){

                public void peerManagerWillBeAdded(PEPeerManager peer_manager) {
                    int startPiece;
                    DiskManager disk_manager = peer_manager.getDiskManager();
                    DiskManagerPiece[] pieces = disk_manager.getPieces();
                    for (int i = startPiece = NetworkAdminSpeedTesterBTImpl.setStartPieceBasedOnMode(testMode, pieces.length); i < pieces.length; ++i) {
                        pieces[i].setDone(true);
                    }
                }

                public void peerManagerAdded(PEPeerManager peer_manager) {
                }

                public void peerManagerRemoved(PEPeerManager manager) {
                }

                public void peerAdded(PEPeer peer) {
                }

                public void peerRemoved(PEPeer peer) {
                }
            });
            speed_download.moveTo(1);
            speed_download.setFlag(4L, true);
            core_download.initialize();
            core_download.setForceStart(true);
            TorrentSpeedTestMonitorThread monitor = new TorrentSpeedTestMonitorThread(speed_download);
            monitor.start();
        }
        catch (Throwable e) {
            this.test_completed = true;
            this.abort("Could not start test", e);
        }
    }

    public void complete(NetworkAdminSpeedTesterResult result) {
        this.sendResultToListeners(result);
    }

    protected void abort(String reason, Throwable cause) {
        String msg = cause instanceof RuntimeException ? Debug.getNestedExceptionMessageAndStack(cause) : Debug.getNestedExceptionMessage(cause);
        this.abort(reason + ": " + msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort(String reason) {
        reason = "Test aborted: " + reason;
        NetworkAdminSpeedTesterBTImpl networkAdminSpeedTesterBTImpl = this;
        synchronized (networkAdminSpeedTesterBTImpl) {
            if (this.aborted) {
                return;
            }
            this.aborted = true;
            if (this.test_started && !this.test_completed) {
                this.deferred_abort = reason;
                return;
            }
        }
        this.sendResultToListeners(new BitTorrentResult(reason));
    }

    public NetworkAdminSpeedTesterResult getResult() {
        return lastResult;
    }

    private static int setStartPieceBasedOnMode(int mode, int totalPieces) {
        if (mode == 0) {
            return 0;
        }
        if (mode == 1) {
            return totalPieces;
        }
        throw new IllegalStateException("Did not recognize the NetworkAdmin Speed Test type. mode=" + mode);
    }

    private static long autoboxLong(Object o) {
        return NetworkAdminSpeedTesterBTImpl.autoboxLong((Long)o);
    }

    private static long autoboxLong(Long l) {
        return l;
    }

    private static Long autoboxLong(long l) {
        return new Long(l);
    }

    private static Double autoboxDouble(double d) {
        return new Double(d);
    }

    class BitTorrentResult
    implements NetworkAdminSpeedTesterResult {
        long time = SystemTime.getCurrentTime();
        int downspeed;
        int upspeed;
        boolean hadError = false;
        String lastError = "";

        public BitTorrentResult(Map uploadRes, Map downloadRes) {
            Double dAve = (Double)downloadRes.get("ave");
            Double uAve = (Double)uploadRes.get("ave");
            this.downspeed = dAve.intValue();
            this.upspeed = uAve.intValue();
        }

        public BitTorrentResult(String errorMsg) {
            this.hadError = true;
            this.lastError = errorMsg;
        }

        public NetworkAdminSpeedTester getTest() {
            return NetworkAdminSpeedTesterBTImpl.this;
        }

        public long getTestTime() {
            return this.time;
        }

        public int getDownloadSpeed() {
            return this.downspeed;
        }

        public int getUploadSpeed() {
            return this.upspeed;
        }

        public boolean hadError() {
            return this.hadError;
        }

        public String getLastError() {
            return this.lastError;
        }

        public String getResultString() {
            StringBuffer sb = new StringBuffer();
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd'T'HHmss z");
            String d = format.format(new Date(this.time));
            sb.append(d).append(" ");
            sb.append("type: BT test ");
            sb.append("mode: ").append(NetworkAdminSpeedTesterBTImpl.this.getMode());
            sb.append(" encrypted: ");
            if (NetworkAdminSpeedTesterBTImpl.this.use_crypto) {
                sb.append("y");
            } else {
                sb.append("n");
            }
            if (this.hadError) {
                sb.append(" Last Error: ").append(this.lastError);
            } else {
                sb.append(" download speed: ").append(this.downspeed).append(" bits/sec");
                sb.append(" upload speed: ").append(this.upspeed).append(" bits/sec");
            }
            return sb.toString();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("[com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminSpeedTesterBTImpl");
            sb.append(" ").append(this.getResultString()).append(" ");
            sb.append("]");
            return sb.toString();
        }
    }

    private class TorrentSpeedTestMonitorThread
    extends Thread {
        List historyDownloadSpeed = new LinkedList();
        List historyUploadSpeed = new LinkedList();
        List timestamps = new LinkedList();
        Download testDownload;
        public static final long MAX_TEST_TIME = 120000L;
        public static final long MAX_PEAK_TIME = 30000L;
        long startTime;
        long peakTime;
        long peakRate;
        public static final String AVE = "ave";
        public static final String STD_DEV = "stddev";

        public TorrentSpeedTestMonitorThread(Download d) {
            this.testDownload = d;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            NetworkAdminSpeedTesterBTImpl networkAdminSpeedTesterBTImpl;
            try {
                HashSet<String> connected_peers = new HashSet<String>();
                HashSet<String> not_choked_peers = new HashSet<String>();
                HashSet<String> not_choking_peers = new HashSet<String>();
                try {
                    this.peakTime = this.startTime = SystemTime.getCurrentTime();
                    boolean testDone = false;
                    long lastTotalTransferredBytes = 0L;
                    NetworkAdminSpeedTesterBTImpl.this.sendStageUpdateToListeners(MessageText.getString("SpeedTestWizard.stage.message.starting"));
                    while (!testDone && !NetworkAdminSpeedTesterBTImpl.this.aborted) {
                        PeerManager pm;
                        int state = this.testDownload.getState();
                        if (state == 8) {
                            String enteredErrorState = MessageText.getString("SpeedTestWizard.abort.message.entered.error", new String[]{this.testDownload.getErrorStateDetails()});
                            NetworkAdminSpeedTesterBTImpl.this.abort(enteredErrorState);
                            break;
                        }
                        if (state == 7) {
                            NetworkAdminSpeedTesterBTImpl.this.abort(MessageText.getString("SpeedTestWizard.abort.message.entered.queued"));
                            break;
                        }
                        if (!this.testDownload.isForceStart()) {
                            this.testDownload.setForceStart(true);
                        }
                        if ((pm = this.testDownload.getPeerManager()) != null) {
                            Peer[] peers = pm.getPeers();
                            for (int i = 0; i < peers.length; ++i) {
                                Peer peer = peers[i];
                                String key = peer.getIp();
                                connected_peers.add(key);
                                if (!peer.isChoked()) {
                                    not_choked_peers.add(key);
                                }
                                if (peer.isChoking()) continue;
                                not_choking_peers.add(key);
                            }
                        }
                        long currTime = SystemTime.getCurrentTime();
                        DownloadStats stats2 = this.testDownload.getStats();
                        this.historyDownloadSpeed.add(NetworkAdminSpeedTesterBTImpl.autoboxLong(stats2.getDownloaded()));
                        this.historyUploadSpeed.add(NetworkAdminSpeedTesterBTImpl.autoboxLong(stats2.getUploaded()));
                        this.timestamps.add(NetworkAdminSpeedTesterBTImpl.autoboxLong(currTime));
                        this.updateTestProgress(currTime, stats2);
                        lastTotalTransferredBytes = this.checkForNewPeakValue(stats2, lastTotalTransferredBytes, currTime);
                        testDone = this.checkForTestDone();
                        if (testDone) break;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ie) {
                            NetworkAdminSpeedTesterBTImpl.this.abort(MessageText.getString("SpeedTestWizard.abort.message.interrupted"));
                            break;
                        }
                    }
                    try {
                        if (this.testDownload.getState() != 7) {
                            try {
                                this.testDownload.stop();
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                        this.testDownload.remove(true, true);
                    }
                    catch (DownloadException de) {
                        NetworkAdminSpeedTesterBTImpl.this.abort("TorrentSpeedTestMonitorThread could not stop the torrent " + this.testDownload.getName(), de);
                    }
                    catch (DownloadRemovalVetoException drve) {
                        NetworkAdminSpeedTesterBTImpl.this.abort("TorrentSpeedTestMonitorTheard could not remove the torrent " + this.testDownload.getName(), drve);
                    }
                }
                catch (Exception e) {
                    NetworkAdminSpeedTesterBTImpl.this.abort(MessageText.getString("SpeedTestWizard.abort.message.execution.failed"), e);
                }
                if (!NetworkAdminSpeedTesterBTImpl.this.aborted) {
                    String connectStats = MessageText.getString("SpeedTestWizard.stage.message.connect.stats", new String[]{"" + connected_peers.size(), "" + not_choked_peers.size(), "" + not_choking_peers.size()});
                    NetworkAdminSpeedTesterBTImpl.this.sendStageUpdateToListeners(connectStats);
                    if (connected_peers.size() == 0) {
                        NetworkAdminSpeedTesterBTImpl.this.abort(MessageText.getString("SpeedTestWizard.abort.message.failed.peers"));
                    } else if (not_choking_peers.size() == 0 && testMode != 1) {
                        NetworkAdminSpeedTesterBTImpl.this.abort(MessageText.getString("SpeedTestWizard.abort.message.insufficient.slots"));
                    } else if (not_choked_peers.size() == 0 && testMode != 0) {
                        NetworkAdminSpeedTesterBTImpl.this.abort(MessageText.getString("SpeedTestWizard.abort.message.not.unchoked"));
                    }
                }
                if (!NetworkAdminSpeedTesterBTImpl.this.aborted) {
                    NetworkAdminSpeedTesterResult r = this.calculateDownloadRate();
                    lastResult = r;
                    AEDiagnosticsLogger diagLogger = AEDiagnostics.getLogger("v3.STres");
                    diagLogger.log(r.toString());
                    NetworkAdminSpeedTesterBTImpl.this.complete(r);
                }
                Object var14_21 = null;
                networkAdminSpeedTesterBTImpl = NetworkAdminSpeedTesterBTImpl.this;
            }
            catch (Throwable throwable) {
                Object var14_22 = null;
                NetworkAdminSpeedTesterBTImpl networkAdminSpeedTesterBTImpl2 = NetworkAdminSpeedTesterBTImpl.this;
                synchronized (networkAdminSpeedTesterBTImpl2) {
                    NetworkAdminSpeedTesterBTImpl.this.test_completed = true;
                    if (NetworkAdminSpeedTesterBTImpl.this.deferred_abort != null) {
                        NetworkAdminSpeedTesterBTImpl.this.sendResultToListeners(new BitTorrentResult(NetworkAdminSpeedTesterBTImpl.this.deferred_abort));
                    }
                }
                throw throwable;
            }
            synchronized (networkAdminSpeedTesterBTImpl) {
                NetworkAdminSpeedTesterBTImpl.this.test_completed = true;
                if (NetworkAdminSpeedTesterBTImpl.this.deferred_abort != null) {
                    NetworkAdminSpeedTesterBTImpl.this.sendResultToListeners(new BitTorrentResult(NetworkAdminSpeedTesterBTImpl.this.deferred_abort));
                }
            }
        }

        public void updateTestProgress(long currTime, DownloadStats stats2) {
            long totalTestTimeUsed = currTime - this.peakTime;
            float percentDownload = (float)totalTestTimeUsed / 30000.0f;
            long totalDownloadTimeUsed = currTime - this.startTime;
            float percentTotal = (float)totalDownloadTimeUsed / 120000.0f;
            float reportedProgress = percentTotal;
            if (percentDownload > reportedProgress) {
                reportedProgress = percentDownload;
            }
            int progressBarVal = Math.round(reportedProgress * 100.0f);
            StringBuffer msg = new StringBuffer("progress: ");
            msg.append(progressBarVal);
            msg.append(" : download ave ");
            msg.append(stats2.getDownloadAverage());
            msg.append(" : upload ave ");
            msg.append(stats2.getUploadAverage());
            msg.append(" : ");
            int totalTimeLeft = (int)((120000L - totalDownloadTimeUsed) / 1000L);
            msg.append(totalTimeLeft);
            msg.append(" : ");
            int testTimeLeft = (int)((30000L - totalTestTimeUsed) / 1000L);
            msg.append(testTimeLeft);
            NetworkAdminSpeedTesterBTImpl.this.sendStageUpdateToListeners(msg.toString());
        }

        private Map calculate(List history) {
            int j;
            int i;
            List deltas = this.convertSumToDeltas(history);
            Collections.sort(deltas);
            int nSamples = deltas.size();
            int nRemove = nSamples / 10;
            for (i = nSamples - 1; i < nSamples - nRemove; --i) {
                deltas.remove(i);
            }
            for (i = 0; i < nRemove; ++i) {
                deltas.remove(0);
            }
            long sumBytes = 0L;
            for (j = 0; j < deltas.size(); ++j) {
                sumBytes += NetworkAdminSpeedTesterBTImpl.autoboxLong(deltas.get(j));
            }
            double aveRate = sumBytes / (long)deltas.size();
            double variance = 0.0;
            for (j = 0; j < deltas.size(); ++j) {
                double s = (double)NetworkAdminSpeedTesterBTImpl.autoboxLong(deltas.get(j)) - aveRate;
                variance += s * s;
            }
            double stddev = Math.sqrt(variance / (double)(j - 1));
            HashMap<String, Double> retVal = new HashMap<String, Double>();
            retVal.put(AVE, NetworkAdminSpeedTesterBTImpl.autoboxDouble(aveRate));
            retVal.put(STD_DEV, NetworkAdminSpeedTesterBTImpl.autoboxDouble(stddev));
            return retVal;
        }

        private List convertSumToDeltas(List sumHistory) {
            int i;
            int numStats = sumHistory.size();
            ArrayList<Long> deltas = new ArrayList<Long>(numStats);
            if (i == 0) {
                return deltas;
            }
            long prevSumDownload = NetworkAdminSpeedTesterBTImpl.autoboxLong(sumHistory.get(i - 1));
            for (i = this.findIndexPeak(numStats); i < numStats; ++i) {
                long currSumDownload = NetworkAdminSpeedTesterBTImpl.autoboxLong(sumHistory.get(i));
                Long currDelta = NetworkAdminSpeedTesterBTImpl.autoboxLong(currSumDownload - prevSumDownload);
                deltas.add(currDelta);
                prevSumDownload = currSumDownload;
            }
            return deltas;
        }

        private int findIndexPeak(int numStats) {
            long thisTime;
            int i;
            for (i = 0; i < numStats && (thisTime = NetworkAdminSpeedTesterBTImpl.autoboxLong(this.timestamps.get(i))) <= this.peakTime; ++i) {
            }
            return i;
        }

        NetworkAdminSpeedTesterResult calculateDownloadRate() {
            Map resDown = this.calculate(this.historyDownloadSpeed);
            Map resUp = this.calculate(this.historyUploadSpeed);
            return new BitTorrentResult(resUp, resDown);
        }

        boolean checkForTestDone() {
            long currTime = SystemTime.getCurrentTime();
            if (currTime - this.startTime > 120000L) {
                return true;
            }
            return currTime - this.peakTime > 30000L;
        }

        long checkForNewPeakValue(DownloadStats stat, long lastTotalDownload, long currTime) {
            long totTransferred = testMode == 0 ? stat.getUploaded() : stat.getDownloaded();
            long currTransferRate = totTransferred - lastTotalDownload;
            if (currTransferRate > this.peakRate) {
                this.peakRate = (long)((double)currTransferRate * 1.1);
                this.peakTime = currTime;
            }
            return totTransferred;
        }
    }
}

