/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.metasearch.impl.web.json;

import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.Result;
import com.aelitis.azureus.core.metasearch.ResultListener;
import com.aelitis.azureus.core.metasearch.SearchException;
import com.aelitis.azureus.core.metasearch.SearchParameter;
import com.aelitis.azureus.core.metasearch.impl.EngineImpl;
import com.aelitis.azureus.core.metasearch.impl.MetaSearchImpl;
import com.aelitis.azureus.core.metasearch.impl.web.FieldMapping;
import com.aelitis.azureus.core.metasearch.impl.web.WebEngine;
import com.aelitis.azureus.core.metasearch.impl.web.WebResult;
import com.aelitis.azureus.util.ImportExportUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class JSONEngine
extends WebEngine {
    private String resultsEntryPath;

    public static EngineImpl importFromBEncodedMap(MetaSearchImpl meta_search, Map map) throws IOException {
        return new JSONEngine(meta_search, map);
    }

    public static Engine importFromJSONString(MetaSearchImpl meta_search, long id, long last_updated, float rank_bias, String name, JSONObject map) throws IOException {
        return new JSONEngine(meta_search, id, last_updated, rank_bias, name, map);
    }

    public JSONEngine(MetaSearchImpl meta_search, long id, long last_updated, float rank_bias, String name, String searchURLFormat, String timeZone, boolean automaticDateFormat, String userDateFormat, String resultsEntryPath, FieldMapping[] mappings, boolean needs_auth, String auth_method, String login_url, String[] required_cookies) {
        super(meta_search, 2, id, last_updated, rank_bias, name, searchURLFormat, timeZone, automaticDateFormat, userDateFormat, mappings, needs_auth, auth_method, login_url, required_cookies);
        this.resultsEntryPath = resultsEntryPath;
        this.setSource(2);
        this.setSelectionState(2);
    }

    protected JSONEngine(MetaSearchImpl meta_search, Map map) throws IOException {
        super(meta_search, map);
        this.resultsEntryPath = ImportExportUtils.importString(map, "json.path");
    }

    protected JSONEngine(MetaSearchImpl meta_search, long id, long last_updated, float rank_bias, String name, JSONObject map) throws IOException {
        super(meta_search, 2, id, last_updated, rank_bias, name, map);
        this.resultsEntryPath = ImportExportUtils.importString(map, "json_result_key");
    }

    public Map exportToBencodedMap() throws IOException {
        return this.exportToBencodedMap(false);
    }

    public Map exportToBencodedMap(boolean generic) throws IOException {
        HashMap res = new HashMap();
        ImportExportUtils.exportString(res, "json.path", this.resultsEntryPath);
        super.exportToBencodedMap(res, generic);
        return res;
    }

    protected void exportToJSONObject(JSONObject res) throws IOException {
        res.put("json_result_key", this.resultsEntryPath);
        super.exportToJSONObject(res);
    }

    protected Result[] searchSupport(SearchParameter[] searchParameters, Map searchContext, int desired_max_matches, int absolute_max_matches, String headers, ResultListener listener) throws SearchException {
        this.debugStart();
        WebEngine.pageDetails page_details = super.getWebPageContent(searchParameters, searchContext, headers, false);
        String page = page_details.getContent();
        if (listener != null) {
            listener.contentReceived(this, page);
        }
        String searchQuery = null;
        for (int i = 0; i < searchParameters.length; ++i) {
            if (!searchParameters[i].getMatchPattern().equals("s")) continue;
            searchQuery = searchParameters[i].getValue();
        }
        FieldMapping[] mappings = this.getMappings();
        try {
            Object jsonObject = JSONValue.parse(page);
            JSONArray resultArray = null;
            if (this.resultsEntryPath != null) {
                JSONArray array;
                StringTokenizer st = new StringTokenizer(this.resultsEntryPath, ".");
                if (jsonObject instanceof JSONArray && st.countTokens() > 0 && (array = (JSONArray)jsonObject).size() == 1) {
                    jsonObject = array.get(0);
                }
                while (st.hasMoreTokens()) {
                    try {
                        jsonObject = ((JSONObject)jsonObject).get(st.nextToken());
                    }
                    catch (Throwable t) {
                        throw new SearchException("Invalid entry path : " + this.resultsEntryPath, t);
                    }
                }
            }
            try {
                resultArray = (JSONArray)jsonObject;
            }
            catch (Throwable t) {
                throw new SearchException("Object is not a result array. Check the JSON service and/or the entry path");
            }
            if (resultArray != null) {
                ArrayList<WebResult> results = new ArrayList<WebResult>();
                for (int i = 0; i < resultArray.size(); ++i) {
                    Object obj = resultArray.get(i);
                    if (!(obj instanceof JSONObject)) continue;
                    JSONObject jsonEntry = (JSONObject)obj;
                    if (absolute_max_matches >= 0 && --absolute_max_matches < 0) break;
                    if (listener != null) {
                        Iterator it = new TreeMap(jsonEntry).entrySet().iterator();
                        String[] groups = new String[jsonEntry.size()];
                        int pos = 0;
                        while (it.hasNext()) {
                            Map.Entry entry = it.next();
                            Object key = entry.getKey();
                            Object value = entry.getValue();
                            if (key != null && value != null) {
                                groups[pos++] = key.toString() + "=" + UrlUtils.encode(value.toString());
                                continue;
                            }
                            groups[pos++] = "";
                        }
                        listener.matchFound(this, groups);
                    }
                    WebResult result = new WebResult(this, this.getRootPage(), this.getBasePage(), this.getDateParser(), searchQuery);
                    block29: for (int j = 0; j < mappings.length; ++j) {
                        String fieldFrom = mappings[j].getName();
                        if (fieldFrom == null) continue;
                        int fieldTo = mappings[j].getField();
                        Object fieldContentObj = jsonEntry.get(fieldFrom);
                        if (fieldContentObj == null) continue;
                        String fieldContent = fieldContentObj.toString();
                        switch (fieldTo) {
                            case 1: {
                                result.setNameFromHTML(fieldContent);
                                continue block29;
                            }
                            case 3: {
                                result.setSizeFromHTML(fieldContent);
                                continue block29;
                            }
                            case 4: {
                                result.setNbPeersFromHTML(fieldContent);
                                continue block29;
                            }
                            case 5: {
                                result.setNbSeedsFromHTML(fieldContent);
                                continue block29;
                            }
                            case 6: {
                                result.setCategoryFromHTML(fieldContent);
                                continue block29;
                            }
                            case 2: {
                                result.setPublishedDateFromHTML(fieldContent);
                                continue block29;
                            }
                            case 7: {
                                result.setCommentsFromHTML(fieldContent);
                                continue block29;
                            }
                            case 103: {
                                result.setCDPLink(fieldContent);
                                continue block29;
                            }
                            case 102: {
                                result.setTorrentLink(fieldContent);
                                continue block29;
                            }
                            case 104: {
                                result.setPlayLink(fieldContent);
                                continue block29;
                            }
                            case 105: {
                                result.setDownloadButtonLink(fieldContent);
                                continue block29;
                            }
                            case 10: {
                                result.setVotesFromHTML(fieldContent);
                                continue block29;
                            }
                            case 11: {
                                result.setNbSuperSeedsFromHTML(fieldContent);
                                continue block29;
                            }
                            case 12: {
                                result.setPrivateFromHTML(fieldContent);
                                continue block29;
                            }
                            case 13: {
                                result.setDrmKey(fieldContent);
                                continue block29;
                            }
                            case 14: {
                                result.setVotesDownFromHTML(fieldContent);
                                continue block29;
                            }
                            case 200: {
                                result.setHash(fieldContent);
                                continue block29;
                            }
                        }
                    }
                    results.add(result);
                }
                Result[] res = results.toArray(new Result[results.size()]);
                this.debugLog("success: found " + res.length + " results");
                return res;
            }
            this.debugLog("success: no result array found so no results");
            return new Result[0];
        }
        catch (Throwable e) {
            this.debugLog("failed: " + Debug.getNestedExceptionMessageAndStack(e));
            if (e instanceof SearchException) {
                throw (SearchException)e;
            }
            throw new SearchException("JSON matching failed", e);
        }
    }

    public String getIcon() {
        String rootPage = this.getRootPage();
        if (rootPage != null) {
            return rootPage + "/favicon.ico";
        }
        return null;
    }
}

